/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.dvt.ui.editor.quickassist.util.CreateChangeStatus;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.refactor.connect.RefactorInputWrapper;
import ro.amiq.dvt.ui.refactor.connect.TextChange;
import ro.amiq.dvt.ui.refactor.designelement.RefactorDesignElementOperation;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfScalarType;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.ui.editor.quickassist.util.VlogQuickAssistUtil;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;
import ro.amiq.vlogdt.ui.refactor.designelement.VlogRefactorInputWrapperFactory;
import ro.amiq.vlogdt.ui.refactor.designelement.VlogRefactorTextChangeFactory;
import ro.amiq.vlogdt.ui.refactor.forwardports.VlogRefactorForwardPortsAlgorithm;

public abstract class QuickAssistForwardAllImplicitConnectionsProposalCommon
extends DVTAbstractQuickAssistProposal {
    protected static final String WIRE = "wire";
    protected static final String LOGIC = "logic";
    protected static final String SIGNAL_DIRECTION_CATEGORY = "signal_direction";
    protected static final String SIGNAL_TYPE_CATEGORY = "signal_type";
    protected String displayString;
    protected DVTEditor targetEditor;
    protected IResource targetResource;
    protected IDocument targetDocument;
    private IRfInstanceElement instance;
    private List<IHidOperator> instancePortConnections;
    protected RfModule enclosingModule;
    protected LinkedModeModel linkedProposalModel;
    private DVTLinkedPositionProvider linkedPositionProvider;
    protected VlogRefactorInputWrapperFactory wrappersFactory = new VlogRefactorInputWrapperFactory();
    protected VlogRefactorTextChangeFactory textChangeFactory = new VlogRefactorTextChangeFactory();
    VlogTextFileChange moduleFileChange;
    protected boolean hasInstances;

    protected QuickAssistForwardAllImplicitConnectionsProposalCommon(IFile file, DVTEditor editor, IDocument document, RfInstance instance, List<IHidOperator> instancePortConnections) {
        this.file = file;
        this.editor = this.targetEditor = editor;
        this.document = this.targetDocument = document;
        this.enclosingModule = instance.getEnclosingScope(RfModule.class);
        this.displayString = "Forward all implicit port connections to '" + this.enclosingModule.getName() + "'";
        this.instancePortConnections = instancePortConnections;
        this.instance = instance;
        this.linkedProposalModel = new LinkedModeModel();
    }

    protected QuickAssistForwardAllImplicitConnectionsProposalCommon() {
    }

    /*
     * WARNING - void declaration
     */
    protected CreateChangeStatus createQuickAssistChanges() throws Exception {
        if (this.instancePortConnections == null || this.instancePortConnections.isEmpty() || this.enclosingModule == null || this.enclosingModule.getDeclaration() == null) {
            return CreateChangeStatus.ERROR;
        }
        RfFileDef moduleFileDef = this.enclosingModule.getDeclaration().getDefFile();
        if (moduleFileDef == null) {
            return CreateChangeStatus.ERROR;
        }
        this.compositeChange = new CompositeChange("All changes");
        ArrayList<RefactorInputWrapper> allChangeWrappers = new ArrayList<RefactorInputWrapper>();
        HashSet<String> newPortsTypes = new HashSet<String>(1);
        HashSet<String> createdPorts = new HashSet<String>(1);
        for (IHidOperator portConnection : this.instancePortConnections) {
            Set<IHidObject> signalsHids = this.computeConnectionSignalHids(portConnection);
            for (IHidObject hid : signalsHids) {
                void port;
                RfPort rfPort;
                IHid portHid;
                IRfNamedElement portNamedElement;
                void field;
                RfField rfField;
                IRfNamedElement signal = HidUtils.getResolvedElement((IHidObject)hid);
                IRfNamedElement iRfNamedElement = signal;
                if (!(iRfNamedElement instanceof RfField) || (rfField = (RfField)iRfNamedElement) != (RfField)iRfNamedElement || !field.isImplicitSignal() || createdPorts.contains(signal.getName()) || !(( instanceOfPatternExpressionValue = (portNamedElement = HidUtils.getResolvedElement((IHidObject)(portHid = PortConnectionUtils.getPortHid((IHidOperator)portConnection))))) instanceof RfPort) || (rfPort = (RfPort) instanceOfPatternExpressionValue) != (RfPort) instanceOfPatternExpressionValue) continue;
                String portDirection = PORT_DIRECTION.INPUT.getName();
                if (port.getDirectionString() != null && !port.getDirectionString().isEmpty()) {
                    portDirection = port.getDirectionString();
                }
                String signalWidth = "";
                String signalType = WIRE;
                IRfNamedElement associatedType = port.getAssociatedType(RfTypesResolver.create((IRfScopeElement)port.getEnclosingScope(), this.enclosingModule.getRfProject(), 0));
                if (associatedType instanceof RfAssociatedType) {
                    signalType = ((RfAssociatedType)associatedType).getAssociatedTypeName();
                    signalWidth = ((RfAssociatedType)associatedType).getPackedDimension();
                } else if (associatedType instanceof RfScalarType) {
                    signalType = associatedType.getName();
                }
                if (signalType.startsWith(LOGIC) && VlogQuickFixUtil.getInstance().isVerilogSyntax(VlogQuickFixUtil.getInstance().getLanguageSyntaxForParserPath((RfProject)this.instance.getRfProject(), this.targetEditor.getParserPath()))) {
                    signalType = signalType.replace(LOGIC, WIRE);
                }
                RefactorInputWrapper refactorInputWrapper = new RefactorInputWrapper(RefactorDesignElementOperation.FORWARD_PORT_CONNECTIONS, (IRfNamedElement)this.enclosingModule, null, false, signal.getName(), portDirection, signalType, "", signalWidth, "", false, false);
                allChangeWrappers.add(refactorInputWrapper);
                createdPorts.add(signal.getName());
                newPortsTypes.add(signalType);
            }
        }
        if (allChangeWrappers.isEmpty()) {
            return CreateChangeStatus.OK;
        }
        allChangeWrappers.sort((w1, w2) -> w1.getDirection().compareTo(w2.getDirection()));
        List<TextChange> targetFileChanges = this.computeTargetFileTextChanges(allChangeWrappers, this.enclosingModule);
        this.populateCompositeChange(moduleFileDef, newPortsTypes, targetFileChanges);
        this.textFileChange = null;
        return CreateChangeStatus.OK;
    }

    protected void populateCompositeChange(RfFileDef moduleFileDef, Set<String> newPortsTypes, List<TextChange> targetFileChanges) {
        HashMap<IFile, ArrayList<TextChange>> textChgsPerFile = new HashMap<IFile, ArrayList<TextChange>>();
        for (TextChange textChange : targetFileChanges) {
            IFile key = textChange.file;
            ArrayList<TextChange> listChgs = (ArrayList<TextChange>)textChgsPerFile.get(key);
            if (listChgs == null) {
                listChgs = new ArrayList<TextChange>();
                textChgsPerFile.put(key, listChgs);
            }
            listChgs.add(textChange);
        }
        for (Map.Entry entry : textChgsPerFile.entrySet()) {
            IFile file = (IFile)entry.getKey();
            VlogTextFileChange fileChange = new VlogTextFileChange(file.getName(), file);
            fileChange.setEdit((TextEdit)new MultiTextEdit());
            if (file.equals((Object)moduleFileDef.getFileAdapter())) {
                this.moduleFileChange = fileChange;
            }
            for (TextChange textChg : (List)entry.getValue()) {
                InsertEdit portListInsertEdit = new InsertEdit(textChg.offset, textChg.text);
                LinkedHashMap<String, List<IRegion>> regions = new LinkedHashMap<String, List<IRegion>>();
                this.computeRegionsByCategory(textChg.text, newPortsTypes, regions);
                fileChange.addEdit((TextEdit)portListInsertEdit, regions);
            }
            this.compositeChange.add((Change)fileChange);
        }
    }

    private Set<IHidObject> computeConnectionSignalHids(IHidOperator portConnection) {
        IHidObject signalHid = PortConnectionUtils.getSignal((IHidOperator)portConnection);
        if (signalHid == null) {
            return Collections.emptySet();
        }
        if (signalHid instanceof HidOperator var3_4) {
            return new HashSet<IHidObject>(operator.getRHHids(VlogQuickAssistUtil.FLATTENING_OPTIONS_IGNORE_IMPLICITS));
        }
        return new HashSet<IHidObject>(Arrays.asList(signalHid));
    }

    protected List<TextChange> computeTargetFileTextChanges(List<RefactorInputWrapper> allChangeWrappers, RfModule enclosingModule) {
        if (enclosingModule == null || allChangeWrappers == null) {
            return null;
        }
        String indent = DVTDocumentUtils.getIndent((int)enclosingModule.getStartOffset(), (IDocument)this.targetDocument);
        indent = String.valueOf(indent) + VlogQuickFixUtil.getInstance().getTabOrSpaces(this.editor, this.targetDocument);
        VlogRefactorForwardPortsAlgorithm addPortAlgorithm = new VlogRefactorForwardPortsAlgorithm(enclosingModule, indent);
        Map<IRfInstanceElement, List<RefactorInputWrapper>> instancesChangeWrapper = this.wrappersFactory.makeInstancesAddMultiplePortsChangeWrappers(allChangeWrappers, enclosingModule, enclosingModule.getRfProject());
        if (instancesChangeWrapper != null && !instancesChangeWrapper.isEmpty()) {
            this.hasInstances = true;
        }
        Set<TextChange> textChanges = addPortAlgorithm.computeChangesFromWrappers(new LinkedHashSet<RefactorInputWrapper>(allChangeWrappers), (IProgressMonitor)new NullProgressMonitor());
        textChanges.addAll(this.textChangeFactory.makeMultiplePortsInstancesTextChanges(instancesChangeWrapper, (IProgressMonitor)new NullProgressMonitor()));
        return new ArrayList<TextChange>(textChanges);
    }

    /*
     * WARNING - void declaration
     */
    protected void addLinkedPositions() throws Exception {
        void textFileChange;
        void var3_2;
        VlogTextFileChange vlogTextFileChange;
        VlogTextFileChange fileChange = this.moduleFileChange;
        VlogTextFileChange vlogTextFileChange2 = fileChange;
        if (!(vlogTextFileChange2 instanceof VlogTextFileChange) || (vlogTextFileChange = vlogTextFileChange2) != (VlogTextFileChange)var3_2) {
            return;
        }
        Collection linkedPositionRegions = textFileChange.getAbsoluteRegionsByCategory(SIGNAL_DIRECTION_CATEGORY);
        if (linkedPositionRegions == null) {
            return;
        }
        if (textFileChange.getAbsoluteRegionsByCategory(SIGNAL_TYPE_CATEGORY) != null) {
            linkedPositionRegions.addAll(textFileChange.getAbsoluteRegionsByCategory(SIGNAL_TYPE_CATEGORY));
        }
        if (linkedPositionRegions.isEmpty()) {
            return;
        }
        this.targetResource = textFileChange.getFile();
        this.targetEditor = (DVTEditor)DVTUiUtils.getEditor((IResource)this.targetResource);
        this.targetDocument = this.targetEditor.getDocument();
        this.linkedPositionProvider = new DVTLinkedPositionProvider(this.targetEditor, this.linkedProposalModel, this.getCategory(), true, (DVTTextFileChange)textFileChange);
        for (IRegion region : linkedPositionRegions) {
            this.linkedPositionProvider.addSingleLinkedPosition(region.getOffset(), region.getLength(), this.targetDocument);
        }
        this.linkedPositionProvider.enterLinkedMode(this.targetDocument, null);
    }

    protected Map<String, List<IRegion>> computeRegionsByCategory(String text, Set<String> portTypes, Map<String, List<IRegion>> regionsByCategory) {
        PORT_DIRECTION[] pORT_DIRECTIONArray = PORT_DIRECTION.values();
        int n = pORT_DIRECTIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            PORT_DIRECTION direction = pORT_DIRECTIONArray[n2];
            List signalDirectionRegion = DVTQuickFixUtil.computeLinkedRegionsForWord((String)text, (String)direction.getName(), (int)0);
            List<IRegion> directionRegions = regionsByCategory.get(SIGNAL_DIRECTION_CATEGORY);
            if (directionRegions == null) {
                directionRegions = new ArrayList<IRegion>();
            }
            directionRegions.addAll(signalDirectionRegion);
            regionsByCategory.put(SIGNAL_DIRECTION_CATEGORY, directionRegions);
            ++n2;
        }
        if (portTypes == null) {
            return regionsByCategory;
        }
        for (String type : portTypes) {
            List signalTypeRegion = DVTQuickFixUtil.computeLinkedRegionsForWord((String)text, (String)type, (int)0);
            List<IRegion> typeRegions = regionsByCategory.get(SIGNAL_TYPE_CATEGORY);
            if (typeRegions == null) {
                typeRegions = new ArrayList<IRegion>();
            }
            typeRegions.addAll(signalTypeRegion);
            regionsByCategory.put(SIGNAL_TYPE_CATEGORY, typeRegions);
        }
        return regionsByCategory;
    }

    protected IFile[] getAffectedFiles() throws Exception {
        Object[] affectedObjects = this.compositeChange.getAffectedObjects();
        IFile[] affectedFiles = new IFile[affectedObjects.length];
        int i = 0;
        while (i < affectedObjects.length) {
            Object affectedObject = affectedObjects[i];
            if (affectedObject instanceof IFile) {
                affectedFiles[i] = (IFile)affectedObject;
            }
            ++i;
        }
        return affectedFiles;
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_MODULE_INSTANCE);
    }

    protected String getDisplayStringInternal() throws Exception {
        return this.displayString;
    }

    protected String getProposalName() {
        return "Forward all implicit port connections to '" + this.enclosingModule.getName() + "'";
    }

    private String getCategory() {
        return "QuickAssistProposalCategory_" + ((Object)((Object)this)).toString();
    }

    protected static enum PORT_DIRECTION {
        INPUT("input"),
        OUTPUT("output"),
        INOUT("inout");

        private String name;

        private PORT_DIRECTION(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

