/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickassist.util.CreateChangeStatus;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;
import ro.amiq.dvt.ui.refactor.connect.RefactorInputWrapper;
import ro.amiq.dvt.ui.refactor.connect.TextChange;
import ro.amiq.dvt.ui.refactor.designelement.RefactorDesignElementOperation;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfScalarType;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.ui.editor.quickassist.QuickAssistForwardAllImplicitConnectionsProposalCommon;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;

public abstract class QuickAssistForwardImplicitPortConnectionProposalCommon
extends QuickAssistForwardAllImplicitConnectionsProposalCommon {
    private RfNamedElement elementAtCursor;
    private RfFileDef moduleFileDef;
    private RfPort connectedPort;
    private String portDirection;
    private String portWidth;
    private String portType;

    protected QuickAssistForwardImplicitPortConnectionProposalCommon(IFile file, DVTEditor editor, IDocument document, RfNamedElement elementAtCursor, RfPort port, RfNamedElement enclosingModule) {
        this.file = file;
        this.editor = this.targetEditor = editor;
        this.document = this.targetDocument = document;
        this.linkedProposalModel = new LinkedModeModel();
        this.connectedPort = port;
        this.elementAtCursor = elementAtCursor;
        this.enclosingModule = (RfModule)enclosingModule;
        this.displayString = "Forward implicit port connection '" + elementAtCursor.getName() + "' to '" + enclosingModule.getName() + "'";
    }

    @Override
    protected CreateChangeStatus createQuickAssistChanges() throws Exception {
        try {
            RfDefElement declaration = this.enclosingModule.getDeclaration();
            if (declaration == null || declaration.getDefFile() == null) {
                return CreateChangeStatus.ERROR;
            }
            this.moduleFileDef = declaration.getDefFile();
            this.compositeChange = new CompositeChange("All changes");
            this.computeInfo();
            RefactorInputWrapper refactorInputWrapper = new RefactorInputWrapper(RefactorDesignElementOperation.FORWARD_PORT_CONNECTIONS, (IRfNamedElement)this.enclosingModule, null, false, this.elementAtCursor.getName(), this.portDirection, this.portType, "", this.portWidth, "", false, false);
            List<TextChange> targetFileChanges = this.computeTargetFileTextChanges(Arrays.asList(refactorInputWrapper), this.enclosingModule);
            this.populateCompositeChange(this.moduleFileDef, null, targetFileChanges);
            this.textFileChange = null;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return CreateChangeStatus.OK;
    }

    protected void computeInfo() {
        this.portDirection = QuickAssistForwardAllImplicitConnectionsProposalCommon.PORT_DIRECTION.INPUT.getName();
        if (this.connectedPort.getDirectionString() != null && !this.connectedPort.getDirectionString().isEmpty()) {
            this.portDirection = this.connectedPort.getDirectionString();
        }
        this.portWidth = "";
        this.portType = "wire";
        IRfNamedElement associatedType = this.connectedPort.getAssociatedType(RfTypesResolver.create((IRfScopeElement)this.connectedPort.getEnclosingScope(), this.enclosingModule.getRfProject(), 0));
        if (associatedType instanceof RfAssociatedType) {
            this.portType = ((RfAssociatedType)associatedType).getAssociatedTypeName();
            this.portWidth = ((RfAssociatedType)associatedType).getPackedDimension();
        } else if (associatedType instanceof RfScalarType) {
            this.portType = associatedType.getName();
        }
        if (this.portType.startsWith("logic") && VlogQuickFixUtil.getInstance().isVerilogSyntax(VlogQuickFixUtil.getInstance().getLanguageSyntaxForParserPath(this.connectedPort.getRfProject(), this.editor.getParserPath()))) {
            this.portType = this.portType.replace("logic", "wire");
        }
    }

    @Override
    protected Map<String, List<IRegion>> computeRegionsByCategory(String text, Set<String> portTypes, Map<String, List<IRegion>> regionsByCategory) {
        List portTypeRegions;
        List portDirectionRegions = DVTQuickFixUtil.computeLinkedRegionsForWord((String)text, (String)this.portDirection, (int)0);
        if (portDirectionRegions != null && !portDirectionRegions.isEmpty()) {
            regionsByCategory.put("signal_direction", portDirectionRegions);
        }
        if ((portTypeRegions = DVTQuickFixUtil.computeLinkedRegionsForWord((String)text, (String)this.portType, (int)0)) != null && !portTypeRegions.isEmpty()) {
            regionsByCategory.put("signal_type", portTypeRegions);
        }
        return regionsByCategory;
    }

    @Override
    protected String getProposalName() {
        return "Forward implicit port connection '" + this.elementAtCursor.getName() + "' to '" + this.enclosingModule.getName() + "'";
    }
}

