/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.dvt.ui.editor.quickassist.util.CreateChangeStatus;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;

public abstract class QuickAssistFunctionCallArgumentsProposal
extends DVTAbstractQuickAssistProposal {
    protected Region methodCallRegion;
    protected List<? extends IHidObject> args;
    protected IRfNamedElement methodNamedElement;

    protected QuickAssistFunctionCallArgumentsProposal(IFile file, DVTEditor editor, IDocument document, Region methodCallRegion, List<? extends IHidObject> args, IRfNamedElement methodNamedElement) {
        this.file = file;
        this.editor = editor;
        this.document = document;
        this.methodCallRegion = methodCallRegion;
        this.args = args;
        this.methodNamedElement = methodNamedElement;
    }

    protected void preApplyQuickAssist(IDocument document) throws Exception {
        if (this.file == null || this.methodNamedElement == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    public void applyQuickAssist(IDocument document) {
        this.performChanges();
    }

    protected CreateChangeStatus createQuickAssistChanges() throws Exception {
        this.textFileChange = new VlogTextFileChange(this.file.getProjectRelativePath().toOSString(), this.file);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        List<RfField> funcArgs = ((RfFunction)this.methodNamedElement).getArgumentsWithPrefix("", 0);
        List<IRegion> functionCallArgRegions = this.getArgRegions();
        return this.addArgumentEdits(funcArgs, functionCallArgRegions) ? CreateChangeStatus.OK : CreateChangeStatus.ERROR;
    }

    protected List<IRegion> getArgRegions() throws BadLocationException {
        ArrayList<IRegion> functionCallArgRegions = new ArrayList<IRegion>();
        for (IHidObject iHidObject : this.args) {
            int argumentStart = MethodCallUtils.getOpenBoundary((IHidObject)iHidObject);
            int argumentEnd = MethodCallUtils.getClosedBoundary((IHidObject)iHidObject);
            Region argumentRegion = null;
            argumentRegion = this.emptyArg(argumentStart, argumentEnd) ? new Region(argumentStart + 1, 0) : new Region(argumentStart, argumentEnd - argumentStart);
            functionCallArgRegions.add((IRegion)argumentRegion);
        }
        return functionCallArgRegions;
    }

    private boolean emptyArg(int argumentStart, int argumentEnd) throws BadLocationException {
        return argumentEnd - argumentStart == 1 && (this.document.get(argumentStart, 1).equals("(") || this.document.get(argumentStart, 1).equals(","));
    }

    protected void performChanges() {
        try {
            DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)this.editor, this.document, this.getDisplayString(), (Change)this.textFileChange);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected IFile[] getAffectedFiles() throws Exception {
        Object[] affectedObjects = this.textFileChange.getAffectedObjects();
        IFile[] affectedFiles = new IFile[affectedObjects.length];
        int i = 0;
        while (i < affectedObjects.length) {
            Object affectedObject = affectedObjects[i];
            if (affectedObject instanceof IFile) {
                affectedFiles[i] = (IFile)affectedObject;
            }
            ++i;
        }
        return affectedFiles;
    }

    public Image getImage() {
        return ((RfFunction)this.methodNamedElement).isTask() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_TASK) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_FUNCTION);
    }

    public abstract boolean addArgumentEdits(List<RfField> var1, List<IRegion> var2);
}

