/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.ui.editor.VlogWordFinder;
import ro.amiq.vlogdt.ui.editor.quickassist.QuickAssistFunctionCallArgumentsProposal;

public class QuickAssistFunctionCallArgumentsToOrderedProposal
extends QuickAssistFunctionCallArgumentsProposal {
    public QuickAssistFunctionCallArgumentsToOrderedProposal(IFile fFile, DVTEditor fEditor, IDocument fDocument, Region methodCallRegion, List<? extends IHidObject> args, IRfNamedElement methodNamedElement) {
        super(fFile, fEditor, fDocument, methodCallRegion, args, methodNamedElement);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean addArgumentEdits(List<RfField> funcArgs, List<IRegion> functionCallArgRegions) {
        try {
            HashMap<String, String> funcCallArgsByValue = new HashMap<String, String>();
            VlogWordFinder wordFinder = new VlogWordFinder();
            int i = 0;
            while (i < functionCallArgRegions.size()) {
                IRegion funcCallArgRegion = functionCallArgRegions.get(i);
                this.deleteArgEdit(funcCallArgRegion);
                String argName = this.getArgumentNameFromRegion(funcCallArgRegion, wordFinder);
                if (argName == null) {
                    return false;
                }
                String argValue = this.getArgValueFromRegion(funcCallArgRegion);
                if (argValue == null) {
                    return false;
                }
                funcCallArgsByValue.put(argName, argValue);
                ++i;
            }
            i = 0;
            while (i < funcArgs.size()) {
                String funcArgName = funcArgs.get(i).getName();
                if (funcArgName == null) {
                    return false;
                }
                String insertString = "";
                int insertOffset = -1;
                if (i >= functionCallArgRegions.size()) {
                    insertOffset = this.methodCallRegion.getOffset() + this.methodCallRegion.getLength() - 1;
                    if (funcCallArgsByValue.containsKey(funcArgName)) {
                        insertString = ", ";
                        insertString = String.valueOf(insertString) + (String)funcCallArgsByValue.get(funcArgName);
                    }
                } else {
                    insertOffset = DVTDocumentUtils.getCharOffset((char)'.', (int)(functionCallArgRegions.get(i).getOffset() + 1), (boolean)false, (int)100, (IDocument)this.document, (String)"__vlog_partitioning") - 1;
                    if (funcCallArgsByValue.containsKey(funcArgName)) {
                        insertString = (String)funcCallArgsByValue.get(funcArgName);
                    }
                }
                if (insertOffset < 0) {
                    return false;
                }
                this.textFileChange.addEdit((TextEdit)new InsertEdit(insertOffset, insertString));
                ++i;
            }
            return true;
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
            return false;
        }
    }

    private String getArgumentNameFromRegion(IRegion funcCallArgRegion, VlogWordFinder wordFinder) throws BadLocationException, BadPartitioningException {
        int dotOffset = DVTDocumentUtils.getCharOffset((char)'.', (int)funcCallArgRegion.getOffset(), (boolean)false, (int)100, (IDocument)this.document, (String)"__vlog_partitioning");
        if (dotOffset < 0) {
            return null;
        }
        int argNameStart = DVTDocumentUtils.nextCodeCharOffset((IDocument)this.document, (int)dotOffset, (boolean)true, (String)"__vlog_partitioning");
        if (argNameStart < 0 || argNameStart >= this.document.getLength()) {
            return null;
        }
        IRegion wordAtOffset = wordFinder.getWordAtOffset(this.document, argNameStart);
        if (wordAtOffset == null) {
            return null;
        }
        return this.document.get(wordAtOffset.getOffset(), wordAtOffset.getLength());
    }

    private String getArgValueFromRegion(IRegion argRegionToReplace) throws BadLocationException, BadPartitioningException {
        int argValueStart = DVTDocumentUtils.getCharOffset((char)'(', (int)argRegionToReplace.getOffset(), (boolean)true, (int)100, (IDocument)this.document, (String)"__vlog_partitioning") + 1;
        if (argValueStart < 0 || argValueStart > this.document.getLength()) {
            return null;
        }
        int argValueEnd = DVTDocumentUtils.getMatchingRightBracketOffset((int)argValueStart, (DVTEditor)this.editor, (IDocument)this.document) - 1;
        if (argValueEnd < 0 || argValueEnd > this.document.getLength()) {
            return null;
        }
        return this.document.get(argValueStart, argValueEnd - argValueStart);
    }

    protected int deleteArgEdit(IRegion argRegion) throws BadLocationException, BadPartitioningException {
        int dotOffset = DVTDocumentUtils.getCharOffset((char)'.', (int)(argRegion.getOffset() + 1), (boolean)false, (int)100, (IDocument)this.document, (String)"__vlog_partitioning") - 1;
        DeleteEdit deleteEdit = new DeleteEdit(dotOffset, argRegion.getLength() + argRegion.getOffset() - dotOffset);
        this.textFileChange.addEdit((TextEdit)deleteEdit);
        return dotOffset;
    }

    public String getDisplayStringInternal() {
        return "Bind method call arguments by position";
    }

    protected String getProposalName() {
        return this.getDisplayStringInternal();
    }
}

