/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.dvt.ui.editor.quickassist.util.CreateChangeStatus;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.TextFileBufferInfo;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.ui.editor.quickassist.util.VlogQuickAssistUtil;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;
import ro.amiq.vlogdt.utils.VlogFileUtils;

public abstract class QuickAssistJoinExternProposalCommon
extends DVTAbstractQuickAssistProposal {
    protected DVTEditor prototypeEditor;
    protected IDocument prototypeDocument;
    protected IDocument implementationDocument;
    protected boolean isQATriggeredOnPrototype;
    protected VlogTextFileChange changeInPrototypeFile;
    protected VlogTextFileChange changeInImplementationFile;
    protected RfDefElement implementation;
    protected RfDefElement prototype;
    protected ITextFileBufferManager bufferManager;
    protected boolean shouldDisconnect;
    protected RfFileDef prototypeDefFile;
    protected RfFileDef implementationDefFile;
    protected IPath path;
    protected LocationKind locationKind;

    protected QuickAssistJoinExternProposalCommon(RfDefElement defElement, boolean isPrototype) {
        this.isQATriggeredOnPrototype = isPrototype;
        this.prototype = this.getPrototypeFromNamedElement(defElement);
        this.implementation = defElement.getNamedElement().getImplementation();
    }

    protected void preApplyQuickAssist(IDocument document) throws CoreException {
        this.implementationDocument = this.prototypeDocument = document;
        this.prototypeEditor = (DVTEditor)DVTUiUtils.getEditor((IDocument)document);
        if (this.prototypeEditor == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        this.initDocumentAndEditorForSeparateFiles();
    }

    public void applyQuickAssist(IDocument document) throws Exception {
        DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)this.prototypeEditor, this.prototypeDocument, this.getDisplayString(), (Change)this.compositeChange);
        this.setCursorFocus(this.changeInPrototypeFile.getEdit().getOffset(), 0);
        if (this.shouldDisconnect) {
            this.bufferManager.disconnect(this.path, this.locationKind, null);
        }
    }

    private void initDocumentAndEditorForSeparateFiles() throws CoreException {
        this.implementationDefFile = this.implementation.getDefFile();
        this.prototypeDefFile = this.prototype.getDefFile();
        if (this.implementationDefFile == null || this.prototypeDefFile == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        this.bufferManager = FileBuffers.getTextFileBufferManager();
        this.path = null;
        this.locationKind = LocationKind.NORMALIZE;
        this.shouldDisconnect = false;
        if (this.isQATriggeredOnPrototype) {
            this.implementationDocument = this.getDocumentFromFileDef(this.implementationDefFile);
            if (this.implementationDocument == null) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
        } else {
            this.prototypeDocument = this.getDocumentFromFileDef(this.prototypeDefFile);
            if (this.prototypeDocument == null) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            IResource fileAdapter = this.prototypeDefFile.getFileAdapter();
            this.prototypeEditor = (DVTEditor)DVTUiUtils.getEditor((IResource)fileAdapter);
        }
    }

    private IDocument getDocumentFromFileDef(RfFileDef fileDef) throws CoreException {
        IResource fileAdapter = fileDef.getFileAdapter();
        TextFileBufferInfo textFileBufferInfo = DVTFileUtils.getInstance().getTextFileBufferInfo((IFile)fileAdapter);
        this.path = textFileBufferInfo.getPath();
        this.locationKind = textFileBufferInfo.getLocationKind();
        ITextFileBuffer textFileBuffer = this.bufferManager.getTextFileBuffer(this.path, this.locationKind);
        if (textFileBuffer == null) {
            this.shouldDisconnect = true;
            this.bufferManager.connect(this.path, this.locationKind, null);
            textFileBuffer = this.bufferManager.getTextFileBuffer(this.path, this.locationKind);
        }
        if (textFileBuffer != null) {
            return textFileBuffer.getDocument();
        }
        return null;
    }

    private CompositeChange createCompositeChange() {
        CompositeChange compositeChange = new CompositeChange(this.getChangeName());
        if (this.implementationDocument.equals(this.prototypeDocument)) {
            compositeChange.add((Change)this.changeInPrototypeFile);
        } else {
            compositeChange.add((Change)this.changeInImplementationFile);
            compositeChange.add((Change)this.changeInPrototypeFile);
        }
        return compositeChange;
    }

    protected CreateChangeStatus createQuickAssistChanges() throws Exception {
        this.createChangeInPrototypeFile();
        this.createChangeInImplementationFile();
        this.compositeChange = this.createCompositeChange();
        if (this.compositeChange == null) {
            return CreateChangeStatus.ERROR;
        }
        return CreateChangeStatus.OK;
    }

    private void createChangeInPrototypeFile() throws Exception {
        IResource prototypeFileAdapter = this.prototypeDefFile.getFileAdapter();
        this.changeInPrototypeFile = new VlogTextFileChange(prototypeFileAdapter.getProjectRelativePath().toOSString(), (IFile)prototypeFileAdapter);
        this.changeInPrototypeFile.setEdit((TextEdit)new MultiTextEdit());
        IRegion prototypeStartLineInfo = this.prototypeDocument.getLineInformationOfOffset(this.prototype.getStartOffset());
        IRegion prototypeEndLineInfo = this.prototypeDocument.getLineInformationOfOffset(this.prototype.getEndOffset());
        int startReplaceOffset = prototypeStartLineInfo.getOffset();
        int endReplaceOffset = prototypeEndLineInfo.getOffset() + prototypeEndLineInfo.getLength();
        IRegion bodyRegion = VlogQuickAssistUtil.getBodyRegion(this.implementation, this.implementationDocument, this.getStartBodyChar());
        String body = this.implementationDocument.get(bodyRegion.getOffset(), bodyRegion.getLength());
        Matcher matcher = DVTStringUtil.LEADING_NEW_LINE.matcher(body);
        if (matcher.find()) {
            body = DVTStringUtil.replaceFirst((Pattern)DVTStringUtil.NEW_LINE, (CharSequence)body, (String)"");
        }
        String indent = DVTDocumentUtils.getIndent((int)this.prototype.getStartOffset(), (IDocument)this.prototypeDocument);
        int relativeIndentOffset = VlogQuickAssistUtil.getLineFirstCharOffsetInLine(this.implementation.getStartOffset(), this.implementationDocument);
        String bodyRelativeIndent = DVTDocumentUtils.getIndent((int)relativeIndentOffset, (IDocument)this.implementationDocument);
        if (body.trim().isEmpty()) {
            body = body.trim();
        }
        String signature = this.getJoinedImplementation(startReplaceOffset, indent, body, bodyRelativeIndent);
        ReplaceEdit replaceEdit = new ReplaceEdit(startReplaceOffset, endReplaceOffset - startReplaceOffset, String.valueOf(indent) + signature.trim());
        this.changeInPrototypeFile.addEdit((TextEdit)replaceEdit);
    }

    private void createChangeInImplementationFile() throws MalformedTreeException, BadLocationException {
        IRegion startLineInfo = this.implementationDocument.getLineInformationOfOffset(this.implementation.getStartOffset());
        IRegion endLineInfo = this.implementationDocument.getLineInformationOfOffset(this.getElementEndOffset());
        int startDeleteOffset = startLineInfo.getOffset();
        int endDeleteOffset = endLineInfo.getOffset() + endLineInfo.getLength();
        int length = endDeleteOffset - startDeleteOffset;
        DeleteEdit deleteEdit = new DeleteEdit(startDeleteOffset, length);
        if (this.implementationDocument.equals(this.prototypeDocument)) {
            this.changeInPrototypeFile.addEdit((TextEdit)deleteEdit);
        } else {
            IResource implementationFileAdapter = this.implementationDefFile.getFileAdapter();
            this.changeInImplementationFile = new VlogTextFileChange(implementationFileAdapter.getProjectRelativePath().toOSString(), (IFile)implementationFileAdapter);
            this.changeInImplementationFile.setEdit((TextEdit)new MultiTextEdit());
            this.changeInImplementationFile.addEdit((TextEdit)deleteEdit);
        }
    }

    protected IFile[] getAffectedFiles() throws Exception {
        Object[] affectedObjects = this.compositeChange.getAffectedObjects();
        IFile[] affectedFiles = new IFile[affectedObjects.length];
        int i = 0;
        while (i < affectedObjects.length) {
            Object affectedObject = affectedObjects[i];
            if (affectedObject instanceof IFile) {
                affectedFiles[i] = (IFile)affectedObject;
            }
            ++i;
        }
        return affectedFiles;
    }

    public String getDisplayStringInternal() {
        return "Join extern " + this.getElementKind() + " prototype and implementation";
    }

    protected String getProposalName() {
        return this.getDisplayStringInternal();
    }

    public DVTFileUtils getFileUtils() {
        return VlogFileUtils.getInstance();
    }

    protected abstract RfDefElement getPrototypeFromNamedElement(RfDefElement var1);

    protected abstract String getJoinedImplementation(int var1, String var2, String var3, String var4);

    protected abstract char getStartBodyChar();

    protected abstract int getElementEndOffset();

    protected abstract String getElementKind();

    protected abstract String getChangeName();

    protected abstract void setCursorFocus(int var1, int var2);
}

