/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public class QuickAssistModuleAssignVisitor
implements IHidVisitor<RfHidOperator> {
    private int selectionStartOffset;
    private int selectionEndOffset;
    private ParserPath selectionParserPath;
    protected ParserPath parserPath;
    private Map<RfHidOperator, Set<IRfNamedElement>> elementsReferencedOutsideSelectionByAssign = new HashMap<RfHidOperator, Set<IRfNamedElement>>();
    private List<IHid> fieldsAssignedAtDeclaration = new ArrayList<IHid>();

    public QuickAssistModuleAssignVisitor(int selectionStartOffset, int selectionEndOffset, ParserPath selectionParserPath) {
        this.selectionStartOffset = selectionStartOffset;
        this.selectionEndOffset = selectionEndOffset;
        this.selectionParserPath = selectionParserPath;
    }

    public boolean visit(RfHidOperator hidOperator) {
        if (this.selectionStartOffset >= hidOperator.getOpenBoundary() && this.selectionEndOffset <= hidOperator.getCloseBoundary()) {
            return true;
        }
        if (!this.parserPath.equals((Object)this.selectionParserPath)) {
            return false;
        }
        if (DVTQuickFixUtil.isOperatorInSelection((HidOperator)hidOperator, (int)this.selectionStartOffset, (int)this.selectionEndOffset)) {
            return false;
        }
        if (hidOperator.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN)) {
            Set lh = hidOperator.getLHHids(HidFlatteningOption.NONE_EXCLUDED);
            if (lh == null) {
                return true;
            }
            this.fieldsAssignedAtDeclaration.addAll(lh);
        }
        if (!hidOperator.hasOccurrence(HidOperatorQualifier.IS_CONTINUOUS_ASSIGN)) {
            return true;
        }
        Set<IRfNamedElement> setOfAssign = this.getElementsReferencedOutsideSelectionByAssign().get(hidOperator);
        if (setOfAssign == null) {
            setOfAssign = new HashSet<IRfNamedElement>();
            this.getElementsReferencedOutsideSelectionByAssign().put(hidOperator, setOfAssign);
        }
        for (IHid hid : hidOperator.getLHHids(HidFlatteningOption.NONE_EXCLUDED)) {
            setOfAssign.add(hid.getElement());
        }
        for (IHid hid : hidOperator.getRHHids(HidFlatteningOption.NONE_EXCLUDED)) {
            setOfAssign.add(hid.getElement());
        }
        return true;
    }

    public Class<RfHidOperator> getType() {
        return RfHidOperator.class;
    }

    public void setParserPath(ParserPath parserPath) {
        this.parserPath = parserPath;
    }

    public Map<RfHidOperator, Set<IRfNamedElement>> getElementsReferencedOutsideSelectionByAssign() {
        return this.elementsReferencedOutsideSelectionByAssign;
    }

    public List<IHid> getFieldsAssignedAtDeclaration() {
        return this.fieldsAssignedAtDeclaration;
    }
}

