/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.util.IdentityHashMap;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.ui.search.HidMatch;
import ro.amiq.dvt.ui.search.RWKind;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public class QuickAssistModulePortConnectionVisitor
implements IHidVisitor<RfHidOperator> {
    private Map<Hid, HidMatch> rwMap;

    public QuickAssistModulePortConnectionVisitor(IdentityHashMap<Hid, HidMatch> rwMap) {
        this.rwMap = rwMap;
    }

    public boolean visit(RfHidOperator hidOperator) {
        if (!hidOperator.isAssociation()) {
            return true;
        }
        boolean isPortConnection = hidOperator.hasQualifier(HidOperatorQualifier.IS_PORT_CONNECTION.value());
        if (!isPortConnection) {
            return true;
        }
        ListContainer rhHidObjects = hidOperator.getRHValues();
        IHidObject lhHidObject = hidOperator.getLHValue();
        IRfNamedElement portElement = this.getPort(lhHidObject);
        for (IHidObject hidObject : rhHidObjects) {
            RfHid hid;
            HidMatch hidMatch;
            if (!HidUtils.isHid((IHidObject)hidObject) && !(hidObject instanceof RfHidAccess) || (hidMatch = this.rwMap.get((Object)(hid = hidObject instanceof RfHidAccess ? (RfHid)((RfHidAccess)hidObject).getParentHid() : (RfHid)hidObject))) == null) continue;
            IRfNamedElement signalElement = hid.getElement();
            RWKind writeAccess = RfSearchUtils.computePortArgumentConnectionWriteAccess((IRfNamedElement)portElement, (IRfNamedElement)signalElement, (boolean)true, (RWKind)RWKind.NONE);
            if (writeAccess == RWKind.READ_WRITE) {
                hidMatch.addReadOccurence(hid.getOccurrence());
                hidMatch.addWriteOccurence(hid.getOccurrence());
                continue;
            }
            if (writeAccess == RWKind.READ) {
                hidMatch.addReadOccurence(hid.getOccurrence());
                continue;
            }
            if (writeAccess != RWKind.WRITE) continue;
            hidMatch.addWriteOccurence(hid.getOccurrence());
        }
        return true;
    }

    private IRfNamedElement getPort(IHidObject hidObject) {
        if (!HidUtils.isHid((IHidObject)hidObject)) {
            return null;
        }
        RfHid hid = (RfHid)hidObject;
        IRfNamedElement element = hid.getElement();
        return element;
    }

    public Class<RfHidOperator> getType() {
        return RfHidOperator.class;
    }
}

