/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.text.StrSubstitutor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickassist.util.CreateChangeStatus;
import ro.amiq.dvt.ui.editor.quickassist.util.DVTQuickAssistUtil;
import ro.amiq.dvt.ui.editor.textchanges.DVTFileModificationValidator;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.dvt.wizards.newfile.FormatNewFileContentPatternType;
import ro.amiq.dvt.wizards.newfile.IOperationType;
import ro.amiq.dvt.wizards.newfile.NewFileWithCustomContentWizard;
import ro.amiq.dvt.wizards.newfile.QuickFixOrAssistType;
import ro.amiq.vlogdt.ui.editor.quickassist.QuickAssistMoveSelectionToNewFileProposalCommon;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;

public class QuickAssistMoveSelectionToNewFileProposal
extends QuickAssistMoveSelectionToNewFileProposalCommon {
    private QuickFixOrAssistType fixOrAssistType;
    private String wizardFilePattern;

    public QuickAssistMoveSelectionToNewFileProposal(int startOffset, String startIndent, String selectedText, IFile file, IFile includeFileForExtractToModule, FormatNewFileContentPatternType patternType, QuickFixOrAssistType assistType, String filePattern, String targetFilePath, String targetFileNameWithoutExtension) {
        super(startOffset, startIndent, selectedText, file, includeFileForExtractToModule, patternType);
        this.fixOrAssistType = assistType;
        this.wizardFilePattern = filePattern;
    }

    public void preApplyQuickAssist(IDocument document) throws Exception {
        IEditorPart activeEditor = DVTUiUtils.getActivePage().getActiveEditor();
        if (!(activeEditor instanceof DVTEditor)) {
            DVTQuickAssistUtil.popSomethingWentWrong((String)"Move selection to new file...");
            return;
        }
        this.triggerDocument = document;
        this.triggerEditor = (DVTEditor)activeEditor;
    }

    public CreateChangeStatus createQuickAssistChanges() throws Exception {
        int open;
        DVTFileModificationValidator.validateEdit(null, (IFile[])new IFile[]{this.triggerFile});
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        StructuredSelection ss = null;
        IResource lastSelectedResource = DVTPlugin.getSelectionManager().getLastSelectedResource();
        if (lastSelectedResource != null) {
            ss = new StructuredSelection((Object)lastSelectedResource);
        }
        IPath closestContainerPath = this.computeClosestContainer();
        IPath closestIncDirPath = this.computeClosestIncDir();
        NewFileWithCustomContentWizard wizard = new NewFileWithCustomContentWizard(this.getFileContent(this.selectedText), closestContainerPath, this.patternType, (IOperationType)this.fixOrAssistType, this.wizardFilePattern);
        wizard.init(window.getWorkbench(), (IStructuredSelection)ss);
        WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)wizard);
        if (TestHelper.isTestMode()) {
            this.testPressFinish(dialog);
        }
        if ((open = dialog.open()) == 1) {
            return CreateChangeStatus.CANCEL;
        }
        this.targetFileNameWithoutExtension = wizard.getFileNameWithoutExtension();
        if (this.targetFileNameWithoutExtension == null || this.targetFileNameWithoutExtension.isEmpty()) {
            return CreateChangeStatus.ERROR;
        }
        String fileName = this.getIncludeStringPath(closestIncDirPath, wizard.getFile());
        Map substMap = DVTQuickAssistUtil.makeCommentSubstMap(Arrays.asList(FormatNewFileContentPatternType.FILE_NAME.getPattern()), Arrays.asList(fileName));
        String includePattern = String.valueOf(this.triggerEditor.getNewLineDelimiter()) + this.startIndent + INCLUDE_STATEMENT + this.triggerEditor.getNewLineDelimiter();
        String triggerReplacementString = StrSubstitutor.replace((Object)includePattern, (Map)substMap, (String)DVTQuickAssistUtil.STR_SUBSTITUTOR_PREFIX, (String)DVTQuickAssistUtil.STR_SUBSTITUTOR_SUFFIX);
        this.textFileChange = this.includeFileForExtractToModule != null ? new VlogTextFileChange(this.includeFileForExtractToModule.getProjectRelativePath().toOSString(), this.includeFileForExtractToModule) : new VlogTextFileChange(this.triggerFile.getProjectRelativePath().toOSString(), this.triggerFile);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        this.computeChangeForTriggerFile(triggerReplacementString);
        return CreateChangeStatus.OK;
    }

    private void testPressFinish(final WizardDialog dialog) {
        Display display = Display.getDefault();
        display.asyncExec(() -> display.timerExec(200, new Runnable(){

            @Override
            public void run() {
                try {
                    Class<?> clazz = dialog.getClass();
                    Method method = clazz.getDeclaredMethod("finishPressed", new Class[0]);
                    method.setAccessible(true);
                    method.invoke((Object)dialog, new Object[0]);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        }));
    }

    protected void applyQuickAssist(IDocument document) throws Exception {
        DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)this.triggerEditor, this.triggerDocument, "Move selection to new file...", (Change)this.textFileChange);
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.DESC_VLOG_MODULE);
    }

    public CompositeChange getChanges() {
        this.compositeChange = new CompositeChange("_new_file_");
        this.compositeChange.add((Change)this.textFileChange);
        return this.compositeChange;
    }

    public void setTargetFilePath(String path) {
    }

    public CompositeChange getCompositeChanges() {
        return null;
    }
}

