/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.dvt.ui.editor.quickassist.util.DVTQuickAssistUtil;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.wizards.newfile.FormatNewFileContentPatternType;
import ro.amiq.vlogdt.ui.editor.quickfix.util.QuickFixIncludedFileInfo;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;

public abstract class QuickAssistMoveSelectionToNewFileProposalCommon
extends DVTAbstractQuickAssistProposal {
    protected static final String MOVE_TO_NEW_FILE = "Move selection to new file...";
    protected static final String INCLUDE_STATEMENT = "`include \"" + DVTQuickAssistUtil.STR_SUBSTITUTOR_PREFIX + FormatNewFileContentPatternType.FILE_NAME.getPattern() + DVTQuickAssistUtil.STR_SUBSTITUTOR_SUFFIX + "\"";
    protected String startIndent = "";
    protected String selectedText;
    protected IFile triggerFile;
    protected QuickFixIncludedFileInfo includedFileInfo;
    protected String targetFileNameWithoutExtension;
    protected IDocument triggerDocument;
    protected DVTEditor triggerEditor;
    protected IFile includeFileForExtractToModule;
    protected int startOffset;
    protected FormatNewFileContentPatternType patternType;

    protected QuickAssistMoveSelectionToNewFileProposalCommon(int startOffset, String startIndent, String selectedText, IFile file, IFile includeFileForExtractToModule, FormatNewFileContentPatternType patternType) {
        List<QuickFixIncludedFileInfo> sortedIncdirs;
        this.startOffset = startOffset;
        this.startIndent = startIndent;
        this.selectedText = selectedText;
        this.triggerFile = file;
        this.includeFileForExtractToModule = includeFileForExtractToModule;
        this.patternType = patternType;
        if (this.triggerFile != null && (sortedIncdirs = VlogQuickFixUtil.getInstance().getSortedIncdirs(this.triggerFile, "", startOffset, (IProgressMonitor)new NullProgressMonitor())) != null && !sortedIncdirs.isEmpty()) {
            this.includedFileInfo = sortedIncdirs.get(0);
        }
    }

    public String getTargetFileNameWithoutExtension() {
        return this.targetFileNameWithoutExtension;
    }

    protected String getIncludeStringPath(IPath closestIncdirPath, IFile createdFile) {
        if (createdFile == null) {
            return null;
        }
        String fileName = createdFile.getName();
        IPath createdFileProjectRelativePath = createdFile.getProjectRelativePath();
        String project = String.valueOf(createdFile.getProject().getName()) + File.separator;
        if (closestIncdirPath != null && closestIncdirPath.toOSString().startsWith(project)) {
            closestIncdirPath = closestIncdirPath.removeFirstSegments(1);
        }
        Object cr = BuildConfigManager.getDVTConfig((IProject)this.triggerFile.getProject(), (IBuildConfigParserConstants.Directive)IBuildConfigParserConstants.Directive.COMPILATION_ROOT);
        String compilationRoot = "";
        if (cr instanceof String) {
            compilationRoot = (String)cr;
        }
        Path compilationRootPath = new Path(compilationRoot);
        IPath relativePath = null;
        if (createdFileProjectRelativePath != null) {
            if (closestIncdirPath != null) {
                IPath createdFileDirectory = createdFileProjectRelativePath.removeLastSegments(1);
                if (createdFileDirectory.equals((Object)closestIncdirPath)) {
                    return fileName;
                }
                relativePath = !createdFileDirectory.isEmpty() && (closestIncdirPath.isPrefixOf(createdFileDirectory) || createdFileDirectory.isPrefixOf(closestIncdirPath)) ? createdFileProjectRelativePath.makeRelativeTo(closestIncdirPath) : (compilationRoot.isEmpty() ? createdFileProjectRelativePath : createdFile.getLocation().makeRelativeTo((IPath)compilationRootPath));
            } else {
                Object object = compilationRoot.isEmpty() ? createdFileProjectRelativePath : (relativePath = createdFile.getLocation() == null ? null : createdFile.getLocation().makeRelativeTo((IPath)compilationRootPath));
            }
        }
        if (relativePath != null) {
            fileName = relativePath.toOSString();
        }
        return fileName;
    }

    protected IPath computeClosestContainer() {
        IPath projectLocation = this.triggerFile.getProject().getLocation();
        IPath projectParentDir = projectLocation.removeLastSegments(1);
        if (projectParentDir == null) {
            return projectLocation;
        }
        IContainer triggerFileContainer = this.triggerFile.getParent();
        if (triggerFileContainer != null) {
            return triggerFileContainer.getFullPath();
        }
        if (this.includedFileInfo == null) {
            return null;
        }
        return this.includedFileInfo.getFilePath().makeRelativeTo(projectParentDir);
    }

    protected IPath computeClosestIncDir() {
        IPath projectLocation = this.triggerFile.getProject().getLocation();
        if (this.includedFileInfo == null) {
            return null;
        }
        IPath projectParentDir = projectLocation.removeLastSegments(1);
        if (projectParentDir == null) {
            return projectLocation;
        }
        return this.includedFileInfo.getFilePath().makeRelativeTo(projectParentDir);
    }

    protected String getFileContent(String text) {
        String indentAtOffset = DVTDocumentUtils.getIndent((int)this.startOffset, (IDocument)this.triggerDocument);
        DVTSourceViewerConfiguration triggerEditorSVC = (DVTSourceViewerConfiguration)this.triggerEditor.getSourceViewerConfigurationForEditor();
        int tabWidth = triggerEditorSVC.getTabWidth((ISourceViewer)((DVTProjectionViewer)this.triggerEditor.getTextViewer()));
        indentAtOffset = this.includeFileForExtractToModule != null ? "" : TextUtils.replaceTabsWithSpacesVisual((String)indentAtOffset, (int)tabWidth);
        String lineDelimiter = DVTDocumentCommon.getLineDelimiter((IEditorPart)this.triggerEditor);
        String[] textLines = text.split(lineDelimiter);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < textLines.length) {
            String textLine = TextUtils.replaceTabsWithSpacesVisual((String)textLines[i], (int)tabWidth);
            textLine = TextUtils.trimNumberOfWhitespacesFromBeginningOfString((String)textLine, (int)indentAtOffset.length());
            sb.append(textLine).append(lineDelimiter);
            ++i;
        }
        return sb.toString();
    }

    protected String getDisplayStringInternal() throws Exception {
        return MOVE_TO_NEW_FILE;
    }

    protected String getProposalName() {
        return MOVE_TO_NEW_FILE;
    }

    protected IFile[] getAffectedFiles() throws Exception {
        Object[] affectedObjects = this.textFileChange.getAffectedObjects();
        IFile[] affectedFiles = new IFile[affectedObjects.length];
        int i = 0;
        while (i < affectedObjects.length) {
            Object affectedObject = affectedObjects[i];
            if (affectedObject instanceof IFile) {
                affectedFiles[i] = (IFile)affectedObject;
            }
            ++i;
        }
        return affectedFiles;
    }

    protected void computeChangeForTriggerFile(String triggerReplacementString) {
        if (this.patternType == FormatNewFileContentPatternType.NO_PATTERN) {
            ReplaceEdit triggerReplaceEdit = new ReplaceEdit(this.startOffset, this.selectedText.length(), triggerReplacementString);
            this.textFileChange.addEdit((TextEdit)triggerReplaceEdit);
        } else {
            InsertEdit triggerInsertEdit = new InsertEdit(this.startOffset, triggerReplacementString);
            this.textFileChange.addEdit((TextEdit)triggerInsertEdit);
        }
    }
}

