/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.dvt.ui.editor.quickassist.util.CreateChangeStatus;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameDelegate;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameRefactorInfo;

public class QuickAssistRenameInFileProposal
extends DVTAbstractQuickAssistProposal {
    private static final String RENAME_IN_FILE = "Rename {0} in file";
    private String displayString;
    private RfWNamedElementAndScope namedElementAndScope;
    private CompositeChange rootChange;
    private LinkedModeModel linkedProposalModel;
    private DVTLinkedPositionProvider linkedPositionMaker;

    public QuickAssistRenameInFileProposal(IFile file, DVTEditor editor, IDocument document, RfWNamedElementAndScope namedElementAndScope) {
        this.file = file;
        this.editor = editor;
        this.document = document;
        this.namedElementAndScope = namedElementAndScope;
        this.linkedProposalModel = new LinkedModeModel();
        this.displayString = MessageFormat.format(RENAME_IN_FILE, this.namedElementAndScope.getNamedElement().getName());
        this.linkedPositionMaker = new DVTLinkedPositionProvider(this.editor, this.linkedProposalModel, this.getCategory(), true);
    }

    public void applyQuickAssist(IDocument document) throws Exception {
        this.performChanges();
        this.addLinkedPositions();
    }

    private void performChanges() {
        try {
            DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)this.editor, this.document, this.getDisplayString(), (Change)this.rootChange);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void addLinkedPositions() throws Exception {
        this.linkedPositionMaker.addMultipleLinkedPosition(this.textFileChange.getAbsoluteRegions(), this.document, this.editor.getCursor());
        this.linkedPositionMaker.enterLinkedMode(this.document, null);
    }

    protected CreateChangeStatus createQuickAssistChanges() throws Exception {
        final AtomicBoolean done = new AtomicBoolean(false);
        final CreateChangeStatus[] refactoringStatus = new CreateChangeStatus[1];
        Job computingRenameInFileChangesJob = new Job("Rename in File Job"){

            protected IStatus run(IProgressMonitor monitor) {
                QuickAssistRenameInFileProposal.this.rootChange = new CompositeChange(QuickAssistRenameInFileProposal.this.displayString);
                VlogRenameRefactorInfo info = new VlogRenameRefactorInfo(QuickAssistRenameInFileProposal.this.file.getProject(), QuickAssistRenameInFileProposal.this.namedElementAndScope, (ITextEditor)QuickAssistRenameInFileProposal.this.editor);
                info.setTrackChanges(true);
                info.setNewName(QuickAssistRenameInFileProposal.this.namedElementAndScope.getNamedElement().getName());
                info.setResourceSearchScope((IResource)QuickAssistRenameInFileProposal.this.file);
                VlogRenameDelegate vlogRenameDelegate = new VlogRenameDelegate(info, true);
                RefactoringStatus status = vlogRenameDelegate.checkInitialConditions(monitor);
                if (!status.isOK()) {
                    done.set(true);
                    refactoringStatus[0] = CreateChangeStatus.ERROR;
                    return Status.CANCEL_STATUS;
                }
                if (monitor.isCanceled()) {
                    refactoringStatus[0] = CreateChangeStatus.CANCEL;
                    done.set(true);
                    return Status.CANCEL_STATUS;
                }
                vlogRenameDelegate.createChanges(monitor, QuickAssistRenameInFileProposal.this.rootChange, new HashMap());
                if (QuickAssistRenameInFileProposal.this.rootChange.getChildren().length != 1 || !(QuickAssistRenameInFileProposal.this.rootChange.getChildren()[0] instanceof VlogTextFileChange)) {
                    refactoringStatus[0] = CreateChangeStatus.ERROR;
                    done.set(true);
                    return Status.CANCEL_STATUS;
                }
                refactoringStatus[0] = CreateChangeStatus.OK;
                QuickAssistRenameInFileProposal.this.textFileChange = (VlogTextFileChange)QuickAssistRenameInFileProposal.this.rootChange.getChildren()[0];
                done.set(true);
                return Status.OK_STATUS;
            }
        };
        computingRenameInFileChangesJob.schedule();
        long busyIndicatorTimeout = System.currentTimeMillis() + 1500L;
        DVTUiUtils.showBusyIndAndProgressMonitorAfterTImeout((Job)computingRenameInFileChangesJob, (AtomicBoolean)done, (String)"Computing rename in file changes...", (long)busyIndicatorTimeout);
        return refactoringStatus[0];
    }

    protected IFile[] getAffectedFiles() throws Exception {
        Object[] affectedObjects = this.rootChange.getAffectedObjects();
        IFile[] affectedFiles = new IFile[affectedObjects.length];
        int i = 0;
        while (i < affectedObjects.length) {
            Object affectedObject = affectedObjects[i];
            if (affectedObject instanceof IFile) {
                affectedFiles[i] = (IFile)affectedObject;
            }
            ++i;
        }
        return affectedFiles;
    }

    public String getDisplayStringInternal() {
        return this.displayString;
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.LINKED_RENAME);
    }

    private String getCategory() {
        return "QuickAssistProposalCategory_" + ((Object)((Object)this)).toString();
    }

    protected String getProposalName() {
        return "Rename in file";
    }
}

