/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.dvt.ui.editor.quickassist.util.CreateChangeStatus;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;
import ro.amiq.vlogdt.utils.VlogFileUtils;

public abstract class QuickAssistSplitProposalCommon
extends DVTAbstractQuickAssistProposal {
    protected RfDefElement defElement;
    protected RfNamedElement namedElement;
    protected RfNamedElement classScope;
    protected IResource sourceFileAdapter;
    protected IResource classFileAdapter;
    protected VlogTextFileChange changeInSourceFile;
    protected VlogTextFileChange changeInClassFile;
    protected DVTEditor sourceEditor;
    protected IDocument classDocument;
    protected IDocument sourceDocument;

    protected QuickAssistSplitProposalCommon(RfDefElement element, RfNamedElement classScope) {
        this.defElement = element;
        this.namedElement = element.getNamedElement();
        this.classScope = classScope;
    }

    protected void preApplyQuickAssist(IDocument document) throws CoreException {
        this.sourceFileAdapter = this.namedElement.getFileAdapter();
        this.sourceEditor = (DVTEditor)DVTUiUtils.getEditor((IResource)this.sourceFileAdapter);
        this.sourceDocument = document;
        if (this.sourceEditor == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        this.classFileAdapter = this.classScope.getFileAdapter();
        DVTEditor classEditor = (DVTEditor)DVTUiUtils.getEditor((IResource)this.classFileAdapter);
        this.classDocument = classEditor.getDocument();
    }

    public void applyQuickAssist(IDocument document) throws CoreException {
        DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)this.sourceEditor, this.sourceDocument, this.getDisplayString(), (Change)this.compositeChange);
        this.setCursorFocus();
    }

    protected CreateChangeStatus createQuickAssistChanges() throws Exception {
        this.computePrototypeFileChange();
        this.computeImplementationFileChange();
        this.compositeChange = this.createCompositeChange();
        return CreateChangeStatus.OK;
    }

    private CompositeChange createCompositeChange() {
        CompositeChange compositeChange = new CompositeChange(this.getChangeName());
        if (this.classDocument.equals(this.sourceDocument)) {
            compositeChange.add((Change)this.changeInSourceFile);
        } else {
            compositeChange.add((Change)this.changeInSourceFile);
            compositeChange.add((Change)this.changeInClassFile);
        }
        return compositeChange;
    }

    private void computeImplementationFileChange() throws BadLocationException {
        Object[] implementationOffsetAndString = this.computeSplitImplementationInfo();
        InsertEdit insertImplementationEdit = new InsertEdit(((Integer)implementationOffsetAndString[0]).intValue(), (String)implementationOffsetAndString[1]);
        if (this.classDocument.equals(this.sourceDocument)) {
            this.changeInSourceFile.addEdit((TextEdit)insertImplementationEdit);
        } else {
            this.changeInClassFile = new VlogTextFileChange(this.classFileAdapter.getProjectRelativePath().toOSString(), (IFile)this.classFileAdapter);
            this.changeInClassFile.setEdit((TextEdit)new MultiTextEdit());
            this.changeInClassFile.addEdit((TextEdit)insertImplementationEdit);
        }
    }

    private void computePrototypeFileChange() throws BadLocationException {
        this.changeInSourceFile = new VlogTextFileChange(this.sourceFileAdapter.getProjectRelativePath().toOSString(), (IFile)this.sourceFileAdapter);
        this.changeInSourceFile.setEdit((TextEdit)new MultiTextEdit());
        Object[] prototypeOffsetAndString = this.computeSplitPrototypeInfo();
        DeleteEdit deleteFunctionEdit = new DeleteEdit(((Integer)prototypeOffsetAndString[0]).intValue(), ((Integer)prototypeOffsetAndString[1]).intValue());
        this.changeInSourceFile.addEdit((TextEdit)deleteFunctionEdit);
        InsertEdit insertPrototypeEdit = new InsertEdit(((Integer)prototypeOffsetAndString[0]).intValue(), (String)prototypeOffsetAndString[2]);
        this.changeInSourceFile.addEdit((TextEdit)insertPrototypeEdit);
    }

    protected IFile[] getAffectedFiles() throws Exception {
        Object[] affectedObjects = this.compositeChange.getAffectedObjects();
        IFile[] affectedFiles = new IFile[affectedObjects.length];
        int i = 0;
        while (i < affectedObjects.length) {
            Object affectedObject = affectedObjects[i];
            if (affectedObject instanceof IFile) {
                affectedFiles[i] = (IFile)affectedObject;
            }
            ++i;
        }
        return affectedFiles;
    }

    public Image getImage() {
        ImageDescriptor imageDescriptor = this.getImageDescriptor();
        Image baseImage = DVTImages.imageCache.getImage(imageDescriptor);
        return DVTImages.imageCache.getImage((ImageDescriptor)new DecorationOverlayIcon(baseImage, DVTImages.OVR_EXTERN, 3));
    }

    public String getDisplayStringInternal() {
        return "Split " + this.getElementKind() + " into extern prototype and implementation";
    }

    protected String getProposalName() {
        return this.getDisplayStringInternal();
    }

    public DVTFileUtils getFileUtils() {
        return VlogFileUtils.getInstance();
    }

    protected abstract Object[] computeSplitImplementationInfo() throws BadLocationException;

    protected abstract Object[] computeSplitPrototypeInfo() throws BadLocationException;

    protected abstract ImageDescriptor getImageDescriptor();

    protected abstract String getElementKind();

    protected abstract String getChangeName();

    protected abstract void setCursorFocus();
}

