/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.util.PortConnectionOperatorVisitor;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.ui.editor.quickassist.QuickAssistConnectInstancePortsByNameProposal;
import ro.amiq.vlogdt.ui.editor.quickassist.QuickAssistConnectInstancePortsByPositionProposal;
import ro.amiq.vlogdt.ui.editor.quickassist.VlogAbstractQuickAssistProcessor;
import ro.amiq.vlogdt.utils.VlogFileUtils;

public class VlogQuickAssistConnectInstancePortsProcessor
extends VlogAbstractQuickAssistProcessor {
    private IRfInstanceElement instance;
    private IRfScope rfScope;
    private IRfDesignElement designElement;
    private List<IHidOperator> instancePCs;
    private boolean bindByName;
    private List<? extends IRfPortElement> designPorts;

    public VlogQuickAssistConnectInstancePortsProcessor(ITextViewer viewer) {
        super(viewer);
    }

    protected boolean init() {
        if (!super.init()) {
            return false;
        }
        RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement(this.fRfProject, (ITextEditor)this.fEditor, this.fDocument, this.fCursorOffset);
        if (namedElementAndScope == null) {
            return false;
        }
        RfNamedElement elementAtCursor = namedElementAndScope.getNamedElement();
        if (elementAtCursor instanceof RfInstance) {
            this.instance = (IRfInstanceElement)elementAtCursor;
            return true;
        }
        this.rfScope = RfUtils.getRfScope((ITextEditor)this.fEditor, this.fDocument, this.fCursorOffset);
        if (this.rfScope == null) {
            return false;
        }
        List<RfInstance> instances = this.rfScope.getInstancesWithPrefix("", 2, 1);
        if (instances == null) {
            return false;
        }
        for (RfInstance localInstance : instances) {
            if (localInstance.getStartOffset() > this.fCursorOffset || localInstance.getEndOffset() < this.fCursorOffset) continue;
            this.instance = localInstance;
            return true;
        }
        return false;
    }

    public boolean validate() {
        if (this.instance == null) {
            return false;
        }
        if (this.instance.getDeclaration() != null && PrecompiledDBUtils.isManualPrecompiledFile((IProject)this.fProject, (ParserPath)this.instance.getDeclaration().getParserPath())) {
            return false;
        }
        this.instancePCs = PortConnectionOperatorVisitor.getPortConnections((IRfNamedElement)this.instance);
        if (this.instancePCs == null || this.instancePCs.isEmpty()) {
            return false;
        }
        for (IHidOperator portConnection : this.instancePCs) {
            if (PortConnectionUtils.isDotStarConnected((IHidOperator)portConnection)) {
                return false;
            }
            if (PortConnectionUtils.getVirtualOffset((IHidOperator)portConnection) >= 0) {
                return false;
            }
            if (PortConnectionUtils.isOrdered((IHidOperator)portConnection)) {
                this.bindByName = true;
                continue;
            }
            if (!this.isNamedWithoutParen(portConnection)) continue;
            return false;
        }
        this.designElement = DesignUtils.getDesign((DesignUtils.DesignRequest)DesignUtils.DesignRequest.of((IRfNamedElement)this.instance));
        if (this.designElement == null) {
            return false;
        }
        this.designPorts = this.designElement.getPortsWithPrefix("", 2);
        if (this.designPorts == null || this.designPorts.isEmpty()) {
            return false;
        }
        return this.designPorts.size() == this.instancePCs.size();
    }

    private boolean isNamedWithoutParen(IHidOperator portConnection) {
        int openBoundary = PortConnectionUtils.getOpenBoundary((IHidOperator)portConnection);
        if (openBoundary < 0) {
            return true;
        }
        int portNameEndOffset = openBoundary + PortConnectionUtils.getPortName((IHidOperator)portConnection).length();
        if (portNameEndOffset < 0) {
            return true;
        }
        char nextChar = DVTDocumentUtils.nextCodeChar((IDocument)this.fDocument, (int)portNameEndOffset, (String)"__vlog_partitioning", (boolean)true);
        return nextChar != '(';
    }

    public List<DVTAbstractQuickAssistProposal> makeProposals() {
        ArrayList<DVTAbstractQuickAssistProposal> result = new ArrayList<DVTAbstractQuickAssistProposal>();
        if (this.bindByName) {
            result.add(new QuickAssistConnectInstancePortsByNameProposal(this.fFile, this.fEditor, this.fDocument, this.instance, this.instancePCs, this.designElement, this.designPorts));
        } else {
            result.add(new QuickAssistConnectInstancePortsByPositionProposal(this.fFile, this.fEditor, this.fDocument, this.instance, this.instancePCs, this.designElement, this.designPorts));
        }
        return result;
    }

    public DVTFileUtils getFileUtils() {
        return VlogFileUtils.getInstance();
    }
}

