/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.ui.editor.quickassist.QuickAssistExpandDotStarProposal;
import ro.amiq.vlogdt.ui.editor.quickassist.VlogAbstractQuickAssistProcessor;
import ro.amiq.vlogdt.utils.VlogFileUtils;

public class VlogQuickAssistExpandDotStarProcessor
extends VlogAbstractQuickAssistProcessor {
    protected RfNamedElement elementAtCursor;
    private IRfScope rfScope;

    public VlogQuickAssistExpandDotStarProcessor(ITextViewer viewer) {
        super(viewer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean init() {
        try {
            RfInstance instance;
            if (!super.init()) {
                return false;
            }
            RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement(this.fRfProject, (ITextEditor)this.fEditor, this.fDocument, this.fCursorOffset);
            if (namedElementAndScope == null) {
                return false;
            }
            this.elementAtCursor = namedElementAndScope.getNamedElement();
            if (this.elementAtCursor instanceof RfInstance) {
                return true;
            }
            this.rfScope = RfUtils.getRfScope((ITextEditor)this.fEditor, this.fDocument, this.fCursorOffset);
            if (this.rfScope == null) {
                return false;
            }
            if (this.isBindInstance()) {
                return true;
            }
            List<RfInstance> instances = this.rfScope.getInstancesWithPrefix("", 2, 1);
            if (instances == null) {
                return false;
            }
            Iterator<RfInstance> iterator = instances.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((instance = iterator.next()).getStartOffset() > this.fCursorOffset || instance.getEndOffset() < this.fCursorOffset);
            this.elementAtCursor = instance;
            return true;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    public boolean validate() {
        if (this.elementAtCursor != null && this.elementAtCursor.getDeclaration() != null && PrecompiledDBUtils.isManualPrecompiledFile((IProject)this.fProject, (ParserPath)this.elementAtCursor.getDeclaration().getParserPath())) {
            return false;
        }
        return this.elementAtCursor instanceof RfInstance && ((RfInstance)this.elementAtCursor).hasDotStarConnection();
    }

    public List<DVTAbstractQuickAssistProposal> makeProposals() {
        if (!(this.elementAtCursor instanceof RfInstance)) {
            return Collections.emptyList();
        }
        RfInstance instance = (RfInstance)this.elementAtCursor;
        IRfDesignElement instanceDesign = (IRfDesignElement)instance.getGenericDesign(null);
        if (instanceDesign == null) {
            return Collections.emptyList();
        }
        List localPorts = instanceDesign.getPortsWithPrefix("", 2);
        if (localPorts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DVTAbstractQuickAssistProposal> result = new ArrayList<DVTAbstractQuickAssistProposal>();
        result.add(new QuickAssistExpandDotStarProposal(this.fFile, this.fEditor, this.fDocument, this.fCursorOffset, this.elementAtCursor, localPorts, instanceDesign, this.rfScope));
        return result;
    }

    public DVTFileUtils getFileUtils() {
        return VlogFileUtils.getInstance();
    }

    private boolean isBindInstance() {
        List<? extends IRfInstanceElement> bindInstances;
        List<? extends IRfInstanceElement> list = bindInstances = this.rfScope.getNamedElement() != null ? this.rfScope.getNamedElement().getBindInstances(this.fCursorOffset) : null;
        if (bindInstances == null) {
            return false;
        }
        for (IRfInstanceElement iRfInstanceElement : bindInstances) {
            if (!(iRfInstanceElement instanceof RfNamedElement) || iRfInstanceElement.getOffset() > this.fCursorOffset || iRfInstanceElement.getEndOffset() < this.fCursorOffset) continue;
            this.elementAtCursor = (RfNamedElement)iRfInstanceElement;
            return true;
        }
        return false;
    }
}

