/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.ui.editor.quickassist.QuickAssistExpandMacroProposal;
import ro.amiq.vlogdt.ui.editor.quickassist.VlogAbstractQuickAssistProcessor;
import ro.amiq.vlogdt.utils.VlogFileUtils;

public abstract class VlogQuickAssistExpandMacroProcessorCommon
extends VlogAbstractQuickAssistProcessor {
    protected static final int SCAN_LIMIT = 1000;
    protected RfNamedElement elementAtCursor;

    protected VlogQuickAssistExpandMacroProcessorCommon(ITextViewer viewer) {
        super(viewer);
    }

    protected boolean init() {
        RfWNamedElementAndScope namedElementAndScope;
        block5: {
            block4: {
                try {
                    if (super.init()) break block4;
                    return false;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return false;
                }
            }
            namedElementAndScope = RfUtils.getRfElement(this.fRfProject, (ITextEditor)this.fEditor, this.fDocument, this.fCursorOffset);
            if (namedElementAndScope != null) break block5;
            return false;
        }
        this.elementAtCursor = namedElementAndScope.getNamedElement();
        return true;
    }

    public boolean validate() {
        return this.isMacroCall();
    }

    public DVTFileUtils getFileUtils() {
        return VlogFileUtils.getInstance();
    }

    private boolean isMacroCall() {
        int line;
        ParserPath parserPath;
        int startOffset;
        String selectedText;
        block10: {
            block9: {
                block8: {
                    ITextSelection selection;
                    block7: {
                        try {
                            selection = this.getSelection();
                            if (selection != null) break block7;
                            return false;
                        }
                        catch (BadLocationException e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            return false;
                        }
                    }
                    selectedText = selection.getText();
                    startOffset = selection.getOffset();
                    if (startOffset >= 0) break block8;
                    return false;
                }
                parserPath = this.fEditor.getParserPath();
                if (parserPath != null) break block9;
                return false;
            }
            if (selectedText != null && !selectedText.trim().isEmpty()) break block10;
            IRegion region = RfBatchUtils.getMacroRegionAtOffset(this.fRfProject, parserPath, this.fDocument, this.fCursorOffset, 1000);
            return region != null;
        }
        if (selectedText.startsWith("`") && (selectedText = selectedText.substring(1)).contains("(") && selectedText.endsWith(")")) {
            selectedText = selectedText.substring(0, selectedText.indexOf("("));
        }
        return this.fRfProject.getMacroBeforeLineInFile(selectedText, parserPath, line = this.fDocument.getLineOfOffset(startOffset)) != null;
    }

    public List<DVTAbstractQuickAssistProposal> makeProposals() {
        ArrayList<DVTAbstractQuickAssistProposal> result = new ArrayList<DVTAbstractQuickAssistProposal>();
        result.add(new QuickAssistExpandMacroProposal(this.fFile, this.fEditor, this.fDocument, this.fCursorOffset));
        return result;
    }

    protected abstract ITextSelection getSelection();
}

