/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.ITextViewer;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.ui.editor.quickassist.AbstractQuickAssistExtractProcessor;
import ro.amiq.vlogdt.ui.editor.quickassist.QuickAssistExtractMethodProposal;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;

public class VlogQuickAssistExtractMethodProcessor
extends AbstractQuickAssistExtractProcessor {
    public static final String EXTRACT_TO_FUNCTION = "Extract to function";
    public static final String EXTRACT_TO_TASK = "Extract to task";
    private Set<RfHidOperator> compoundOperators;

    public VlogQuickAssistExtractMethodProcessor(ITextViewer viewer) {
        super(viewer);
    }

    public List<DVTAbstractQuickAssistProposal> makeProposals() {
        RfFunction functElement;
        List<DVTAbstractQuickAssistProposal> result = this.internalComputeProposal(false, EXTRACT_TO_FUNCTION);
        boolean addExtractToTaskProposal = true;
        if (this.fClosestContainer instanceof RfFunctionDef && !(functElement = (RfFunction)((RfFunctionDef)this.fClosestContainer).getNamedElement()).isTask()) {
            addExtractToTaskProposal = false;
        }
        if (addExtractToTaskProposal) {
            result.addAll(this.internalComputeProposal(true, EXTRACT_TO_TASK));
        }
        return result;
    }

    private List<DVTAbstractQuickAssistProposal> internalComputeProposal(boolean isTask, String displayString) {
        ArrayList<DVTAbstractQuickAssistProposal> result = new ArrayList<DVTAbstractQuickAssistProposal>();
        result.add(new QuickAssistExtractMethodProposal(displayString, this.fStartOffset, this.fEndOffset, this.fSelectedText, this.fClosestContainer, this.fFile, isTask, this.compoundOperators));
        return result;
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        return !this.selectionContainsReturnStatement();
    }

    private boolean selectionContainsReturnStatement() {
        int possibleHasReturn = this.fSelectedText.indexOf("return");
        if (possibleHasReturn == -1) {
            return false;
        }
        return VlogQuickFixUtil.getInstance().textContainsStatement(this.fDocument, "return", this.fStartOffset, this.fEndOffset);
    }

    @Override
    protected boolean isSameScope() {
        return this.fStartScope == this.fEndScope || this.fStartOffset == this.fStartScope.getStartOffset() || this.fEndOffset == this.fEndScope.getEndOffset();
    }

    @Override
    protected RfDefElement internalComputeClosestContainer() {
        HashSet<Class> classes = new HashSet<Class>();
        classes.add(RfFunction.class);
        classes.add(RfActionBlock.class);
        return VlogQuickFixUtil.getInstance().getEnclosingDefAtOffset(this.fStartOffset, this.fEditor, classes);
    }

    @Override
    protected void setCompoundOperators(Set<RfHidOperator> operatorsToCheck) {
        this.compoundOperators = operatorsToCheck;
    }
}

