/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.dvt.ui.editor.quickassist.util.DVTQuickAssistUtil;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.ui.editor.quickassist.AbstractQuickAssistExtractProcessor;
import ro.amiq.vlogdt.ui.editor.quickassist.QuickAssistExtractVariableProposal;
import ro.amiq.vlogdt.ui.editor.quickassist.util.VlogQuickAssistUtil;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.TypeName;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;

public class VlogQuickAssistExtractVariableProcessor
extends AbstractQuickAssistExtractProcessor {
    private List<IRegion> multipleOccurrences;
    private TypeName variableTypeName;
    private Set<RfHidOperator> compoundOperators;

    public VlogQuickAssistExtractVariableProcessor(ITextViewer viewer) {
        super(viewer);
    }

    @Override
    protected boolean init() {
        return super.init();
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        this.variableTypeName = VlogQuickAssistUtil.computeReturnTypeName(this.fRfProject, this.fDocument, this.fClosestContainer.getParserPath(), null, this.fStartOffset, this.fEndOffset, this.fSelectedText, this.fClosestContainer.getNamedElement(), this.fClosestContainer, this.compoundOperators, true);
        if (this.variableTypeName == null) {
            return false;
        }
        try {
            return !DVTQuickAssistUtil.hasSemicolon((IDocument)this.fDocument, (int)this.fStartOffset, (int)this.fEndOffset, (String)"__vlog_partitioning");
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
            return false;
        }
    }

    public List<DVTAbstractQuickAssistProposal> makeProposals() {
        ArrayList<DVTAbstractQuickAssistProposal> result = new ArrayList<DVTAbstractQuickAssistProposal>();
        try {
            RfDefElement enclosingContainerDeclaration = this.fClosestContainer;
            if (this.fClosestContainer instanceof RfFunctionDef && this.fClosestContainer.getNamedElement().isExtern()) {
                enclosingContainerDeclaration = this.fClosestContainer.getNamedElement().getImplementation();
            }
            String scopeBody = this.fDocument.get(enclosingContainerDeclaration.getStartOffset(), enclosingContainerDeclaration.getEndOffset() - enclosingContainerDeclaration.getStartOffset());
            this.multipleOccurrences = DVTQuickAssistUtil.getMultipleOccurrences((String)this.fSelectedText, (int)enclosingContainerDeclaration.getStartOffset(), (String)scopeBody, (String)"__vlog_partitioning", (IDocument)this.fDocument);
            if (this.multipleOccurrences.size() > 1) {
                result.add((DVTAbstractQuickAssistProposal)new QuickAssistExtractVariableProposal(this.variableTypeName, this.fClosestContainer, this.fStartOffset, this.fEndOffset, this.fStartScope, this.multipleOccurrences, "Extract to local variable", true, this.fFile));
            }
            result.add((DVTAbstractQuickAssistProposal)new QuickAssistExtractVariableProposal(this.variableTypeName, this.fClosestContainer, this.fStartOffset, this.fEndOffset, this.fStartScope, this.multipleOccurrences, "Extract to local variable", false, this.fFile));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    @Override
    protected boolean isSameScope() {
        return this.fStartScope == this.fEndScope;
    }

    @Override
    protected RfDefElement internalComputeClosestContainer() {
        HashSet<Class> classes = new HashSet<Class>();
        classes.add(RfFunction.class);
        classes.add(RfActionBlock.class);
        return VlogQuickFixUtil.getInstance().getEnclosingDefAtOffset(this.fStartOffset, this.fEditor, classes);
    }

    @Override
    protected void setCompoundOperators(Set<RfHidOperator> operatorsToCheck) {
        this.compoundOperators = operatorsToCheck;
    }
}

