/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.util.PortConnectionOperatorVisitor;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.ui.editor.quickassist.QuickAssistForwardAllImplicitConnectionsProposal;
import ro.amiq.vlogdt.ui.editor.quickassist.VlogAbstractQuickAssistProcessor;

public class VlogQuickAssistForwardAllImplicitConnectionsProcessor
extends VlogAbstractQuickAssistProcessor {
    private RfInstance instance;
    private List<IHidOperator> instancePortConnections;

    public VlogQuickAssistForwardAllImplicitConnectionsProcessor(ITextViewer viewer) {
        super(viewer);
    }

    protected boolean init() {
        if (!super.init()) {
            return false;
        }
        RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement(this.fRfProject, (ITextEditor)this.fEditor, this.fDocument, this.fCursorOffset);
        if (namedElementAndScope == null) {
            return false;
        }
        RfNamedElement elementAtCursor = namedElementAndScope.getNamedElement();
        if (elementAtCursor instanceof RfInstance) {
            this.instance = (RfInstance)elementAtCursor;
            return true;
        }
        IRfScope rfScope = RfUtils.getRfScope((ITextEditor)this.fEditor, this.fDocument, this.fCursorOffset);
        if (rfScope == null) {
            return false;
        }
        List<RfInstance> instances = rfScope.getInstancesWithPrefix("", 2, 1);
        if (instances == null) {
            return false;
        }
        for (RfInstance localInstance : instances) {
            if (localInstance.getStartOffset() > this.fCursorOffset || localInstance.getEndOffset() < this.fCursorOffset) continue;
            this.instance = localInstance;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean validate() {
        if (this.instance == null) {
            return false;
        }
        if (this.instance.getDeclaration() != null && PrecompiledDBUtils.isManualPrecompiledFile((IProject)this.fProject, (ParserPath)this.instance.getDeclaration().getParserPath())) {
            return false;
        }
        RfNamedElement instanceEnclosingScope = this.instance.getEnclosingScope();
        while (!(instanceEnclosingScope instanceof RfModule)) {
            if (this.isInvalidDesignScope(instanceEnclosingScope)) break;
            instanceEnclosingScope = instanceEnclosingScope.getEnclosingScope();
        }
        if (!(instanceEnclosingScope instanceof RfModule)) {
            return false;
        }
        IRfNamedElement instanceDesignElement = this.instance.getGenericDesign(null);
        if (!(instanceDesignElement instanceof IRfDesignElement) || instanceDesignElement.getLanguageKind() != LanguageKind.VLOG) {
            return false;
        }
        this.instancePortConnections = PortConnectionOperatorVisitor.getPortConnections((IRfNamedElement)this.instance);
        if (this.instancePortConnections == null || this.instancePortConnections.isEmpty()) {
            return false;
        }
        for (IHidOperator connection : this.instancePortConnections) {
            void field;
            RfField rfField;
            IHidObject signalHid;
            IRfNamedElement resolvedElement;
            IRfNamedElement iRfNamedElement;
            IHid portHid = PortConnectionUtils.getPortHid((IHidOperator)connection);
            IRfNamedElement portNamedElement = HidUtils.getResolvedElement((IHidObject)portHid);
            if (portNamedElement == null || !((iRfNamedElement = (resolvedElement = HidUtils.getResolvedElement((IHidObject)(signalHid = PortConnectionUtils.getSignal((IHidOperator)connection))))) instanceof RfField) || (rfField = (RfField)iRfNamedElement) != (RfField)iRfNamedElement || !field.isImplicitSignal()) continue;
            return true;
        }
        return false;
    }

    private boolean isInvalidDesignScope(RfNamedElement instanceEnclosingScope) {
        return instanceEnclosingScope.getEnclosingScope() instanceof RfInterface || instanceEnclosingScope.getEnclosingScope() instanceof RfClass || instanceEnclosingScope.getEnclosingScope() instanceof RfStruct || instanceEnclosingScope.getEnclosingScope() instanceof RfChecker || instanceEnclosingScope.getEnclosingScope() instanceof RfProgram || instanceEnclosingScope.getEnclosingScope() instanceof RfCovergroup;
    }

    public List<DVTAbstractQuickAssistProposal> makeProposals() {
        if (this.instance == null) {
            return Collections.emptyList();
        }
        ArrayList<DVTAbstractQuickAssistProposal> result = new ArrayList<DVTAbstractQuickAssistProposal>();
        result.add(new QuickAssistForwardAllImplicitConnectionsProposal(this.fFile, this.fEditor, this.fDocument, this.instance, this.instancePortConnections));
        return result;
    }
}

