/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.util.PortConnectionOperatorVisitor;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.ui.editor.quickassist.QuickAssistForwardImplicitPortConnectionProposal;
import ro.amiq.vlogdt.ui.editor.quickassist.VlogAbstractQuickAssistProcessor;
import ro.amiq.vlogdt.ui.editor.quickassist.util.VlogQuickAssistUtil;

public class VlogQuickAssistForwardImplicitPortConnectionProcessor
extends VlogAbstractQuickAssistProcessor {
    private RfNamedElement elementAtCursor;
    private RfNamedElement enclosingModule;
    private RfPort connectedPort;

    public VlogQuickAssistForwardImplicitPortConnectionProcessor(ITextViewer viewer) {
        super(viewer);
    }

    protected boolean init() {
        if (!super.init()) {
            return false;
        }
        RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement(this.fRfProject, (ITextEditor)this.fEditor, this.fDocument, this.fCursorOffset);
        if (namedElementAndScope == null) {
            return false;
        }
        this.elementAtCursor = namedElementAndScope.getNamedElement();
        this.enclosingModule = namedElementAndScope.getCalledFromScope();
        while (!(this.enclosingModule instanceof RfModule)) {
            if (this.enclosingModule == null || this.isInvalidDesignScope(this.enclosingModule)) {
                return false;
            }
            this.enclosingModule = this.enclosingModule.getEnclosingScope();
        }
        return true;
    }

    private boolean isInvalidDesignScope(RfNamedElement instanceEnclosingScope) {
        return instanceEnclosingScope.getEnclosingScope() instanceof RfInterface || instanceEnclosingScope.getEnclosingScope() instanceof RfClass || instanceEnclosingScope.getEnclosingScope() instanceof RfStruct || instanceEnclosingScope.getEnclosingScope() instanceof RfChecker || instanceEnclosingScope.getEnclosingScope() instanceof RfProgram || instanceEnclosingScope.getEnclosingScope() instanceof RfCovergroup;
    }

    /*
     * WARNING - void declaration
     */
    public boolean validate() {
        void field;
        void var2_1;
        RfField rfField;
        RfNamedElement rfNamedElement = this.elementAtCursor;
        if (!(rfNamedElement instanceof RfField) || (rfField = (RfField)rfNamedElement) != (RfField)var2_1 || !(this.enclosingModule instanceof RfModule)) {
            return false;
        }
        if (!field.isImplicitSignal()) {
            return false;
        }
        IRfScope rfScope = RfUtils.getRfScope((ITextEditor)this.fEditor, this.fDocument, this.fCursorOffset);
        if (rfScope == null) {
            return false;
        }
        List<RfInstance> instances = rfScope.getInstancesWithPrefix("", 2, 1);
        if (instances == null) {
            return false;
        }
        this.connectedPort = null;
        for (RfInstance localInstance : instances) {
            RfDefElement declaration = localInstance.getDeclaration();
            if (declaration == null || !declaration.getParserPath().equals((Object)this.fEditor.getParserPath()) || localInstance.getStartOffset() > this.fCursorOffset || localInstance.getEndOffset() < this.fCursorOffset) continue;
            List instancePortConnections = PortConnectionOperatorVisitor.getPortConnections((IRfNamedElement)localInstance);
            if (instancePortConnections == null || instancePortConnections.isEmpty()) {
                return false;
            }
            for (IHidOperator connection : instancePortConnections) {
                Set<IHidObject> signalsHids = this.computeConnectionSignalHids(connection);
                for (IHidObject signalHid : signalsHids) {
                    IRfNamedElement resolvedElement = HidUtils.getResolvedElement((IHidObject)signalHid);
                    if (!field.equals(resolvedElement)) continue;
                    IHid portHid = PortConnectionUtils.getPortHid((IHidOperator)connection);
                    IRfNamedElement portNamedElement = HidUtils.getResolvedElement((IHidObject)portHid);
                    if (!(portNamedElement instanceof RfPort)) {
                        return false;
                    }
                    this.connectedPort = (RfPort)portNamedElement;
                    break;
                }
                if (this.connectedPort != null) break;
            }
            return true;
        }
        return false;
    }

    public List<DVTAbstractQuickAssistProposal> makeProposals() {
        ArrayList<DVTAbstractQuickAssistProposal> result = new ArrayList<DVTAbstractQuickAssistProposal>();
        result.add(new QuickAssistForwardImplicitPortConnectionProposal(this.fFile, this.fEditor, this.fDocument, this.elementAtCursor, this.enclosingModule, this.connectedPort));
        return result;
    }

    private Set<IHidObject> computeConnectionSignalHids(IHidOperator connection) {
        IHidObject signalHid = PortConnectionUtils.getSignal((IHidOperator)connection);
        if (signalHid == null) {
            return Collections.emptySet();
        }
        if (signalHid instanceof HidOperator var3_4) {
            return new HashSet<IHidObject>(operator.getRHHids(VlogQuickAssistUtil.FLATTENING_OPTIONS_IGNORE_IMPLICITS));
        }
        return new HashSet<IHidObject>(Arrays.asList(signalHid));
    }
}

