/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.ui.editor.quickassist.MethodObjectVisitor;
import ro.amiq.vlogdt.ui.editor.quickassist.QuickAssistFunctionCallArgumentsToNamedProposal;
import ro.amiq.vlogdt.ui.editor.quickassist.QuickAssistFunctionCallArgumentsToOrderedProposal;
import ro.amiq.vlogdt.ui.editor.quickassist.VlogAbstractQuickAssistProcessor;
import ro.amiq.vlogdt.ui.editor.quickassist.util.VlogQuickAssistUtil;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;

public class VlogQuickAssistFunctionCallArgumentsProcessor
extends VlogAbstractQuickAssistProcessor {
    private RfNamedElement scopeAtCursor;
    private MethodObjectVisitor visitor;
    private boolean isToNamedArgumentProposal;

    public VlogQuickAssistFunctionCallArgumentsProcessor(ITextViewer viewer) {
        super(viewer);
    }

    protected boolean init() {
        if (!super.init()) {
            return false;
        }
        HashSet<Class> classes = new HashSet<Class>();
        classes.add(RfFunction.class);
        classes.add(RfActionBlock.class);
        RfDefElement parentScope = VlogQuickFixUtil.getInstance().getEnclosingDefAtOffset(this.fCursorOffset, this.fEditor, classes);
        if (parentScope == null || parentScope.getNamedElement() == null) {
            return false;
        }
        this.scopeAtCursor = parentScope.getNamedElement();
        this.visitor = new MethodObjectVisitor(this.fCursorOffset);
        if (!VlogQuickAssistUtil.computeElementAtCursorScopeIsMethodCall(this.visitor, this.scopeAtCursor)) {
            return false;
        }
        List<? extends IHidObject> argumentValues = this.visitor.getArgumentValues();
        if (argumentValues == null) {
            return false;
        }
        int i = 0;
        while (i < argumentValues.size()) {
            IHidObject argValue = argumentValues.get(i);
            if (MethodCallUtils.getVirtualOffset((IHidObject)argValue) > 0) {
                return false;
            }
            if (MethodCallUtils.isOrdered((IHidObject)argValue)) {
                this.isToNamedArgumentProposal = true;
            }
            if (MethodCallUtils.isNamed((IHidObject)argValue) && this.isToNamedArgumentProposal) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean validate() {
        if (this.visitor.getFound() == null) {
            return false;
        }
        return this.scopeAtCursor == null || this.scopeAtCursor.getDeclaration() == null || !PrecompiledDBUtils.isManualPrecompiledFile((IProject)this.fProject, (ParserPath)this.scopeAtCursor.getDeclaration().getParserPath());
    }

    public List<DVTAbstractQuickAssistProposal> makeProposals() {
        ArrayList<DVTAbstractQuickAssistProposal> result = new ArrayList<DVTAbstractQuickAssistProposal>();
        IRfNamedElement methodNamedElement = this.visitor.getMethodNamedElement();
        List<? extends IHidObject> argumentValues = this.visitor.getArgumentValues();
        Region methodCallRegion = new Region(this.visitor.getMethodStartOffset(), this.visitor.getMethodEndOffset() - this.visitor.getMethodStartOffset() + 1);
        if (this.isToNamedArgumentProposal) {
            result.add(new QuickAssistFunctionCallArgumentsToNamedProposal(this.fFile, this.fEditor, this.fDocument, methodCallRegion, argumentValues, methodNamedElement));
        } else {
            result.add(new QuickAssistFunctionCallArgumentsToOrderedProposal(this.fFile, this.fEditor, this.fDocument, methodCallRegion, argumentValues, methodNamedElement));
        }
        return result;
    }
}

