/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.ITextViewer;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.vlogdt.model.reflection.RfConstraintDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.ui.editor.quickassist.QuickAssistJoinExternConstraintProposal;
import ro.amiq.vlogdt.ui.editor.quickassist.VlogQuickAssistSplitJoinProcessor;
import ro.amiq.vlogdt.ui.editor.quickassist.util.ElementType;

public class VlogQuickAssistJoinExternConstraintProcessor
extends VlogQuickAssistSplitJoinProcessor {
    public VlogQuickAssistJoinExternConstraintProcessor(ITextViewer viewer) {
        super(viewer);
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        RfConstraintDef constraintDef = (RfConstraintDef)this.cursorScope;
        RfNamedElement constraintNamedElement = constraintDef.getNamedElement();
        Collection declarations = constraintNamedElement.getDeclarations();
        for (RfDefElement decl : declarations) {
            if (decl == null || !PrecompiledDBUtils.isManualPrecompiledFile((IProject)this.fProject, (ParserPath)decl.getParserPath())) continue;
            return false;
        }
        return this.hasImplementation(constraintNamedElement);
    }

    private boolean hasImplementation(RfNamedElement constraintNamedElement) {
        Collection constrDecl = constraintNamedElement.getDeclarations();
        if (constrDecl.size() < 2) {
            return false;
        }
        for (RfDefElement decl : constrDecl) {
            if (!(decl instanceof RfConstraintDef) || ((RfConstraintDef)decl).isPrototype()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected DVTAbstractQuickAssistProposal createProposal() {
        return new QuickAssistJoinExternConstraintProposal(this.defElement);
    }

    @Override
    protected ElementType getElementType() {
        return ElementType.CONSTRAINT;
    }
}

