/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.ITextViewer;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.ui.editor.quickassist.VlogAbstractQuickAssistProcessor;
import ro.amiq.vlogdt.ui.editor.quickassist.util.ElementType;
import ro.amiq.vlogdt.ui.editor.quickassist.util.VlogQuickAssistUtil;

public abstract class VlogQuickAssistSplitJoinProcessor
extends VlogAbstractQuickAssistProcessor {
    protected IRfScope cursorScope;
    protected RfDefElement defElement;
    protected RfNamedElement classScope;

    protected VlogQuickAssistSplitJoinProcessor(ITextViewer viewer) {
        super(viewer);
    }

    protected boolean init() {
        if (!super.init()) {
            return false;
        }
        try {
            this.cursorScope = VlogQuickAssistUtil.getDefElementAtCursorLine(this.fCursorOffset, this.fEditor, this.fDocument, this.getElementType());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
        return true;
    }

    public boolean validate() {
        if (!this.getElementType().matches(this.cursorScope)) {
            return false;
        }
        this.defElement = (RfDefElement)this.cursorScope;
        if (PrecompiledDBUtils.isManualPrecompiledFile((IProject)this.fProject, (ParserPath)this.defElement.getParserPath())) {
            return false;
        }
        RfNamedElement namedElement = this.defElement.getNamedElement();
        this.classScope = namedElement.getEnclosingScope(RfClass.class);
        return this.classScope != null;
    }

    public List<DVTAbstractQuickAssistProposal> makeProposals() {
        ArrayList<DVTAbstractQuickAssistProposal> result = new ArrayList<DVTAbstractQuickAssistProposal>();
        DVTAbstractQuickAssistProposal proposal = this.createProposal();
        result.add(proposal);
        return result;
    }

    protected abstract DVTAbstractQuickAssistProposal createProposal();

    protected abstract ElementType getElementType();
}

