/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist.util;

import java.util.LinkedHashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

public class CollectHidsFromSelectionVisitor
extends RfHidVisitor {
    private Set<IHid> fHidsInSelection = new LinkedHashSet<IHid>();
    private int fStartOffset;
    private int fEndOffset;

    public CollectHidsFromSelectionVisitor(int startOffset, int endOffset) {
        this.fStartOffset = startOffset;
        this.fEndOffset = endOffset;
    }

    public boolean visit(RfHid hid) {
        if (DVTQuickFixUtil.isHidInSelection((IHid)hid, (int)this.fStartOffset, (int)this.fEndOffset)) {
            Hid searchedHid = hid.getAncestorHid();
            for (IHid existingHid : this.fHidsInSelection) {
                if (existingHid.getElement() == null || !existingHid.getElement().equals(searchedHid.getElement())) continue;
                return true;
            }
            this.fHidsInSelection.add((IHid)searchedHid);
        }
        return true;
    }

    public Set<IHid> getHidsInSelection() {
        return this.fHidsInSelection;
    }
}

