/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist.util;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.Position;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public class CollectOperatorHidsInRanges
implements IHidVisitor<RfHidOperator> {
    protected IHidHolder holder;
    protected ParserPath parserPath;
    private int selectionStartOffset;
    private int selectionEndOffset;
    private List<Position> selectionRanges;
    private List<Position> assignsRanges;
    private Set<RfHidOperator> operatorsInSelection = new LinkedHashSet<RfHidOperator>();
    private ParserPath selectionParserPath;

    public CollectOperatorHidsInRanges(int selectionStartOffset, int selectionEndOffset, ParserPath selectionParserPath) {
        this.selectionRanges = new ArrayList<Position>();
        this.assignsRanges = new ArrayList<Position>();
        this.selectionStartOffset = selectionStartOffset;
        this.selectionEndOffset = selectionEndOffset;
        this.selectionParserPath = selectionParserPath;
    }

    public boolean visit(RfHidOperator operator) {
        if (this.selectionStartOffset >= operator.getOpenBoundary() && this.selectionEndOffset <= operator.getCloseBoundary()) {
            return false;
        }
        if (!this.parserPath.equals((Object)this.selectionParserPath)) {
            return false;
        }
        for (Position crtRange : this.selectionRanges) {
            int endOffset;
            int startOffset = crtRange.getOffset();
            if (!DVTQuickFixUtil.isOperatorInSelection((HidOperator)operator, (int)startOffset, (int)(endOffset = crtRange.getOffset() + crtRange.getLength() - 1))) continue;
            this.operatorsInSelection.add(operator);
            if (!operator.hasOccurrence(HidOperatorQualifier.IS_CONTINUOUS_ASSIGN)) continue;
            this.assignsRanges.add((Position)new DVTPosition(operator.getOpenBoundary(), operator.getCloseBoundary() - operator.getOpenBoundary()));
        }
        return true;
    }

    public boolean hasAllOperatorsInAssignsArea() {
        if (this.assignsRanges.isEmpty() && !this.operatorsInSelection.isEmpty()) {
            return false;
        }
        for (RfHidOperator operator : this.operatorsInSelection) {
            boolean operatorIsInAssign = false;
            for (Position zone : this.assignsRanges) {
                if (operator.getOpenBoundary() < zone.getOffset() || operator.getCloseBoundary() > zone.getOffset() + zone.getLength()) continue;
                operatorIsInAssign = true;
                break;
            }
            if (operatorIsInAssign) continue;
            return false;
        }
        return true;
    }

    public Class<RfHidOperator> getType() {
        return RfHidOperator.class;
    }

    public void setHolder(IHidHolder holder) {
        this.holder = holder;
    }

    public void setParserPath(ParserPath parserPath) {
        this.parserPath = parserPath;
    }

    public void setRanges(List<Position> ranges) {
        this.selectionRanges = ranges;
    }
}

