/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist.util;

import java.util.LinkedHashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public class CollectOperatorHidsInSelection
implements IHidVisitor<RfHidOperator> {
    protected IHidHolder holder;
    protected ParserPath parserPath;
    protected ParserPath selectionParserPath;
    private int startOffset;
    private int endOffset;
    private Set<RfHidOperator> operatorsInSelection = new LinkedHashSet<RfHidOperator>();
    private boolean containsTimeComsumingOperators = false;

    public CollectOperatorHidsInSelection(ParserPath selectionParserPath, int startOffset, int endOffset) {
        this.selectionParserPath = selectionParserPath;
        this.setStartOffset(startOffset);
        this.setEndOffset(endOffset);
    }

    public boolean visit(RfHidOperator operator) {
        if (!this.parserPath.equals((Object)this.selectionParserPath)) {
            return false;
        }
        if (DVTQuickFixUtil.isOperatorInSelection((HidOperator)operator, (int)this.startOffset, (int)this.endOffset)) {
            this.operatorsInSelection.add(operator);
            if (operator.hasOccurrence(HidOperatorQualifier.IS_DELAY_CONTROL) || operator.hasOccurrence(HidOperatorQualifier.IS_EVENT_CONTROL)) {
                this.containsTimeComsumingOperators = true;
            }
        }
        return true;
    }

    public Class<RfHidOperator> getType() {
        return RfHidOperator.class;
    }

    public void setHolder(IHidHolder holder) {
        this.holder = holder;
    }

    public void setParserPath(ParserPath parserPath) {
        this.parserPath = parserPath;
    }

    public boolean containsTimeComsumingOperators() {
        return this.containsTimeComsumingOperators;
    }

    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    public void setStartOffset(int startOffset) {
        this.startOffset = startOffset;
    }

    public Set<RfHidOperator> getOperatorsInSelection() {
        return this.operatorsInSelection;
    }
}

