/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist.util;

import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.TypeName;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;

public final class QuickAssistHidImplicitTypeVisitor
implements IHidVisitor<IHidObject> {
    private int fStartOffset;
    private int fEndOffset;
    private IHidHolder holder;
    private ParserPath parserPath;
    private RfProject rfProject;
    private String typeName;
    private String unpackedDimension;
    private boolean extractVariable;
    private String selectedText;

    public QuickAssistHidImplicitTypeVisitor(int startOffset, int endOffset, RfProject rfProject, String selectedText, boolean extractVariable) {
        this.fStartOffset = startOffset;
        this.fEndOffset = endOffset;
        this.rfProject = rfProject;
        this.extractVariable = extractVariable;
        this.selectedText = selectedText;
    }

    public boolean visit(IHidObject hidObject) {
        if (!(hidObject instanceof RfHidOperator)) {
            return true;
        }
        RfHidOperator operator = (RfHidOperator)hidObject;
        if (operator.getOpenBoundary() > this.fStartOffset || operator.getCloseBoundary() < this.fEndOffset) {
            return true;
        }
        IHidObject lhValue = operator.getLHValue();
        if (!this.checkImplicitHid(lhValue)) {
            return false;
        }
        ListContainer rhValues = operator.getRHValues();
        if (rhValues == null) {
            return true;
        }
        for (IHidObject rhValue : rhValues) {
            if (this.checkImplicitHid(rhValue)) continue;
            return false;
        }
        return true;
    }

    private boolean checkImplicitHid(IHidObject hidValue) {
        if (!(hidValue instanceof HidImplicit)) {
            return true;
        }
        if (!this.selectedText.trim().equals(((RfHidImplicit)hidValue).getName())) {
            return true;
        }
        TypeName type = VlogQuickFixUtil.getInstance().computeTypeNameAndDimFromHidObject(RfTypesResolver.create((IRfScopeElement)(this.holder instanceof HidHolder ? ((HidHolder)this.holder).getScope() : null), this.rfProject, 14), hidValue, this.holder instanceof HidHolder ? ((HidHolder)this.holder).getScope() : null, this.parserPath, this.rfProject);
        if (type == null) {
            if (this.extractVariable) {
                this.typeName = "integer";
            }
        } else {
            this.typeName = type.getTypeName();
            this.unpackedDimension = type.getUnpackedDim();
        }
        return false;
    }

    public Class<IHidObject> getType() {
        return IHidObject.class;
    }

    public void setHolder(IHidHolder holder) {
        this.holder = holder;
    }

    public void setParserPath(ParserPath parserPath) {
        this.parserPath = parserPath;
    }

    public TypeName getTypeName() {
        return new TypeName(this.typeName, this.unpackedDimension);
    }
}

