/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist.util;

import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifier;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

public class QuickAssistIfLoopCaseHidVisitor
extends RfHidVisitor {
    private int fSelectedTextStartOffset;
    private int fSelectedTextEndOffset;
    private boolean isInIfCaseLoop;

    public QuickAssistIfLoopCaseHidVisitor(int startOffset, int endOffset) {
        this.fSelectedTextStartOffset = startOffset;
        this.fSelectedTextEndOffset = endOffset;
    }

    public boolean visit(RfHid hid) {
        HidOccurrence hidOccurrence = hid.getOccurrence();
        if (hidOccurrence == null) {
            return true;
        }
        int occurrenceOffset = hidOccurrence.getOffset();
        if (occurrenceOffset >= this.fSelectedTextStartOffset && occurrenceOffset <= this.fSelectedTextEndOffset) {
            if (!hidOccurrence.hasQualifier(HidQualifier.HID_IS_IF_CASE_LOOP_EXPR)) {
                return true;
            }
            this.setInIfCaseLoop(true);
            return false;
        }
        return true;
    }

    public boolean isInIfCaseLoop() {
        return this.isInIfCaseLoop;
    }

    public void setInIfCaseLoop(boolean isInIfCaseLoop) {
        this.isInIfCaseLoop = isInIfCaseLoop;
    }
}

