/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidAccessArgs;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;
import ro.amiq.dvt.ui.trace.connections.model.TCLogic;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.ui.editor.quickassist.util.VlogQuickAssistUtil;

public class QuickAssistInputOutputHidsVisitor
implements IHidVisitor<RfHidOperator> {
    public static final Set<HidFlatteningOption> FLATTENING_OPTIONS = Collections.unmodifiableSet(EnumSet.of(HidFlatteningOption.IGNORE_CONSTANTS, HidFlatteningOption.IGNORE_IMPLICITS));
    private List<IHid> inputHids = new ArrayList<IHid>();
    private List<IHid> outputHids = new ArrayList<IHid>();
    private List<IHid> inoutHids = new ArrayList<IHid>();
    private List<IHid> refHids = new ArrayList<IHid>();
    private int fStartOffset;
    private int fEndOffset;
    private Set<IHid> inputCandidates;
    private Set<IHid> outputCandidates;
    private Set<IHid> refCandidates;

    public QuickAssistInputOutputHidsVisitor(int startOffset, int endOffset) {
        this.fStartOffset = startOffset;
        this.fEndOffset = endOffset;
        this.inputCandidates = new LinkedHashSet<IHid>();
        this.outputCandidates = new LinkedHashSet<IHid>();
        this.refCandidates = new LinkedHashSet<IHid>();
    }

    public boolean visit(RfHidOperator operator) {
        if (!DVTQuickFixUtil.isOperatorInSelection((HidOperator)operator, (int)this.fStartOffset, (int)this.fEndOffset)) {
            return true;
        }
        if (operator.isComplete()) {
            TCLogic outputAndInputs = new TCLogic();
            VlogQuickAssistUtil.collectOutputsAndInputs(operator, outputAndInputs, FLATTENING_OPTIONS);
            for (IHid iHid : outputAndInputs.getCommonDrivers()) {
                Hid inputCandidate = ((Hid)iHid).getAncestorHid();
                if (!DVTQuickFixUtil.isHidInSelection((IHid)inputCandidate, (int)this.fStartOffset, (int)this.fEndOffset) || this.addArrayToRefList((IHid)inputCandidate, inputCandidate.getElement(), this.refCandidates)) continue;
                this.inputCandidates.add((IHid)inputCandidate);
            }
            for (Map.Entry entry : outputAndInputs.getLoadDrivers().entrySet()) {
                Hid outputCandidate = ((Hid)entry.getKey()).getAncestorHid();
                if (DVTQuickFixUtil.isHidInSelection((IHid)outputCandidate, (int)this.fStartOffset, (int)this.fEndOffset) && !this.addArrayToRefList((IHid)outputCandidate, outputCandidate.getElement(), this.refCandidates)) {
                    this.outputCandidates.add((IHid)outputCandidate);
                }
                Collection inputs = (Collection)entry.getValue();
                for (IHid input : inputs) {
                    Hid inputCandidate = ((Hid)input).getAncestorHid();
                    if (!DVTQuickFixUtil.isHidInSelection((IHid)inputCandidate, (int)this.fStartOffset, (int)this.fEndOffset) || this.addArrayToRefList((IHid)inputCandidate, inputCandidate.getElement(), this.refCandidates)) continue;
                    this.inputCandidates.add((IHid)inputCandidate);
                }
            }
        }
        return true;
    }

    public void computeOutInRefsAndInouts() {
        for (IHid inHid : this.inputCandidates) {
            if (this.refCandidates.contains(inHid)) continue;
            if (this.outputCandidates.contains(inHid)) {
                this.inoutHids.add(inHid);
                continue;
            }
            this.inputHids.add(inHid);
        }
        for (IHid outHid : this.outputCandidates) {
            if (this.refCandidates.contains(outHid) || this.inputCandidates.contains(outHid)) continue;
            this.outputHids.add(outHid);
        }
        this.refHids.addAll(this.refCandidates);
    }

    public void addExtraInputs(Set<IHid> extraInputs) {
        block0: for (IHid hid : extraInputs) {
            IRfNamedElement element = hid.getElement();
            if (element != null) {
                for (IHid outHid : this.outputHids) {
                    if (hid.getElement().equals(outHid.getElement())) continue block0;
                }
                for (IHid inHid : this.inputHids) {
                    if (hid.getElement().equals(inHid.getElement())) continue block0;
                }
                for (IHid inoutHid : this.inoutHids) {
                    if (hid.getElement().equals(inoutHid.getElement())) continue block0;
                }
                for (IHid inoutHid : this.refHids) {
                    if (hid.getElement().equals(inoutHid.getElement())) continue block0;
                }
            }
            if (this.addArrayToRefList(hid, element, this.refHids)) continue;
            this.inputHids.add(hid);
        }
    }

    public Collection<IHid> getInputHids() {
        return this.inputHids;
    }

    public Collection<IHid> getOutputHids() {
        return this.outputHids;
    }

    public Collection<IHid> getInoutHids() {
        return this.inoutHids;
    }

    public Collection<IHid> getRefHids() {
        return this.refHids;
    }

    public Class<RfHidOperator> getType() {
        return RfHidOperator.class;
    }

    public void setHolder(IHidHolder holder) {
    }

    public void setParserPath(ParserPath parserPath) {
    }

    public void processHidsFromMethodCall(List<IHidAccessArgs> argumentsHid) {
        if (argumentsHid == null || argumentsHid.isEmpty()) {
            return;
        }
        for (IHidAccessArgs methodCallHid : argumentsHid) {
            List argumentValues = methodCallHid.getArgumentValues();
            if (argumentValues == null) continue;
            int i = 0;
            while (i < argumentValues.size()) {
                block7: {
                    ListContainer rhValues;
                    String directionString;
                    block10: {
                        List<RfField> funcArgs;
                        IRfNamedElement rfNamedElement;
                        Hid parentHid;
                        block9: {
                            RfHidOperator operator;
                            IHidObject hidObj;
                            block8: {
                                hidObj = (IHidObject)argumentValues.get(i);
                                directionString = "";
                                if (!(hidObj instanceof RfHidOperator) || (rhValues = (operator = (RfHidOperator)hidObj).getRHValues()) == null || rhValues.isEmpty()) break block7;
                                if (rhValues.size() <= 1) break block8;
                                for (IHidObject rhValue : rhValues) {
                                    IRfNamedElement element;
                                    if (!(rhValue instanceof IHid) || this.addArrayToRefList((IHid)rhValue, element = ((IHid)rhValue).getElement(), this.refCandidates)) continue;
                                    this.inputCandidates.add((IHid)rhValue);
                                }
                                break block7;
                            }
                            if (MethodCallUtils.isOrdered((IHidObject)hidObj)) break block9;
                            IHidObject lhValue = operator.getLHValue();
                            IRfNamedElement element = ((RfHid)lhValue).getElement();
                            if (element == null) break block7;
                            directionString = ((RfField)element).getDirectionString();
                            break block10;
                        }
                        if (!(methodCallHid instanceof RfHidAccessArgs) || (parentHid = ((RfHidAccessArgs)methodCallHid).getParentHid()) == null || (rfNamedElement = parentHid.getElement()) == null || i >= (funcArgs = ((RfFunction)rfNamedElement).getArgumentsWithPrefix("", 2)).size()) break block7;
                        directionString = funcArgs.get(i).getDirectionString();
                    }
                    this.addHidToCandidateList(directionString, (IHidObject)rhValues.get(0));
                }
                ++i;
            }
        }
    }

    private void addHidToCandidateList(String directionString, IHidObject hidObj) {
        Hid parentHid;
        IHid val;
        IHid iHid = val = hidObj instanceof IHid ? (IHid)hidObj : null;
        if (hidObj instanceof RfHidAccess && (parentHid = ((RfHidAccess)hidObj).getParentHid()) != null) {
            val = parentHid.getAncestorHid();
        }
        if (val == null) {
            return;
        }
        this.addArrayToRefList(val, val.getElement(), this.refCandidates);
        if ("input".equals(directionString)) {
            this.inputCandidates.add(val);
        }
        if ("output".equals(directionString)) {
            this.outputCandidates.add(val);
        }
        if ("inout".equals(directionString)) {
            this.inputCandidates.add(val);
            this.outputCandidates.add(val);
        }
        if ("ref".equals(directionString)) {
            this.refCandidates.add(val);
        }
    }

    private boolean addArrayToRefList(IHid val, IRfNamedElement element, Collection<IHid> result) {
        if (!(element instanceof RfField)) {
            return false;
        }
        DataType dataType = ((RfField)element).getDataType();
        if (dataType == null || !dataType.isArray()) {
            return false;
        }
        result.add(val);
        return true;
    }
}

