/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfNamedActionBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.ui.search.new_engine.VlogHidMatch;

public class QuickAssistModuleHidsVisitor
extends RfHidVisitor {
    private Set<VlogHidMatch> referencesOfElementsInModule = new HashSet<VlogHidMatch>();
    private Set<RfNamedElement> elementsReferencedInSelection = new HashSet<RfNamedElement>();
    private Set<RfNamedElement> instancesAndBlocksReferencedOutsideSelection = new HashSet<RfNamedElement>();
    private Map<RfActionBlock, Set<RfNamedElement>> elementsReferencedOutsideSelectionByBlock = new HashMap<RfActionBlock, Set<RfNamedElement>>();
    private RfActionBlock currentActionBlock;
    private int selectionStartOffset;
    private int selectionEndOffset;
    private ParserPath selectionParserPath;

    public QuickAssistModuleHidsVisitor(int selectionStartOffset, int selectionEndOffset, ParserPath selectionParserPath) {
        this.selectionStartOffset = selectionStartOffset;
        this.selectionEndOffset = selectionEndOffset;
        this.selectionParserPath = selectionParserPath;
    }

    @Override
    public void setParserPath(ParserPath parserPath) {
        this.parserPath = parserPath;
    }

    @Override
    public void setHolder(IHidHolder holder) {
        if (!(holder instanceof RfHidHolder)) {
            return;
        }
        IRfNamedElement scope = ((RfHidHolder)holder).getScope();
        if (scope == null) {
            return;
        }
        if (this.currentActionBlock != null) {
            if (this.isParentScope(this.currentActionBlock, (IRfScopeElement)scope)) {
                return;
            }
            this.currentActionBlock = null;
        }
        if (!(scope instanceof RfActionBlock)) {
            return;
        }
        RfActionBlock actionBlock = (RfActionBlock)scope;
        if (!actionBlock.isAlways()) {
            return;
        }
        this.currentActionBlock = actionBlock;
        this.elementsReferencedOutsideSelectionByBlock.put(this.currentActionBlock, new HashSet());
        super.setHolder(holder);
    }

    private boolean isParentScope(IRfScopeElement parent, IRfScopeElement child) {
        while (child != parent) {
            if ((child = child.getEnclosingScope()) != null) continue;
            return false;
        }
        return true;
    }

    public boolean visit(RfHid hid) {
        if (!this.parserPath.equals((Object)this.selectionParserPath)) {
            return false;
        }
        if (hid.getParentAccess() != null && hid.getParentAccess().getAccessKind() == 4) {
            return true;
        }
        String hidName = hid.getName();
        if (hidName == null) {
            return true;
        }
        this.referencesOfElementsInModule.add(new VlogHidMatch(false, null, hid, null, this.parserPath, null));
        if (!DVTQuickFixUtil.isHidInSelection((IHid)hid, (int)this.selectionStartOffset, (int)this.selectionEndOffset)) {
            if (this.currentActionBlock != null) {
                this.elementsReferencedOutsideSelectionByBlock.get(this.currentActionBlock).add((RfNamedElement)hid.getElement());
            }
            if (hid.getElement() instanceof RfInstance || hid.getElement() instanceof RfNamedActionBlock) {
                this.instancesAndBlocksReferencedOutsideSelection.add((RfNamedElement)hid.getElement());
            }
            return true;
        }
        this.elementsReferencedInSelection.add((RfNamedElement)hid.getElement());
        return true;
    }

    public Set<RfNamedElement> getElementsReferencedInSelection() {
        return this.elementsReferencedInSelection;
    }

    public Set<RfNamedElement> getInstancesAndBlocksReferencedOutsideSelection() {
        return this.instancesAndBlocksReferencedOutsideSelection;
    }

    public Set<VlogHidMatch> getReferencesOfElementsInModule() {
        return this.referencesOfElementsInModule;
    }

    public Map<RfActionBlock, Set<RfNamedElement>> getElementsReferencedOutsideSelectionByBlock() {
        return this.elementsReferencedOutsideSelectionByBlock;
    }
}

