/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist.util;

import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.TypeName;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;

public class QuickAssistVariableTypeVisitor
implements IHidVisitor<HidOperator> {
    private int selectedTextStartOffset;
    private int selectedTextEndOffset;
    private String typeName;
    private String unpackedDimension;
    private IHidHolder holder;
    private ParserPath parserPath;
    private RfProject rfProject;

    public QuickAssistVariableTypeVisitor(int startOffset, int endOffset, RfProject rfProject) {
        this.selectedTextStartOffset = startOffset;
        this.selectedTextEndOffset = endOffset;
        this.rfProject = rfProject;
    }

    public void setHolder(IHidHolder holder) {
        this.holder = holder;
    }

    public void setParserPath(ParserPath parserPath) {
        this.parserPath = parserPath;
    }

    public boolean visit(HidOperator operator) {
        HidOperatorOccurrence hidOccurrence = operator.getOccurrence();
        if (hidOccurrence == null) {
            return true;
        }
        int occurrenceOffset = hidOccurrence.getOffset();
        if (occurrenceOffset > this.selectedTextStartOffset && occurrenceOffset < this.selectedTextEndOffset) {
            TypeName type = VlogQuickFixUtil.getInstance().computeTypeNameAndDimFromHidObject(RfTypesResolver.create((IRfScopeElement)((HidHolder)this.holder).getScope(), this.rfProject, 14), (IHidObject)operator, this.holder instanceof HidHolder ? ((HidHolder)this.holder).getScope() : null, this.parserPath, this.rfProject);
            if (type == null) {
                this.typeName = "integer";
            } else {
                this.typeName = type.getTypeName();
                this.unpackedDimension = type.getUnpackedDim();
            }
            return false;
        }
        return true;
    }

    public Class<HidOperator> getType() {
        return HidOperator.class;
    }

    public TypeName getTypeName() {
        return new TypeName(this.typeName, this.unpackedDimension);
    }
}

