/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist.util;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.ui.editor.quickassist.util.VlogQuickAssistUtil;

public class SplitInfoWrapper {
    private int implementationOffset;
    private String implementationIndent;
    private String bodyRelativeIndent;
    private String body;
    private IDocument implementationDocument;

    public SplitInfoWrapper(IDocument document, RfNamedElement classScope, RfDefElement defElement, char startChar) throws BadLocationException {
        this.body = VlogQuickAssistUtil.extractBodyFromFunctionOrConstraint(defElement, startChar, document);
        DocumentManager docManager = new DocumentManager();
        try {
            docManager.activate();
            document = docManager.getDocument(classScope.getDeclaration().getParserPath(), classScope.getRfProject().getProject());
        }
        finally {
            docManager.deactivate();
        }
        this.implementationDocument = document;
        int endOffset = classScope.getDeclaration().getEndOffset();
        this.implementationIndent = DVTDocumentUtils.getIndent((int)endOffset, (IDocument)this.implementationDocument);
        if (this.body.trim().isEmpty()) {
            this.body = this.body.trim();
        }
        int relativeIndentOffset = VlogQuickAssistUtil.getLineFirstCharOffsetInLine(defElement.getStartOffset(), document);
        this.bodyRelativeIndent = DVTDocumentUtils.getIndent((int)relativeIndentOffset, (IDocument)document);
        IRegion endLineInfo = this.implementationDocument.getLineInformationOfOffset(endOffset);
        this.implementationOffset = endLineInfo.getOffset() + endLineInfo.getLength();
    }

    public int getImplementationOffset() {
        return this.implementationOffset;
    }

    public String getImplementationIndent() {
        return this.implementationIndent;
    }

    public IDocument getImplementationDocument() {
        return this.implementationDocument;
    }

    public String getBody() {
        return this.body;
    }

    public String getBodyRelativeIndent() {
        return this.bodyRelativeIndent;
    }
}

