/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickassist.util.DVTQuickAssistUtil;
import ro.amiq.dvt.ui.trace.connections.model.TCLogic;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.linter.utils.LintExpr;
import ro.amiq.vlogdt.linter.utils.LintExprFactory;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfModuleDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPortDef;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.ui.editor.quickassist.MethodObjectVisitor;
import ro.amiq.vlogdt.ui.editor.quickassist.util.ElementType;
import ro.amiq.vlogdt.ui.editor.quickassist.util.QuickAssistHidImplicitTypeVisitor;
import ro.amiq.vlogdt.ui.editor.quickassist.util.SplitInfoWrapper;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.TypeName;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.editor.utils.VlogConstraintUtils;
import ro.amiq.vlogdt.ui.editor.utils.VlogFunctionSignatureUtils;
import ro.amiq.vlogdt.ui.preferences.PrefConst;
import ro.amiq.vlogdt.ui.views.templates.VlogConstraintTemplateConfig;
import ro.amiq.vlogdt.ui.views.templates.VlogConstraintTemplateInserter;
import ro.amiq.vlogdt.ui.views.templates.VlogMethodTemplateConfig;
import ro.amiq.vlogdt.ui.views.templates.VlogMethodTemplateInserter;

public class VlogQuickAssistUtil
extends DVTQuickAssistUtil {
    private static final String BIT = "bit";
    private static final String VOID = "void";
    public static final Set<String> PREPROCESSOR_DIRECTIVES = new HashSet<String>(Arrays.asList("ifdef", "ifndef", "elsif", "else", "endif", "begin_keywords", "end_keywords", "protect", "protected", "endprotect", "endprotected", "celldefine", "endcelldefine"));
    public static final Set<HidFlatteningOption> FLATTENING_OPTIONS_IGNORE_IMPLICITS = Collections.unmodifiableSet(EnumSet.of(HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS, HidFlatteningOption.IGNORE_METHOD_CALL_ARGUMENTS, HidFlatteningOption.IGNORE_CONSTANTS, HidFlatteningOption.IGNORE_IMPLICITS));

    public static String extractBodyFromFunctionOrConstraint(RfDefElement defElement, char startChar, IDocument document) {
        StringBuilder result = new StringBuilder();
        try {
            IRegion bodyRegion = VlogQuickAssistUtil.getBodyRegion(defElement, document, startChar);
            int startOffset = bodyRegion.getOffset();
            IRegion startLineInfo = document.getLineInformationOfOffset(startOffset);
            int endOffset = startOffset + bodyRegion.getLength();
            IRegion endLineInfo = document.getLineInformationOfOffset(endOffset);
            int currentOffset = startOffset;
            while (currentOffset < endOffset) {
                StringBuilder firstLineString = new StringBuilder();
                if (VlogQuickAssistUtil.regionContainsOffset(currentOffset, startLineInfo)) {
                    while (VlogQuickAssistUtil.regionContainsOffset(currentOffset, startLineInfo) && currentOffset < endOffset - 1) {
                        firstLineString.append(document.getChar(currentOffset));
                        ++currentOffset;
                    }
                }
                if (!firstLineString.toString().trim().isEmpty()) {
                    result.append((CharSequence)firstLineString);
                }
                result.append(document.getChar(currentOffset));
                char nextChar = document.getChar(++currentOffset);
                if (!System.lineSeparator().equals(Character.toString(nextChar)) || !VlogQuickAssistUtil.regionContainsOffset(currentOffset + 1, endLineInfo)) continue;
                StringBuilder lastLineString = new StringBuilder();
                ++currentOffset;
                while (VlogQuickAssistUtil.regionContainsOffset(currentOffset, endLineInfo) && currentOffset < endOffset - 1) {
                    lastLineString.append(document.getChar(currentOffset));
                    ++currentOffset;
                }
                if (lastLineString.toString().trim().isEmpty()) continue;
                result.append((CharSequence)lastLineString);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result.toString();
    }

    private static boolean regionContainsOffset(int offset, IRegion region) {
        int regionStartOffset = region.getOffset();
        return regionStartOffset <= offset && offset <= regionStartOffset + region.getLength();
    }

    public static IRegion getBodyRegion(RfDefElement defElement, IDocument document, char startCharacter) throws BadLocationException, BadPartitioningException {
        int startOffset = defElement.getStartOffset();
        int bodyStartOffset = DVTDocumentUtils.getCharOffset((char)startCharacter, (int)startOffset, (boolean)true, (int)(defElement.getEndOffset() + 1000), (IDocument)document, (String)"__vlog_partitioning") + 1;
        int bodyEndOffset = defElement.getEndOffset();
        return new Region(bodyStartOffset, bodyEndOffset - bodyStartOffset);
    }

    public static int getLineFirstCharOffsetInLine(int offset, IDocument document) throws BadLocationException {
        int startOffset;
        IRegion lineInfo = document.getLineInformationOfOffset(offset);
        int result = startOffset = lineInfo.getOffset();
        while (result < startOffset + lineInfo.getLength()) {
            if (!Character.isWhitespace(document.getChar(result))) break;
            ++result;
        }
        return result;
    }

    public static RfDefElement getDefElementAtCursorLine(int offset, DVTEditor editor, IDocument document, ElementType type) throws BadLocationException {
        RfDefElement result = VlogQuickAssistUtil.getDefElementAtCursorLineInternal(offset, editor, document, type);
        if (result == null) {
            return null;
        }
        int cursorLine = document.getLineOfOffset(offset);
        if (cursorLine != result.getStartLine() - 1) {
            return null;
        }
        return result;
    }

    private static RfDefElement getDefElementAtCursorLineInternal(int offset, DVTEditor editor, IDocument document, ElementType type) throws BadLocationException {
        IRfScope cursorScope = RfUtils.getRfScope((ITextEditor)editor, document, offset);
        if (!(cursorScope instanceof RfDefElement)) {
            return null;
        }
        if (type.matches(cursorScope)) {
            return (RfDefElement)cursorScope;
        }
        Collection<RfDefElement> children = ((RfDefElement)cursorScope).getChildren();
        if (children == null || children.isEmpty()) {
            return null;
        }
        IRegion cursorLineInfo = document.getLineInformationOfOffset(offset);
        for (RfDefElement child : children) {
            int childStartOffset = child.getStartOffset();
            if (!type.matches(child) || childStartOffset < cursorLineInfo.getOffset() || childStartOffset > cursorLineInfo.getOffset() + cursorLineInfo.getLength()) continue;
            return child;
        }
        return null;
    }

    public static void collectOutputsAndInputs(RfHidOperator operator, TCLogic outputAndInputs, Set<HidFlatteningOption> options) {
        if (operator == null) {
            return;
        }
        if (operator.isIncrementOrDecrement()) {
            Set lhHids = operator.getLHHids(options);
            for (IHid lhHid : lhHids) {
                outputAndInputs.addLoad(lhHid, (Collection)lhHids);
            }
        } else if (operator.hasOccurrence(HidOperatorQualifier.IS_EVENT_CONTROL)) {
            IHidObject lhValue = operator.getLHValue();
            if (HidUtils.isOperator((IHidObject)lhValue) && ((IHidOperator)lhValue).isRepeat()) {
                lhValue = ((IHidOperator)lhValue).getFirstRHValue();
            }
            Set lhHids = HidUtils.flattenToHids((IHidObject)lhValue, options);
            outputAndInputs.addCommonDrivers((Collection)lhHids);
        } else if (operator.hasOccurrence(HidOperatorQualifier.IS_EVENT_TRIGGER)) {
            Set lhHids = operator.getLHHids(options);
            for (IHid lhHid : lhHids) {
                outputAndInputs.addLoad(lhHid, Collections.emptyList());
            }
        } else if (operator.hasOccurrence(HidQualifierCache.IS_CONDITIONAL_EXPRESSION_QUALIFIER + HidQualifierCache.ALL_DECLARATION_QUALIFIERS + HidQualifierCache.ALL_SIMPLE_ASSIGN_QUALIFIERS + HidQualifierCache.ALL_SELECT_ASSIGN_QUALIFIERS)) {
            DesignUtils.collectConcurrentDriversAndLoads((IHidOperator)operator, (TCLogic)outputAndInputs, options);
        } else {
            Set lhHids = operator.getLHHids(options);
            outputAndInputs.addCommonDrivers((Collection)lhHids);
        }
    }

    public static Object[] computeInsertOffsetAndReplacementStringAtRootContainer(IRfDefElement declarationAnchor, String elemSignature, boolean declareInside, DVTEditor editor, IDocument document) throws Exception {
        String replacementString = "";
        String newLine = System.lineSeparator();
        int indentOffset = declarationAnchor.getStartOffset();
        int insertOffset = declarationAnchor.getStartOffset();
        String indent = DVTDocumentUtils.getIndent((int)indentOffset, (IDocument)document);
        if (declarationAnchor instanceof RfFieldDef) {
            insertOffset = DVTDocumentUtils.getCharOffset((char)';', (int)declarationAnchor.getEndOffset(), (boolean)true, (int)100, (IDocument)document, (String)"__vlog_partitioning");
        }
        IRegion lineInformationOfOffset = document.getLineInformationOfOffset(insertOffset);
        if (declarationAnchor instanceof RfModuleDef) {
            indent = String.valueOf(indent) + DVTDocumentUtils.getTabOrSpace((DVTEditor)editor, (IPreferenceStore)VlogPlugin.getDefault().getCombinedPreferenceStore());
        }
        if (!declareInside && !(declarationAnchor.getNamedElement() instanceof RfField)) {
            insertOffset = lineInformationOfOffset.getOffset();
            replacementString = String.valueOf(indent) + elemSignature + newLine;
        } else if (!declareInside && declarationAnchor.getNamedElement() instanceof RfField) {
            replacementString = elemSignature;
            if (declarationAnchor.getNamedElement() instanceof RfInstance) {
                insertOffset = declarationAnchor.getStartOffset();
                replacementString = String.valueOf(replacementString) + newLine + indent;
            } else {
                insertOffset = lineInformationOfOffset.getOffset() + lineInformationOfOffset.getLength();
                replacementString = String.valueOf(newLine) + indent + replacementString;
                if (declarationAnchor instanceof RfPortDef && ((RfPortDef)declarationAnchor).isInListOfPorts()) {
                    insertOffset = DVTDocumentUtils.getCharOffset((char)';', (int)indentOffset, (boolean)true, (int)100, (IDocument)document, (String)"__vlog_partitioning") + 1;
                }
            }
        } else {
            insertOffset = lineInformationOfOffset.getOffset() + lineInformationOfOffset.getLength();
            replacementString = String.valueOf(newLine) + indent + elemSignature;
        }
        if (insertOffset < 0 || replacementString.isEmpty()) {
            return null;
        }
        return new Object[]{insertOffset, replacementString};
    }

    public static Object[] computeSplitMethodPrototypeInfo(IDocument document, DVTEditor editor, RfNamedElement functionNamedElement, RfDefElement functionDefElement, boolean isTask, boolean useDefaultTemplate) throws BadLocationException {
        IRegion functionStartLineInfo = document.getLineInformationOfOffset(functionNamedElement.getStartOffset());
        int functionPrototypeInsertOffset = functionStartLineInfo.getOffset();
        String prototypeIndent = DVTDocumentUtils.getIndent((int)functionPrototypeInsertOffset, (IDocument)document);
        String functionPrototype = String.valueOf(prototypeIndent) + VlogFunctionSignatureUtils.computeFunctionPrototype(editor, document, (RfFunction)functionNamedElement, 0, true, useDefaultTemplate);
        int functionEndOffset = functionDefElement.getEndOffset();
        int endElementOffset = VlogQuickFixUtil.getInstance().getForwardOffsetFor(document, isTask ? "endtask" : "endfunction", functionEndOffset, functionEndOffset + 100, false);
        IRegion endLineInfo = document.getLineInformationOfOffset(endElementOffset);
        int startDeleteOffset = functionPrototypeInsertOffset;
        int endDeleteOffset = endLineInfo.getOffset() + endLineInfo.getLength();
        int length = endDeleteOffset - startDeleteOffset;
        return new Object[]{functionPrototypeInsertOffset, length, functionPrototype};
    }

    public static Object[] computeSplitMethodImplementationInfo(IDocument document, DVTEditor targerEditor, RfNamedElement classScope, RfNamedElement functionNamedElement, RfDefElement functionDefElement, boolean useDefaultTemplate) throws BadLocationException {
        SplitInfoWrapper splitInfoWrapper = new SplitInfoWrapper(document, classScope, functionDefElement, ';');
        VlogMethodTemplateConfig config = (VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)new VlogMethodTemplateConfig().setTemplate("method_implementation")).setEditor((IEditorPart)targerEditor)).setDocument(splitInfoWrapper.getImplementationDocument())).setDocumentOffset(splitInfoWrapper.getImplementationOffset())).setCursorScope(classScope).setExternImplementation(true).setFunction(RfTypesResolver.create((IRfScopeElement)functionNamedElement, functionNamedElement.getRfProject(), 14), (RfFunction)functionNamedElement).setIndent(splitInfoWrapper.getImplementationIndent())).setBodyRelativeIndent(splitInfoWrapper.getBodyRelativeIndent()).setBody(splitInfoWrapper.getBody(), false, false).setJavadocReplacement("")).setLeadingNewlines(2)).setTrailingNewlines(-1)).setUseDefaultTemplate(useDefaultTemplate);
        String functionImplementation = new VlogMethodTemplateInserter(config).parse();
        return new Object[]{splitInfoWrapper.getImplementationOffset(), functionImplementation};
    }

    public static Object[] computeSplitConstraintPrototypeInfo(IDocument document, DVTEditor editor, RfNamedElement constraintNamedElement) throws BadLocationException {
        IRegion constraintStartLineInfo = document.getLineInformationOfOffset(constraintNamedElement.getStartOffset());
        int constraintPrototypeInsertOffset = constraintStartLineInfo.getOffset();
        String prototypeIndent = DVTDocumentUtils.getIndent((int)constraintPrototypeInsertOffset, (IDocument)document);
        String constraintPrototype = String.valueOf(prototypeIndent) + VlogConstraintUtils.computeConstraintPrototype(editor, document, (RfConstraint)constraintNamedElement, 0, true, false, true, false);
        int startDeleteOffset = constraintPrototypeInsertOffset;
        int endDeleteOffset = constraintNamedElement.getEndOffset() + 1;
        int length = endDeleteOffset - startDeleteOffset;
        return new Object[]{constraintPrototypeInsertOffset, length, constraintPrototype};
    }

    public static Object[] computeSplitConstraintImplementationInfo(IDocument document, DVTEditor targetEditor, RfNamedElement classScope, RfNamedElement constraintNamedElement, RfDefElement constraintDefElement) throws BadLocationException {
        SplitInfoWrapper splitInfoWrapper = new SplitInfoWrapper(document, classScope, constraintDefElement, '{');
        VlogConstraintTemplateConfig config = (VlogConstraintTemplateConfig)((VlogConstraintTemplateConfig)((VlogConstraintTemplateConfig)((VlogConstraintTemplateConfig)((VlogConstraintTemplateConfig)((VlogConstraintTemplateConfig)((VlogConstraintTemplateConfig)((VlogConstraintTemplateConfig)new VlogConstraintTemplateConfig().setTemplate("constraint_implementation")).setEditor((IEditorPart)targetEditor)).setDocument(splitInfoWrapper.getImplementationDocument())).setDocumentOffset(splitInfoWrapper.getImplementationOffset())).setCursorScope(classScope).setExternImplementation(true).setConstraintInfo((RfConstraint)constraintNamedElement, false).setIndent(splitInfoWrapper.getImplementationIndent())).setBodyRelativeIndent(splitInfoWrapper.getBodyRelativeIndent()).setBody(splitInfoWrapper.getBody(), false, false).setIndentFirstLine(true)).setTodoComment("").setLeadingNewlines(1)).setTrailingNewlines(-1);
        String constraintImplementation = new VlogConstraintTemplateInserter(config).parse();
        return new Object[]{splitInfoWrapper.getImplementationOffset(), constraintImplementation};
    }

    private static TypeName computeConditionalExpressionReturnType(RfDefElement triggerEnclContainerDefElement, final int startOffset, final int endOffset, final int adjustedSelectedTextLength) {
        ArrayList<RfDefElement> childrenInScope = new ArrayList<RfDefElement>();
        Collection<RfDefElement> children = triggerEnclContainerDefElement.getChildren();
        VlogQuickAssistUtil.computeChildrenInScope(startOffset, childrenInScope, children);
        final AtomicBoolean found = new AtomicBoolean(false);
        for (RfDefElement child : childrenInScope) {
            List<RfNamedElement> namedElements;
            if (!(child instanceof RfActionBlockDef) || (namedElements = ((RfActionBlockDef)child).getNamedElements()) == null) continue;
            for (RfNamedElement element : namedElements) {
                element.visitHidObject(null, (IHidVisitor<?>)new HidOperatorVisitor(null){

                    public boolean visit(HidOperator hidoperator) {
                        if (!(hidoperator.isIfCondition() || hidoperator.isForCondition() || hidoperator.isWhileCondition())) {
                            return true;
                        }
                        IHidObject lhValue = hidoperator.getLHValue();
                        if (!(lhValue instanceof RfHidOperator)) {
                            return true;
                        }
                        RfHidOperator operator = (RfHidOperator)lhValue;
                        if (operator.getOpenBoundary() < startOffset || operator.getCloseBoundary() > endOffset) {
                            return true;
                        }
                        if (operator.getCloseBoundary() - operator.getOpenBoundary() >= adjustedSelectedTextLength) {
                            found.set(true);
                        }
                        return false;
                    }
                });
            }
        }
        if (found.get()) {
            return new TypeName(BIT, "");
        }
        return null;
    }

    private static void computeChildrenInScope(int startOffset, List<RfDefElement> childrenInScope, Collection<RfDefElement> children) {
        if (children == null) {
            return;
        }
        for (RfDefElement child : children) {
            if (child.getEndOffset() < startOffset) continue;
            childrenInScope.add(child);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TypeName computeReturnTypeName(RfProject rfProject, IDocument document, ParserPath parserPath, ReparseInfo reparseInfo, int startOffset, int endOffset, String selectedText, RfNamedElement containerNamedElement, RfDefElement defElement, Set<RfHidOperator> compoundOperators, boolean extractVariable) {
        TypeName conditionalExpressionReturnType;
        int adjustedSelectedTextLength = VlogQuickAssistUtil.computeAdjustedSelectedTextLength(selectedText);
        if (PrefConst.isEnforceConditionDataTypeToBitEnabled(VlogPlugin.getDefault().getPreferenceStore()) && (conditionalExpressionReturnType = VlogQuickAssistUtil.computeConditionalExpressionReturnType(defElement, startOffset, endOffset, adjustedSelectedTextLength)) != null) {
            return conditionalExpressionReturnType;
        }
        try {
            TypeName typeName;
            int startLine = document.getLineOfOffset(startOffset);
            LintExprFactory lintExprFact = new LintExprFactory(rfProject);
            int endLine = document.getLineOfOffset(endOffset);
            LintExpr lintExp = lintExprFact.createLintExpr(selectedText, parserPath, startLine, startOffset, endLine, reparseInfo);
            if (lintExp != null) {
                RfNamedElement finalElement = lintExp.getElement();
                if (finalElement instanceof RfClockingBlock) {
                    return null;
                }
                char nextCodeChar = DVTDocumentUtils.nextCodeChar((IDocument)document, (int)endOffset, (String)"__vlog_partitioning", (boolean)true);
                if (finalElement instanceof RfFunction && nextCodeChar == '(') {
                    return null;
                }
                if (!(finalElement instanceof RfFunction) && !(finalElement instanceof RfField)) {
                    return null;
                }
                if (!(finalElement instanceof RfAssociatedType)) {
                    TypeName typeName2 = new TypeName();
                    typeName2.setTypeName(lintExp.getElementType().getFullName());
                    return typeName2.getClean();
                }
                List invocations = BuildConfigManager.getInvocations((IProject)rfProject.getProject());
                if (invocations == null) return null;
                if (invocations.isEmpty()) {
                    return null;
                }
                Invocation lastInvocation = (Invocation)invocations.get(invocations.size() - 1);
                String defaultKeywordSet = BuildConfigManager.getDefaultKeywordSet((Invocation)lastInvocation);
                Map extensionKeywordsetMap = BuildConfigManager.getExtensionKeywordSetMap((Invocation)lastInvocation);
                IBuildConfigParserConstants.ToolCompat toolCompat = lastInvocation.getToolCompat();
                IHidObject patternHidObject = RfMixedLangManager.getInstance().parsePattern(selectedText, defaultKeywordSet, extensionKeywordsetMap, toolCompat, false, (IRfSingleLangProject)rfProject);
                if (patternHidObject instanceof RfHidAccessArgs) {
                    patternHidObject = ((RfHidAccessArgs)patternHidObject).getParentHid();
                }
                RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)containerNamedElement, rfProject, 40);
                if (patternHidObject instanceof RfHid) {
                    RfHid hidToResolve = (RfHid)patternHidObject;
                    IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)containerNamedElement, null, (boolean)true, (ELManager)rfProject.getELManager());
                    resolver.resolveHidInContext((IHidObject)hidToResolve, guardian, false);
                }
                TypeName typeName3 = new TypeName();
                IRfNamedElement associatedType = ((RfAssociatedType)finalElement).getAssociatedType(RfTypesResolver.create(resolver));
                IRfNamedElement associatedTypeNoParams = ((RfAssociatedType)finalElement).getAssociatedTypeNoLastLevelParams(RfTypesResolver.create(resolver));
                String typeNameString = "integer";
                if (associatedTypeNoParams != null && associatedTypeNoParams.getEnclosingScope() != null) {
                    typeNameString = associatedType.getName();
                } else {
                    DataType fieldDataType = ((RfAssociatedType)finalElement).getDataType();
                    if (fieldDataType != null) {
                        typeNameString = fieldDataType.getTypeNameWithParamAssignments();
                    }
                }
                typeName3.setTypeName(typeNameString);
                typeName3.setUnpackedDim(((RfAssociatedType)finalElement).getUnpackedDimension());
                if (!VOID.equals(typeName3.getTypeName())) return typeName3.getClean();
                return null;
            }
            TypeName typeName4 = VlogQuickAssistUtil.computeOperatorTypeName(rfProject, parserPath, startOffset, endOffset, adjustedSelectedTextLength, containerNamedElement, compoundOperators);
            if (typeName4 == null) {
                QuickAssistHidImplicitTypeVisitor implicitHidVisitor = new QuickAssistHidImplicitTypeVisitor(startOffset, endOffset, rfProject, selectedText, extractVariable);
                containerNamedElement.visitHidObject(null, implicitHidVisitor);
                typeName4 = implicitHidVisitor.getTypeName();
            }
            if (typeName4 == null) {
                return null;
            }
            if (extractVariable) {
                typeName = typeName4.getClean();
                return typeName;
            }
            typeName = typeName4;
            return typeName;
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private static TypeName computeOperatorTypeName(RfProject rfProject, ParserPath parserPath, int startOffset, int endOffset, int adjustedSelectedTextLength, RfNamedElement containerNamedElement, Set<RfHidOperator> compoundOperators) {
        TypeName typeName = null;
        if (compoundOperators == null) {
            return typeName;
        }
        for (RfHidOperator operator : compoundOperators) {
            int occurrenceOffset;
            HidOperatorOccurrence hidOccurrence = operator.getOccurrence();
            if (hidOccurrence == null || (occurrenceOffset = hidOccurrence.getOffset()) < startOffset || occurrenceOffset >= endOffset) continue;
            TypeName type = VlogQuickFixUtil.getInstance().computeTypeNameAndDimFromHidObject(RfTypesResolver.create((IRfScopeElement)containerNamedElement.getEnclosingScope(), rfProject, 14), (IHidObject)operator, containerNamedElement.getEnclosingScope(), parserPath, rfProject);
            if (VlogQuickAssistUtil.isEntireOperatorSelected(operator, startOffset, endOffset, adjustedSelectedTextLength)) {
                if (type != null && !operator.isAssignment()) {
                    typeName = new TypeName(type.getTypeName(), type.getUnpackedDim());
                }
                return typeName;
            }
            if (!VlogQuickAssistUtil.isPartialOperatorSelected(operator, startOffset, endOffset, adjustedSelectedTextLength)) continue;
            if (type != null && !operator.isAssignment()) {
                typeName = new TypeName(type.getTypeName(), type.getUnpackedDim());
            }
            return typeName;
        }
        return typeName;
    }

    private static boolean associatedTypeHasNoParams(RfNamedElement containerNamedElement, IRfNamedElement associatedTypeNoParams) {
        return associatedTypeNoParams.getEnclosingScope().equals(containerNamedElement.getEnclosingScope(associatedTypeNoParams.getEnclosingScope().getClass()));
    }

    private static boolean isValidPartialOperatorSelected(HidOperator operator, int lhOperatorOffset, int selectedTextStartOffset, int selectedTextEndOffset, int adjustedSelectedTextLength) {
        return lhOperatorOffset < selectedTextStartOffset && operator.getCloseBoundary() <= selectedTextEndOffset && operator.getCloseBoundary() - lhOperatorOffset + 1 >= adjustedSelectedTextLength;
    }

    private static boolean isEntireOperatorSelected(HidOperator operator, int selectedTextStartOffset, int selectedTextEndOffset, int adjustedSelectedTextLength) {
        return operator.getOpenBoundary() >= selectedTextStartOffset && operator.getCloseBoundary() <= selectedTextEndOffset && operator.getCloseBoundary() - operator.getOpenBoundary() >= adjustedSelectedTextLength;
    }

    private static boolean isPartialOperatorSelected(HidOperator operator, int selectedTextStartOffset, int selectedTextEndOffset, int adjustedSelectedTextLength) {
        IHidObject lhValue = operator.getLHValue();
        while (lhValue instanceof RfHidOperator) {
            HidOperatorOccurrence lhOperatorOccurrence = ((RfHidOperator)lhValue).getOccurrence();
            if (lhOperatorOccurrence == null) break;
            int lhOperatorOffset = lhOperatorOccurrence.getOffset();
            if (VlogQuickAssistUtil.isValidPartialOperatorSelected(operator, lhOperatorOffset, selectedTextStartOffset, selectedTextEndOffset, adjustedSelectedTextLength)) {
                return true;
            }
            lhValue = ((RfHidOperator)lhValue).getLHValue();
        }
        return false;
    }

    public static String computeSelectedTextWithoutOptionalBoundaries(String selectedText) {
        String trimmedSelectedText = selectedText.trim();
        if (!trimmedSelectedText.startsWith("(") || !trimmedSelectedText.endsWith(")")) {
            return trimmedSelectedText;
        }
        List pairs = DVTDocumentUtils.findParenthesesPairs((String)trimmedSelectedText);
        Collections.reverse(pairs);
        int index = 0;
        while (index < pairs.size()) {
            int openParenthesisIndex = ((int[])pairs.get(index))[0];
            int closeParenthesisIndex = ((int[])pairs.get(index))[1];
            if (openParenthesisIndex != index || closeParenthesisIndex != trimmedSelectedText.length() - index - 1) break;
            ++index;
        }
        return trimmedSelectedText.substring(index, trimmedSelectedText.length() - index);
    }

    private static int computeAdjustedSelectedTextLength(String selectedText) {
        String trimmedSelectedText = selectedText.trim();
        int firstNWSDifferentFromParenthesisIndex = trimmedSelectedText.startsWith("(") ? DVTStringUtil.getFirstNWSDifferentFromCharIndex((String)trimmedSelectedText, (char)'(') : 0;
        int lastNWSDifferentFromParenthesisIndex = trimmedSelectedText.endsWith(")") ? DVTStringUtil.getLastNWSDifferentFromCharReverseIndex((String)trimmedSelectedText, (char)')') : 0;
        return trimmedSelectedText.length() - firstNWSDifferentFromParenthesisIndex - lastNWSDifferentFromParenthesisIndex;
    }

    public static boolean computeElementAtCursorScopeIsMethodCall(MethodObjectVisitor visitor, IRfNamedElement scopeAtCursor) {
        if (scopeAtCursor == null) {
            return false;
        }
        scopeAtCursor.visitHidObject(null, (IHidVisitor)visitor);
        if (visitor.getFound() == null) {
            return false;
        }
        IRfNamedElement methodNamedElement = visitor.getMethodNamedElement();
        return methodNamedElement instanceof RfFunction && (!(methodNamedElement instanceof RfPredefinedFunction) || !methodNamedElement.getName().startsWith("$"));
    }

    public static enum OperatorPrecedence {
        DEF_PRECEDENCE,
        CONCATENATION,
        ARITHMETIC_ASSIGNMENT,
        DASH_IMPLICATION_LOGIC_EQUIV,
        CONDITIONAL_TERNARY,
        LOGICAL_OR,
        LOGICAL_AND,
        BINARY_OR,
        BINARY_XOR_XNOR,
        BINARY_AND,
        EQUALITY,
        RELATIONAL_INSIDE_DISTR,
        SHIFT,
        PLUS_MINUS,
        STAR_DIV_MODULO,
        POW_DOUBLE_STAR,
        UNARY;


        public static int getOperatorPrecedence(RfHidOperator operator) {
            if (operator.getOperatorKind() == IHidOperatorConstants.OperatorKind.UNARY_OPERATOR) {
                return UNARY.ordinal();
            }
            if (operator.isPowDoubleStar()) {
                return POW_DOUBLE_STAR.ordinal();
            }
            if (operator.isStar() || operator.isDiv() || operator.isModulo()) {
                return STAR_DIV_MODULO.ordinal();
            }
            if (operator.isPlus() || operator.isMinus()) {
                return PLUS_MINUS.ordinal();
            }
            if (operator.isArithmeticShift() || operator.isLogicalShift()) {
                return SHIFT.ordinal();
            }
            if (operator.isRelational() || operator.isInside() || operator.isDistribution()) {
                return RELATIONAL_INSIDE_DISTR.ordinal();
            }
            if (operator.isEqualityOrInequality()) {
                return EQUALITY.ordinal();
            }
            if (operator.isBinaryBAnd()) {
                return BINARY_AND.ordinal();
            }
            if (operator.isBinaryBXor() || operator.isBinaryXNor()) {
                return BINARY_XOR_XNOR.ordinal();
            }
            if (operator.isBinaryOr()) {
                return BINARY_OR.ordinal();
            }
            if (operator.isLogicalAnd()) {
                return LOGICAL_AND.ordinal();
            }
            if (operator.isLogicalOr()) {
                return LOGICAL_OR.ordinal();
            }
            if (operator.isConditionalTernary()) {
                return CONDITIONAL_TERNARY.ordinal();
            }
            if (operator.isDashImplication() || operator.isLogicalEquiv()) {
                return DASH_IMPLICATION_LOGIC_EQUIV.ordinal();
            }
            if (operator.isArithmeticAssignment()) {
                return ARITHMETIC_ASSIGNMENT.ordinal();
            }
            if (operator.isVLOGConcatenation(true)) {
                return CONCATENATION.ordinal();
            }
            return DEF_PRECEDENCE.ordinal();
        }
    }
}

