/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ui.IMarkerResolution;
import ro.amiq.dvt.ai.AIHostContributorManager;
import ro.amiq.dvt.ai.IAIHostContributor;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.quickfix.ProblemsViewQuickFixGenerator;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAIAutofixManager;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixQuickFixProposalsUtils;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;

public class VlogProblemsViewQuickFixGenerator
extends ProblemsViewQuickFixGenerator {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        if (!marker.exists()) {
            return new IMarkerResolution[0];
        }
        try {
            if (marker.getType().equals("ro.amiq.vlogdt.LintingErrorMarker")) {
                IResource markerResource;
                ArrayList<ICompletionProposal> allVerissimoProposals = new ArrayList<ICompletionProposal>();
                ICompletionProposal lintingAutofixProposalFromMarker = VerissimoAutofixQuickFixProposalsUtils.INSTANCE.getLintingAutofixProposalFromMarker(marker);
                if (lintingAutofixProposalFromMarker != null) {
                    allVerissimoProposals.add(lintingAutofixProposalFromMarker);
                }
                if ((markerResource = marker.getResource()) == null) {
                    return new IMarkerResolution[0];
                }
                IProject iProject = markerResource.getProject();
                if (iProject == null) {
                    return new IMarkerResolution[0];
                }
                IAIHostContributor aiHostContributor = AIHostContributorManager.INSTANCE.getAiHostContributor();
                if (aiHostContributor != null && aiHostContributor.isAIModelsAvailable() && !aiHostContributor.isFileProtected(VerissimoAutofixQuickFixProposalsUtils.INSTANCE.getFileNameFromVerissimoMarker(marker), iProject)) {
                    List<ICompletionProposal> aiExplainProposalsFromMarker;
                    List<ICompletionProposal> aiAutofixProposalsFromMarker = VerissimoAIAutofixManager.getInstance().getAIAutofixProposalFromMarker(marker, true);
                    if (aiAutofixProposalsFromMarker != null) {
                        allVerissimoProposals.addAll(aiAutofixProposalsFromMarker);
                    }
                    if ((aiExplainProposalsFromMarker = VerissimoAIAutofixManager.getInstance().getAIExplainProposalFromMarker(marker)) != null) {
                        allVerissimoProposals.addAll(aiExplainProposalsFromMarker);
                    }
                }
                return allVerissimoProposals.toArray(new IMarkerResolution[0]);
            }
            return super.getResolutions(marker);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return new IMarkerResolution[0];
        }
    }

    public List<ICompletionProposal> getProposalsByKind(int quickFixKind, boolean isHierarchical, IMarker marker, ITextViewer viewer, IRfScopeElement scope, int offset, Position position, String elementName) {
        return VlogQuickFixUtil.getInstance().getProposalsByKind(quickFixKind, isHierarchical, marker, viewer, scope, offset, position, elementName, new ArrayList<ICompletionProposal>(), true, (IProgressMonitor)new NullProgressMonitor());
    }

    public IRfScopeElement getRfScope(IResource file, int offset) {
        IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        RfFileDef rfFileDef = rfProject.getFile(file);
        if (rfFileDef == null) {
            return null;
        }
        return rfFileDef.getScope(-1, offset);
    }
}

