/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.ITextViewer;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.IRfHidOperatorLayer;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;

public abstract class AbstractVariableQuickFix
extends BaseAbstractQuickFix {
    protected AbstractVariableQuickFix(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public String guessVariableDirection(RfNamedElement container, String elementName) {
        List<IHidOperator> operators = container.getHidOperators(DVTQuickFixUtil.ASSIGN_EXPRESSIONS, false);
        if (operators == null) {
            return "IN";
        }
        String direction = null;
        for (IHidOperator operator : operators) {
            Set lhHids = operator.getLHHids(DVTQuickFixUtil.FLATTENING_OPTIONS);
            Set rhHids = operator.getRHHids(DVTQuickFixUtil.FLATTENING_OPTIONS);
            boolean isAlias = operator.hasOccurrence(HidOperatorQualifier.IS_ALIAS);
            for (IHid lhHid : lhHids) {
                if (!lhHid.getName().equals(elementName)) continue;
                if (isAlias) {
                    return "INOUT";
                }
                if (operator instanceof IRfHidOperatorLayer && ((IRfHidOperatorLayer)operator).isAssignment()) {
                    direction = "IN".equals(direction) ? "INOUT" : "OUT";
                } else {
                    String string = direction = "OUT".equals(direction) ? "INOUT" : "IN";
                }
                if (!"INOUT".equals(direction)) continue;
                return direction;
            }
            for (IHid rhHid : rhHids) {
                if (!rhHid.getName().equals(elementName)) continue;
                if (isAlias) {
                    return "INOUT";
                }
                String string = direction = "OUT".equals(direction) ? "INOUT" : "IN";
                if (!"INOUT".equals(direction)) continue;
                return direction;
            }
        }
        if (direction == null) {
            return "IN";
        }
        return direction;
    }

    public DeclareVariableOffsetInfo guessOffsetToDeclareVariable(RfDefElement containerDef, String elementName) {
        RfNamedElement container = containerDef.getNamedElement();
        container = VlogQuickFixUtil.getInstance().getAlwaysBlockOrForkJoinOrFunction(container);
        OffsetOperatorVisitor visitor = new OffsetOperatorVisitor(elementName);
        container.visitHidObject(null, visitor);
        return new DeclareVariableOffsetInfo(visitor.getOffsetPair(), visitor.hasOccuranceInLoop());
    }

    static class DeclareVariableOffsetInfo {
        int[] offsetPair;
        boolean isInsideLoop;

        public DeclareVariableOffsetInfo(int[] offsetPair, boolean isInsideLoop) {
            this.offsetPair = offsetPair;
            this.isInsideLoop = isInsideLoop;
        }

        public int[] getOffsetPair() {
            return this.offsetPair;
        }

        public boolean isInsideLoop() {
            return this.isInsideLoop;
        }
    }

    public class OffsetOperatorVisitor
    implements IHidVisitor<HidOperator> {
        private String elementName;
        private int offsetMin;
        private int offsetMax;
        private boolean hasOccuranceInLoop;

        public OffsetOperatorVisitor(String elementName) {
            this.offsetMin = AbstractVariableQuickFix.this.offset;
            this.offsetMax = AbstractVariableQuickFix.this.offset;
            this.elementName = elementName;
        }

        public boolean hasOccuranceInLoop() {
            return this.hasOccuranceInLoop;
        }

        public void setHolder(IHidHolder holder) {
        }

        public void setParserPath(ParserPath parserPath) {
        }

        public boolean visit(HidOperator operator) {
            Set lhHids = operator.getLHHids(DVTQuickFixUtil.FLATTENING_OPTIONS);
            Set rhHids = operator.getRHHids(DVTQuickFixUtil.FLATTENING_OPTIONS);
            for (IHid lhHid : lhHids) {
                if (!(lhHid instanceof RfHid) || !lhHid.getName().equals(this.elementName) || lhHid.getElement() != null) continue;
                this.offsetMin = this.computeMinOffset(lhHid.getOccurrence(), this.offsetMin);
                this.offsetMax = this.computeMaxOffset(lhHid.getOccurrence(), this.offsetMax);
                if (!operator.hasOccurrence(HidQualifierCache.IS_LOOP_EXPRESSION_QUALIFIER)) continue;
                this.hasOccuranceInLoop = true;
            }
            for (IHid rhHid : rhHids) {
                if (!(rhHid instanceof RfHid) || !rhHid.getName().equals(this.elementName) || rhHid.getElement() != null) continue;
                this.offsetMin = this.computeMinOffset(rhHid.getOccurrence(), this.offsetMin);
                this.offsetMax = this.computeMaxOffset(rhHid.getOccurrence(), this.offsetMax);
                if (!operator.hasOccurrence(HidQualifierCache.IS_LOOP_EXPRESSION_QUALIFIER)) continue;
                this.hasOccuranceInLoop = true;
            }
            return true;
        }

        private int computeMinOffset(HidOccurrence occurrence, int oldOffset) {
            if (occurrence == null) {
                return oldOffset;
            }
            int result = oldOffset;
            if (occurrence.getVirtualOffset() > 0 && occurrence.getOffsetOutsideMacro() < result) {
                result = occurrence.getOffsetOutsideMacro();
            }
            if (occurrence.getVirtualOffset() < 0 && occurrence.getOffset() < result) {
                result = occurrence.getOffset();
            }
            return result;
        }

        private int computeMaxOffset(HidOccurrence occurrence, int oldOffset) {
            if (occurrence == null) {
                return oldOffset;
            }
            int result = oldOffset;
            if (occurrence.getVirtualOffset() > 0 && occurrence.getOffsetOutsideMacro() > result) {
                result = occurrence.getOffsetOutsideMacro();
            }
            if (occurrence.getVirtualOffset() < 0 && occurrence.getOffset() > result) {
                result = occurrence.getOffset();
            }
            return result;
        }

        public Class<HidOperator> getType() {
            return HidOperator.class;
        }

        public int[] getOffsetPair() {
            return new int[]{this.offsetMin, this.offsetMax};
        }
    }
}

