/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.refactor.connect.RefactorInputWrapper;
import ro.amiq.dvt.ui.refactor.connect.TextChange;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTExitPolicyConfig;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.BaseAddQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.TypeName;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.TypeOperatorVisitor;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;
import ro.amiq.vlogdt.ui.refactor.addparameter.VlogRefactorAddParameterAlgorithm;
import ro.amiq.vlogdt.ui.refactor.addparameter.VlogRefactorAddParameterProcessor;
import ro.amiq.vlogdt.ui.refactor.addport.VlogRefactorAddWizardInput;

public abstract class AddParameterQuickFixCommon
extends BaseAddQuickFix {
    private static final String PARAMETER_TYPE = "parameter";
    private static final String PARAMETER_TYPE_EDIT_CATEGORY = "parameter_type";
    protected static final String PARAMETER_DEFAULT_VALUE = "DEFAULT_VALUE";
    private static final String PARAMETER_DEFAULT_VALUE_EDIT_CATEGORY = "parameter_default_value";

    protected AddParameterQuickFixCommon(IMarker marker, ITextViewer viewer, IRfInstanceElement instance, IRfDesignElement instanceDesignElement, IRfDesignElement triggerModuleScope) {
        super(marker, viewer);
        this.instance = instance;
        this.triggerModule = triggerModuleScope;
        this.instanceModule = instanceDesignElement;
        this.linkedProposalModel = new LinkedModeModel();
    }

    @Override
    protected DVTTextFileChange createChange() throws BadLocationException, BadPartitioningException {
        this.textFileChange = new VlogTextFileChange(this.targetFile.getProjectRelativePath().toOSString(), this.targetFile);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        List<TextChange> targetFileChanges = this.computeTargetFileTextChanges(this.wizardInput.getNewElementName(), PARAMETER_TYPE);
        if (targetFileChanges == null) {
            return null;
        }
        for (TextChange textChg : targetFileChanges) {
            InsertEdit parameterListInsertEdit = new InsertEdit(textChg.offset, textChg.text);
            this.textFileChange.addEdit((TextEdit)parameterListInsertEdit, this.computeRegionsByCategory(textChg.text, this.wizardInput.getNewElementName(), this.wizardInput.getType()));
        }
        return this.textFileChange;
    }

    protected String computeParameterType(IRfInstanceElement instance) {
        IRfDefElement instanceDeclaration = instance.getDeclaration();
        if (instanceDeclaration == null) {
            return "";
        }
        if (!(instanceDeclaration instanceof RfDefElement)) {
            return "";
        }
        DataType instanceDataType = ((RfDefElement)instanceDeclaration).getDataType((IRfNamedElement)instance);
        if (instanceDataType == null) {
            return "";
        }
        RfHidHolder paramValuesHolder = instanceDataType.getParamValuesHolder();
        if (paramValuesHolder == null) {
            return "";
        }
        RfProject rfProject = (RfProject)instance.getRfProject();
        if (rfProject == null) {
            return "";
        }
        TypeOperatorVisitor typeVisitor = new TypeOperatorVisitor(this.elementName, true, true, rfProject, (IRfNamedElement)instance);
        paramValuesHolder.visitHidObject(null, typeVisitor);
        TypeName type = typeVisitor.getTypeName();
        return type.getTypeName();
    }

    private List<TextChange> computeTargetFileTextChanges(String parameterName, String parameterType) {
        ArrayList<TextChange> targetFileChanges = new ArrayList<TextChange>();
        VlogRefactorAddWizardInput parameterInfo = new VlogRefactorAddWizardInput(this.instanceModule, parameterName, "", parameterType, "", PARAMETER_DEFAULT_VALUE);
        VlogRefactorAddParameterAlgorithm fAlg = new VlogRefactorAddParameterAlgorithm(parameterInfo, this.triggerEditor.getProject());
        Set<RefactorInputWrapper> treeChgs = fAlg.computeChangeWrappers();
        if (treeChgs == null) {
            return null;
        }
        Set<TextChange> textChgs = fAlg.computeChangesFromWrappers(treeChgs, (IProgressMonitor)new NullProgressMonitor());
        for (TextChange textChg : textChgs) {
            IRfDefElement moduleDeclaration;
            IFile currentFile = textChg.file;
            if (currentFile == null || !currentFile.equals((Object)this.targetFile) || (moduleDeclaration = this.instanceModule.getDeclaration()) == null || textChg.offset <= moduleDeclaration.getStartOffset() || textChg.offset >= moduleDeclaration.getEndOffset()) continue;
            targetFileChanges.add(textChg);
        }
        return targetFileChanges;
    }

    private Map<String, List<IRegion>> computeRegionsByCategory(String text, String parameterName, String parameterType) {
        List parameterDefaultValue;
        LinkedHashMap<String, List<IRegion>> regionsByCategory = new LinkedHashMap<String, List<IRegion>>();
        List parameterDirectionRegions = DVTQuickFixUtil.computeLinkedRegionsForWord((String)text, (String)PARAMETER_TYPE, (int)0);
        if (parameterDirectionRegions != null && !parameterDirectionRegions.isEmpty()) {
            regionsByCategory.put(PARAMETER_TYPE_EDIT_CATEGORY, parameterDirectionRegions);
        }
        if ((parameterDefaultValue = DVTQuickFixUtil.computeLinkedRegionsForWord((String)text, (String)PARAMETER_DEFAULT_VALUE, (int)0)) != null && !parameterDefaultValue.isEmpty()) {
            regionsByCategory.put(PARAMETER_DEFAULT_VALUE_EDIT_CATEGORY, parameterDefaultValue);
        }
        return regionsByCategory;
    }

    public String getDisplayString() {
        return "Add parameter '" + this.elementName + "' to '" + this.instanceModule.getName() + "'";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PARAM);
    }

    private String getCategory() {
        return "QuickFixCategory_" + ((Object)((Object)this)).toString();
    }

    @Override
    public void computeElementInfo() {
        String parameterName = this.elementName;
        String parameterType = PARAMETER_TYPE;
        this.wizardInput = new VlogRefactorAddWizardInput(this.instanceModule, parameterName, "", parameterType, "", "");
    }

    @Override
    public void addLinkedPositions() throws Exception {
        Collection parameterDefaultValueAbsoluteRegions;
        this.linkedPositionProvider = new DVTLinkedPositionProvider(this.triggerEditor, this.targetEditor, this.linkedProposalModel, this.getCategory(), true, true, this.textFileChange);
        Collection parameterTypeAbsoluteRegions = this.textFileChange.getAbsoluteRegionsByCategory(PARAMETER_TYPE_EDIT_CATEGORY);
        if (parameterTypeAbsoluteRegions != null && !parameterTypeAbsoluteRegions.isEmpty()) {
            IRegion region = (IRegion)parameterTypeAbsoluteRegions.iterator().next();
            this.linkedPositionProvider.addMultipleLinkedPosition(parameterTypeAbsoluteRegions, this.targetDocument, region.getOffset());
        }
        if ((parameterDefaultValueAbsoluteRegions = this.textFileChange.getAbsoluteRegionsByCategory(PARAMETER_DEFAULT_VALUE_EDIT_CATEGORY)) != null && !parameterDefaultValueAbsoluteRegions.isEmpty()) {
            IRegion region = (IRegion)parameterDefaultValueAbsoluteRegions.iterator().next();
            this.linkedPositionProvider.addMultipleLinkedPosition(parameterDefaultValueAbsoluteRegions, this.targetDocument, region.getOffset());
        }
        DVTExitPolicyConfig config = new DVTExitPolicyConfig(true, this.triggerEditor.getCursor(), "__vlog_partitioning");
        this.linkedPositionProvider.enterLinkedMode(this.targetDocument, config);
        if (this.shouldDisconnect) {
            this.bufferManager.disconnect(this.path, this.locationKind, null);
        }
    }

    protected VlogRefactorAddParameterProcessor computeRefactoringProcessor() {
        ArrayList<IRfInstanceElement> excludedInstances = new ArrayList<IRfInstanceElement>();
        excludedInstances.add(this.instance);
        VlogRefactorAddParameterAlgorithm alg = new VlogRefactorAddParameterAlgorithm(this.wizardInput, this.triggerEditor.getProject());
        alg.setExcludedInstances(excludedInstances);
        VlogRefactorAddParameterProcessor processor = new VlogRefactorAddParameterProcessor(alg);
        return processor;
    }

    @Override
    protected void updateOpenWizard(boolean hasMultipleInstances) {
        this.openWizard = hasMultipleInstances;
    }
}

