/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.refactor.connect.RefactorInputWrapper;
import ro.amiq.dvt.ui.refactor.connect.TextChange;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTExitPolicyConfig;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.BaseAddQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.TypeName;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;
import ro.amiq.vlogdt.ui.refactor.addport.VlogRefactorAddPortAlgorithm;
import ro.amiq.vlogdt.ui.refactor.addport.VlogRefactorAddPortProcessor;
import ro.amiq.vlogdt.ui.refactor.addport.VlogRefactorAddWizardInput;

public abstract class AddPortQuickFixCommon
extends BaseAddQuickFix {
    private static final String PORT_DIRECTION_EDIT_CATEGORY = "port_direction";
    private static final String PORT_TYPE_EDIT_CATEGORY = "port_type";
    private Set<IHid> undeclaredPortConnections;
    protected Collection<? extends IRfPortElement> triggerModulePorts;

    protected AddPortQuickFixCommon(IMarker marker, ITextViewer viewer, IRfInstanceElement instance, Set<IHid> undeclaredPortConnections, IRfDesignElement instanceDesignElement, IRfDesignElement triggerModuleScope) {
        super(marker, viewer);
        this.instance = instance;
        this.undeclaredPortConnections = undeclaredPortConnections;
        this.instanceModule = instanceDesignElement;
        this.triggerModule = triggerModuleScope;
        this.linkedProposalModel = new LinkedModeModel();
    }

    @Override
    protected DVTTextFileChange createChange() {
        this.textFileChange = new VlogTextFileChange(this.targetFile.getProjectRelativePath().toOSString(), this.targetFile);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        List<TextChange> targetFileChanges = this.computeTargetFileTextChanges(this.wizardInput.getNewElementName(), this.wizardInput.getDirection());
        if (targetFileChanges == null) {
            return null;
        }
        for (TextChange textChg : targetFileChanges) {
            InsertEdit portListInsertEdit = new InsertEdit(textChg.offset, textChg.text);
            this.textFileChange.addEdit((TextEdit)portListInsertEdit, this.computeRegionsByCategory(textChg.text, this.wizardInput.getNewElementName(), this.wizardInput.getType(), this.wizardInput.getDirection()));
        }
        return this.textFileChange;
    }

    private List<TextChange> computeTargetFileTextChanges(String portName, String portDirection) {
        ArrayList<TextChange> targetFileChanges = new ArrayList<TextChange>();
        VlogRefactorAddPortAlgorithm addPortAlgorithm = new VlogRefactorAddPortAlgorithm(this.wizardInput, this.triggerEditor.getProject());
        Set<RefactorInputWrapper> treeChgs = addPortAlgorithm.computeChangeWrappers();
        if (treeChgs == null) {
            return null;
        }
        Set<TextChange> textChgs = addPortAlgorithm.computeChangesFromWrappers(treeChgs, (IProgressMonitor)new NullProgressMonitor());
        for (TextChange textChg : textChgs) {
            IRfDefElement moduleDeclaration;
            IFile currentFile = textChg.file;
            if (currentFile == null || !currentFile.equals((Object)this.targetFile) || (moduleDeclaration = this.instanceModule.getDeclaration()) == null || textChg.offset <= moduleDeclaration.getStartOffset() || textChg.offset >= moduleDeclaration.getEndOffset()) continue;
            targetFileChanges.add(textChg);
        }
        return targetFileChanges;
    }

    protected String computePortDirection() {
        String direction = "input";
        for (IHid portConnection : this.undeclaredPortConnections) {
            IRfNamedElement portNamedElement = portConnection.getElement();
            if (!(portNamedElement instanceof IRfPortElement) || !this.triggerModulePorts.contains(portNamedElement)) continue;
            direction = ((IRfPortElement)portNamedElement).getDirectionString();
            if (direction != null && !direction.isEmpty()) break;
            direction = "input";
            break;
        }
        return direction;
    }

    protected String computePortWidth() {
        if (!(this.triggerModule instanceof RfNamedElement)) {
            return "";
        }
        TypeName type = VlogQuickFixUtil.getInstance().getVariableType((RfNamedElement)this.triggerModule, this.elementName, this.position.offset, "", true, true);
        if (type == null) {
            return "";
        }
        if (type.getPackedDim() == null) {
            return "";
        }
        return type.getPackedDim();
    }

    private Map<String, List<IRegion>> computeRegionsByCategory(String text, String portName, String portType, String portDirection) {
        List portTypeRegions;
        LinkedHashMap<String, List<IRegion>> regionsByCategory = new LinkedHashMap<String, List<IRegion>>();
        List portDirectionRegions = DVTQuickFixUtil.computeLinkedRegionsForWord((String)text, (String)portDirection, (int)0);
        if (portDirectionRegions != null && !portDirectionRegions.isEmpty()) {
            regionsByCategory.put(PORT_DIRECTION_EDIT_CATEGORY, portDirectionRegions);
        }
        if ((portTypeRegions = DVTQuickFixUtil.computeLinkedRegionsForWord((String)text, (String)portType, (int)0)) != null && !portTypeRegions.isEmpty()) {
            regionsByCategory.put(PORT_TYPE_EDIT_CATEGORY, portTypeRegions);
        }
        return regionsByCategory;
    }

    @Override
    public void addLinkedPositions() throws Exception {
        Collection portTypeAbsoluteRegions;
        this.linkedPositionProvider = new DVTLinkedPositionProvider(this.triggerEditor, this.targetEditor, this.linkedProposalModel, this.getCategory(), true, true, this.textFileChange);
        Collection portDirAbsoluteRegions = this.textFileChange.getAbsoluteRegionsByCategory(PORT_DIRECTION_EDIT_CATEGORY);
        if (portDirAbsoluteRegions != null && !portDirAbsoluteRegions.isEmpty()) {
            IRegion region = (IRegion)portDirAbsoluteRegions.iterator().next();
            this.linkedPositionProvider.addMultipleLinkedPosition(portDirAbsoluteRegions, this.targetDocument, region.getOffset());
        }
        if ((portTypeAbsoluteRegions = this.textFileChange.getAbsoluteRegionsByCategory(PORT_TYPE_EDIT_CATEGORY)) != null && !portTypeAbsoluteRegions.isEmpty()) {
            IRegion region = (IRegion)portTypeAbsoluteRegions.iterator().next();
            this.linkedPositionProvider.addMultipleLinkedPosition(portTypeAbsoluteRegions, this.targetDocument, region.getOffset());
        }
        DVTExitPolicyConfig config = new DVTExitPolicyConfig(true, this.triggerEditor.getCursor(), "__vlog_partitioning");
        this.linkedPositionProvider.enterLinkedMode(this.targetDocument, config);
        if (this.shouldDisconnect) {
            this.bufferManager.disconnect(this.path, this.locationKind, null);
        }
    }

    @Override
    public void computeElementInfo() {
        String portName = this.elementName;
        String portDirection = "input";
        this.triggerModulePorts = this.triggerModule.getLocalPorts();
        if (this.triggerModulePorts != null && !this.triggerModulePorts.isEmpty()) {
            portDirection = this.computePortDirection();
        }
        String portWidth = this.computePortWidth();
        this.wizardInput = new VlogRefactorAddWizardInput(this.instanceModule, portName, portDirection, "wire", portWidth, "");
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_INOUT_PORT);
    }

    public String getDisplayString() {
        return "Add port '" + this.elementName + "' to '" + this.instanceModule.getName() + "'";
    }

    private String getCategory() {
        return "QuickFixCategory_" + ((Object)((Object)this)).toString();
    }

    protected VlogRefactorAddPortProcessor computeRefactoringPorcessor() {
        ArrayList<IRfInstanceElement> excludedInstances = new ArrayList<IRfInstanceElement>();
        excludedInstances.add(this.instance);
        VlogRefactorAddPortAlgorithm alg = new VlogRefactorAddPortAlgorithm(this.wizardInput, this.triggerEditor.getProject());
        alg.setExcludedInstances(excludedInstances);
        VlogRefactorAddPortProcessor processor = new VlogRefactorAddPortProcessor(alg);
        return processor;
    }

    @Override
    protected void updateOpenWizard(boolean hasMultipleInstances) {
        this.openWizard = hasMultipleInstances;
    }
}

