/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;

public class AddVirtualToInterfaceReferenceQuickFix
extends BaseAbstractQuickFix {
    private static final String SPACE = " ";
    private static final String VIRTUAL = "virtual";

    public AddVirtualToInterfaceReferenceQuickFix(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        if (document == null) {
            return;
        }
        if (this.enclosingScope == null || this.position == null || this.position.offset < 0) {
            return;
        }
        RfFileDef fTargetFile = (RfFileDef)this.enclosingScope.getDefFile();
        this.textFileChange = new VlogTextFileChange(fTargetFile.getName(), (IFile)fTargetFile.getFileAdapter());
        this.textFileChange.setEdit((TextEdit)new InsertEdit(this.position.offset, "virtual "));
    }

    public IFile[] getAffectedFiles() throws Exception {
        if (this.enclosingScope == null) {
            return null;
        }
        IResource elementResource = this.enclosingScope.getFileAdapter();
        if (elementResource == null || !(elementResource instanceof IFile)) {
            return null;
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)elementResource);
        return affectedFiles.toArray(new IFile[1]);
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)this.targetEditor, this.targetDocument, this.getDisplayString(), (Change)this.textFileChange);
    }

    public String getDisplayString() {
        return "Add 'virtual' qualifier";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
    }
}

