/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.TextFileBufferInfo;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.vlogdt.ui.refactor.addport.VlogRefactorAddWizardInput;

public abstract class BaseAddQuickFix
extends BaseAbstractQuickFix {
    protected IRfDesignElement triggerModule;
    protected IRfDesignElement instanceModule;
    protected IRfInstanceElement instance;
    protected ITextFileBufferManager bufferManager;
    protected boolean shouldDisconnect;
    protected IFile targetFile;
    protected boolean openWizard;
    protected VlogRefactorAddWizardInput wizardInput;
    protected IPath path;
    protected LocationKind locationKind;

    protected BaseAddQuickFix(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    @Override
    public void preApplyQuickFix(IDocument document) throws Exception {
        IRfSingleLangProject rfProject = this.instance.getRfProject();
        if (rfProject != null) {
            rfProject = RfManager.getInstance().getRfProject(rfProject.getProject());
        }
        if (rfProject instanceof RfProject) {
            List<IRfInstanceElement> allInstancesOfDesignElement = ((RfProject)rfProject).collectInstances(this.instanceModule);
            this.updateOpenWizard(allInstancesOfDesignElement.size() > 1);
        }
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.computeElementInfo();
        if (!this.openWizard) {
            this.computeTargetElements();
            this.textFileChange = this.createChange();
            if (this.textFileChange == null) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
        }
    }

    private void computeTargetElements() throws CoreException {
        IResource instanceDesignElementFileAdapter = this.instanceModule.getFileAdapter();
        IResource instanceFileAdapter = this.instance.getFileAdapter();
        if (instanceDesignElementFileAdapter == null || instanceFileAdapter == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        this.targetFile = (IFile)instanceDesignElementFileAdapter;
        if (instanceDesignElementFileAdapter.equals((Object)instanceFileAdapter)) {
            return;
        }
        this.shouldDisconnect = false;
        this.bufferManager = FileBuffers.getTextFileBufferManager();
        TextFileBufferInfo textFileBufferInfo = DVTFileUtils.getInstance().getTextFileBufferInfo(this.targetFile);
        this.path = textFileBufferInfo.getPath();
        this.locationKind = textFileBufferInfo.getLocationKind();
        ITextFileBuffer textFileBuffer = this.bufferManager.getTextFileBuffer(this.path, this.locationKind);
        if (textFileBuffer == null) {
            this.shouldDisconnect = true;
            this.bufferManager.connect(this.path, this.locationKind, null);
            textFileBuffer = this.bufferManager.getTextFileBuffer(this.path, this.locationKind);
        }
        if (textFileBuffer != null) {
            this.targetDocument = textFileBuffer.getDocument();
        }
        if (this.targetDocument == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        this.targetEditor = this.getAndOpenEditor(instanceDesignElementFileAdapter);
    }

    public IFile[] getAffectedFiles() throws Exception {
        if (!this.openWizard) {
            Object[] affectedObjects = this.textFileChange.getAffectedObjects();
            IFile[] affectedFiles = new IFile[affectedObjects.length];
            int i = 0;
            while (i < affectedObjects.length) {
                Object affectedObject = affectedObjects[i];
                if (affectedObject instanceof IFile) {
                    affectedFiles[i] = (IFile)affectedObject;
                }
                ++i;
            }
            return affectedFiles;
        }
        return new IFile[0];
    }

    public abstract void computeElementInfo();

    protected abstract DVTTextFileChange createChange() throws BadLocationException, BadPartitioningException;

    public abstract void addLinkedPositions() throws Exception;

    protected abstract void updateOpenWizard(boolean var1);
}

