/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.TextFileBufferInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.AbstractVariableQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;

public abstract class BaseUpdateMethodSignatureQuickFixCommon
extends AbstractVariableQuickFix {
    protected MethodSignatureInformation sourceInfo;
    protected RfNamedElement sourceNamedElement;
    protected MethodSignatureInformation destinationInfo;
    protected RfNamedElement destinationNamedElement;
    protected ITextFileBufferManager bufferManager;
    protected boolean usedTextFileBufferForDestination;
    private List<String> methodKeywords;
    private List<String> lifetimeKeywords;
    protected boolean qualifyReturnType;

    protected BaseUpdateMethodSignatureQuickFixCommon(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    protected BaseUpdateMethodSignatureQuickFixCommon(IMarker marker, ITextViewer viewer, RfFunctionDef sourceFunc, RfFunctionDef destinationFunc) {
        super(marker, viewer);
        this.sourceInfo = new MethodSignatureInformation(sourceFunc);
        this.sourceNamedElement = sourceFunc.getNamedElement();
        this.destinationInfo = new MethodSignatureInformation(destinationFunc);
        this.destinationNamedElement = destinationFunc.getNamedElement();
        this.methodKeywords = new ArrayList<String>();
        this.methodKeywords.add("task");
        this.methodKeywords.add("function");
        this.lifetimeKeywords = new ArrayList<String>();
        this.lifetimeKeywords.add("static");
        this.lifetimeKeywords.add("automatic");
    }

    @Override
    public void preApplyQuickFix(IDocument document) throws Exception {
        boolean isExternPrototype;
        this.bufferManager = FileBuffers.getTextFileBufferManager();
        DVTEditor currentEditor = this.getOpenEditor(this.triggerResource);
        if (currentEditor == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IEditorInput editorInput = currentEditor.getEditorInput();
        if (editorInput == null || !(editorInput instanceof FileEditorInput)) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IFile currentEditorIFile = ((FileEditorInput)editorInput).getFile();
        if (currentEditorIFile == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        boolean isInCurrentEditor = currentEditorIFile.equals(this.sourceInfo.methodDefFile.getAdapter(IFile.class));
        boolean bl = isExternPrototype = this.sourceNamedElement.isExtern() && ((RfFunctionDef)this.sourceInfo.methodDef).isPrototype();
        if (!this.sourceInfo.initMethodSignatureElements(isExternPrototype, isInCurrentEditor)) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        isInCurrentEditor = currentEditorIFile.equals(this.destinationInfo.methodDefFile.getAdapter(IFile.class));
        isExternPrototype = this.destinationNamedElement.isExtern() && ((RfFunctionDef)this.destinationInfo.methodDef).isPrototype();
        boolean bl2 = this.usedTextFileBufferForDestination = isExternPrototype || !isInCurrentEditor;
        if (!this.destinationInfo.initMethodSignatureElements(isExternPrototype, isInCurrentEditor)) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.textFileChange = VlogQuickFixUtil.getInstance().getTextFileChange(this.destinationInfo.methodDef);
        if (!this.destinationInfo.returnType.isEmpty()) {
            DeleteEdit typeReplaceEdit = new DeleteEdit(this.destinationInfo.returnTypeOffset, this.destinationInfo.returnType.length());
            this.textFileChange.addEdit((TextEdit)typeReplaceEdit);
        }
        if (!this.sourceInfo.returnType.isEmpty()) {
            InsertEdit typeInsertEdit = new InsertEdit(this.destinationInfo.returnTypeOffset, String.valueOf(this.sourceInfo.returnType) + (this.destinationInfo.returnType.isEmpty() ? " " : ""));
            this.textFileChange.addEdit((TextEdit)typeInsertEdit);
        }
        DeleteEdit argumentsReplaceEdit = new DeleteEdit(this.destinationInfo.argumentsStartOffset, this.destinationInfo.argumentsText.length());
        this.textFileChange.addEdit((TextEdit)argumentsReplaceEdit);
        this.sourceInfo.argumentsText = this.addDefaultValues(this.destinationInfo, this.sourceInfo);
        InsertEdit argumentsInsertEdit = new InsertEdit(this.destinationInfo.argumentsStartOffset, this.sourceInfo.argumentsText);
        this.textFileChange.addEdit((TextEdit)argumentsInsertEdit);
    }

    public String addDefaultValues(MethodSignatureInformation source, MethodSignatureInformation destination) {
        return destination.argumentsText;
    }

    public IFile[] getAffectedFiles() throws Exception {
        Object[] affectedObjects = this.textFileChange.getAffectedObjects();
        IFile[] affectedFiles = new IFile[affectedObjects.length];
        int i = 0;
        while (i < affectedObjects.length) {
            Object affectedObject = affectedObjects[i];
            if (affectedObject instanceof IFile) {
                affectedFiles[i] = (IFile)affectedObject;
            }
            ++i;
        }
        return affectedFiles;
    }

    public String getDisplayString() {
        return null;
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FUNCTION);
    }

    protected class MethodSignatureInformation {
        public RfDefElement methodDef;
        public IPath defFileAbsolutePath;
        public IFile methodIFile;
        public RfFileDef methodDefFile;
        public IDocument document;
        public DVTEditor editor;
        public int argumentsStartOffset;
        public int argumentsEndOffset;
        public String argumentsText;
        public String returnType;
        public int returnTypeOffset;
        public int functionOrTaskKeywordEndOffset;
        public boolean shouldDisconnect;

        public MethodSignatureInformation(RfFunctionDef methodDef) {
            this.methodDef = methodDef;
            this.methodDefFile = methodDef.getDefFile();
        }

        public boolean initMethodSignatureElements(boolean isExternPrototype, boolean inCurrentEditor) throws Exception {
            IRfNamedElement assocType;
            if (!this.initEditorAndDocument(isExternPrototype || !inCurrentEditor)) {
                return false;
            }
            int startOffset = this.methodDef.getStartOffset();
            int endOffset = this.methodDef.getEndOffset();
            int semicolonOffset = -1;
            VlogQuickFixUtil quickFixUtilsInstance = VlogQuickFixUtil.getInstance();
            if (isExternPrototype) {
                RfDefElement enclosingDef = VlogQuickFixUtil.getInstance().getEnclosingScopeForDefElement(this.methodDef);
                if (enclosingDef == null) {
                    return false;
                }
                semicolonOffset = quickFixUtilsInstance.getForwardOffsetFor(this.document, ";", startOffset, enclosingDef.getEndOffset() + 1, false) - 1;
            } else {
                semicolonOffset = quickFixUtilsInstance.getForwardOffsetFor(this.document, ";", startOffset, endOffset, false) - 1;
            }
            boolean hasArguments = false;
            List<RfField> arguments = this.methodDef.getArgumentsWithPrefix("", 2);
            if (arguments != null && !arguments.isEmpty()) {
                for (RfField arg : arguments) {
                    if (!VlogQuickFixUtil.getInstance().isBetweenOffsets(arg, startOffset, endOffset, this.methodDef.getDefFile())) continue;
                    hasArguments = true;
                    break;
                }
            }
            if (hasArguments) {
                this.argumentsStartOffset = quickFixUtilsInstance.getForwardOffsetFor(this.document, "(", startOffset, semicolonOffset + 1, false) - 1;
                this.argumentsEndOffset = DVTFileUtils.getInstance().getMatchingBracketOffset(this.argumentsStartOffset, this.editor, this.document) - 1;
                if (this.argumentsEndOffset < 0) {
                    return false;
                }
                this.argumentsText = VlogQuickFixUtil.getInstance().getTextInRegion(new Region(this.argumentsStartOffset, this.argumentsEndOffset - this.argumentsStartOffset), this.document);
            } else {
                this.argumentsStartOffset = quickFixUtilsInstance.getForwardOffsetFor(this.document, "(", startOffset, semicolonOffset + 1, false) - 1;
                if (this.argumentsStartOffset == semicolonOffset) {
                    this.argumentsEndOffset = this.argumentsStartOffset;
                    this.argumentsText = "";
                } else {
                    this.argumentsEndOffset = DVTFileUtils.getInstance().getMatchingBracketOffset(this.argumentsStartOffset, this.editor, this.document) - 1;
                    this.argumentsText = VlogQuickFixUtil.getInstance().getTextInRegion(new Region(this.argumentsStartOffset, this.argumentsEndOffset - this.argumentsStartOffset), this.document);
                }
            }
            if (this.argumentsStartOffset < 0) {
                return false;
            }
            DataType returnTypeInfo = ((RfFunctionDef)this.methodDef).getTypeInfo(this.methodDef.getNamedElement());
            if (this.returnType == null || this.returnType.isEmpty()) {
                this.returnType = returnTypeInfo == null ? "" : returnTypeInfo.getTypeNameWithParamAssignments("", this.methodDef.getParserPath(), true, false);
            }
            if (BaseUpdateMethodSignatureQuickFixCommon.this.qualifyReturnType && isExternPrototype && !this.returnType.isEmpty() && ((assocType = ((RfFunction)this.methodDef.getNamedElement()).getAssociatedType()) instanceof RfTypeAlias || assocType instanceof RfClass)) {
                IRfScopeElement assocTypeScope = assocType.getEnclosingScope();
                RfNamedElement destinationScope = BaseUpdateMethodSignatureQuickFixCommon.this.destinationNamedElement.getEnclosingScope();
                if (destinationScope != null && (destinationScope == assocTypeScope || destinationScope instanceof RfClass && assocTypeScope instanceof RfClass && ((RfClass)destinationScope).isSubClass((RfClass)assocTypeScope))) {
                    this.returnType = String.valueOf(destinationScope.getName()) + "::" + this.returnType;
                }
            }
            int n = this.returnType == null || this.returnType.isEmpty() ? (returnTypeInfo != null && returnTypeInfo.getOffset() > 0 ? returnTypeInfo.getOffset() : this.getReturnTypeOffset() - 1) : (this.returnTypeOffset = this.getReturnTypeOffset() - 1);
            return this.returnTypeOffset >= 0;
        }

        private int getReturnTypeOffset() {
            int maxOffset = this.methodDef.getStartOffset();
            int minOffset = maxOffset - 100;
            VlogQuickFixUtil quickFixUtils = VlogQuickFixUtil.getInstance();
            Map<String, Integer> startOffsetsForMethodKeywords = quickFixUtils.getBackwardOffsetsForWords(this.document, BaseUpdateMethodSignatureQuickFixCommon.this.methodKeywords, minOffset, maxOffset);
            if (startOffsetsForMethodKeywords.isEmpty()) {
                return -1;
            }
            this.functionOrTaskKeywordEndOffset = -1;
            for (Map.Entry<String, Integer> entry : startOffsetsForMethodKeywords.entrySet()) {
                this.functionOrTaskKeywordEndOffset = Math.max(this.functionOrTaskKeywordEndOffset, entry.getKey().length() + entry.getValue());
            }
            Map<String, Integer> startOffsetsForKeywords = quickFixUtils.getBackwardOffsetsForWords(this.document, BaseUpdateMethodSignatureQuickFixCommon.this.lifetimeKeywords, this.functionOrTaskKeywordEndOffset, maxOffset);
            if (startOffsetsForKeywords.isEmpty()) {
                return DVTDocumentUtils.nextCodeCharOffset((IDocument)this.document, (int)this.functionOrTaskKeywordEndOffset, (boolean)true, (String)"__vlog_partitioning");
            }
            int lifetimeKeywordOffset = this.functionOrTaskKeywordEndOffset;
            for (Map.Entry<String, Integer> entry : startOffsetsForKeywords.entrySet()) {
                lifetimeKeywordOffset = Math.max(lifetimeKeywordOffset, entry.getKey().length() + entry.getValue());
            }
            return DVTDocumentUtils.nextCodeCharOffset((IDocument)this.document, (int)lifetimeKeywordOffset, (boolean)true, (String)"__vlog_partitioning");
        }

        public boolean initEditorAndDocument(boolean useTextFileBuffer) throws Exception {
            this.editor = BaseUpdateMethodSignatureQuickFixCommon.this.getOpenEditor(BaseUpdateMethodSignatureQuickFixCommon.this.targetResource);
            if (this.editor == null) {
                return false;
            }
            this.document = this.editor.getDocument();
            if (this.document == null) {
                return false;
            }
            if (useTextFileBuffer) {
                LocationKind locationKind;
                if (this.methodDef == null) {
                    return false;
                }
                this.methodIFile = (IFile)this.methodDefFile.getFileAdapter();
                if (this.methodIFile == null) {
                    return false;
                }
                this.defFileAbsolutePath = this.methodIFile.getLocation();
                if (this.defFileAbsolutePath == null) {
                    return false;
                }
                this.shouldDisconnect = false;
                TextFileBufferInfo textFileBufferInfo = DVTFileUtils.getInstance().getTextFileBufferInfo(this.methodIFile);
                IPath path = textFileBufferInfo.getPath();
                ITextFileBuffer textFileBuffer = BaseUpdateMethodSignatureQuickFixCommon.this.bufferManager.getTextFileBuffer(path, locationKind = textFileBufferInfo.getLocationKind());
                if (textFileBuffer == null) {
                    this.shouldDisconnect = true;
                    BaseUpdateMethodSignatureQuickFixCommon.this.bufferManager.connect(path, locationKind, null);
                    textFileBuffer = BaseUpdateMethodSignatureQuickFixCommon.this.bufferManager.getTextFileBuffer(path, locationKind);
                }
                if (textFileBuffer != null) {
                    this.document = textFileBuffer.getDocument();
                }
                if (this.document == null) {
                    return false;
                }
            }
            return true;
        }
    }
}

