/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;

public class ChangeIllegalAccessIdentifierQuickFix
extends BaseAbstractQuickFix {
    private String fAccessIdentifier;
    private RfDefElement fElementDeclaration;
    private int fOffsetToRemoveFrom;
    private int fInitialTextLength;
    private String fNewText;

    public ChangeIllegalAccessIdentifierQuickFix(IMarker marker, ITextViewer viewer, RfDefElement elementDeclaration, String accessIdentifier) {
        super(marker, viewer);
        this.fElementDeclaration = elementDeclaration;
        this.fAccessIdentifier = accessIdentifier;
    }

    @Override
    public void preApplyQuickFix(IDocument document) throws Exception {
        IResource resourceToApplyQFix = this.fElementDeclaration.getDefFile().getFileAdapter();
        if (resourceToApplyQFix != this.marker.getResource()) {
            this.targetResource = resourceToApplyQFix;
        }
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)this.targetEditor, this.targetDocument, this.getDisplayString(), (Change)this.textFileChange);
        this.targetEditor.selectAndReveal(this.fOffsetToRemoveFrom, 0);
    }

    public String getDisplayString() {
        return "Remove '" + this.fAccessIdentifier + "' qualifier";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        if (this.fAccessIdentifier == null) {
            return;
        }
        if (document == null) {
            return;
        }
        this.targetEditor = this.getOpenEditor(this.targetResource);
        RfNamedElement enclosingScope = this.fElementDeclaration.getEnclosingScope();
        if (enclosingScope == null) {
            return;
        }
        RfNamedElement closestTypeContainer = enclosingScope.getClosestTypeContainer();
        if (closestTypeContainer == null) {
            return;
        }
        int minOffsetLimit = closestTypeContainer.getStartOffset();
        int endOffset = this.fElementDeclaration.getStartOffset();
        this.fOffsetToRemoveFrom = VlogQuickFixUtil.getInstance().getBackwardOffsetFor(document, this.fAccessIdentifier, minOffsetLimit, endOffset, false, false);
        if (this.fOffsetToRemoveFrom == minOffsetLimit) {
            return;
        }
        String textToRemoveFrom = document.get(this.fOffsetToRemoveFrom, endOffset - this.fOffsetToRemoveFrom + 1);
        this.fInitialTextLength = textToRemoveFrom.length();
        this.fNewText = textToRemoveFrom.replaceFirst("(^|(?<=\\s))" + this.fAccessIdentifier.concat("\\s+"), "");
        this.textFileChange = new VlogTextFileChange(this.targetResource.getProjectRelativePath().toOSString(), (IFile)this.targetResource);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        ReplaceEdit insertEdit = new ReplaceEdit(this.fOffsetToRemoveFrom, this.fInitialTextLength, this.fNewText);
        this.textFileChange.addEdit((TextEdit)insertEdit);
    }

    public IFile[] getAffectedFiles() throws Exception {
        IFile[] affectedFiles = new IFile[]{(IFile)this.fElementDeclaration.getDefFile().getFileAdapter()};
        return affectedFiles;
    }
}

