/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidAccessArgs;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

public class CollectHidAccessArgsInRegionVisitor
extends RfHidVisitor {
    private List<IHidObject> fArgsInRegion = new ArrayList<IHidObject>();
    private int fStartOffset;
    private int fEndOffset;
    private String elementName;

    @Override
    public void setHolder(IHidHolder holder) {
        this.holder = holder;
    }

    @Override
    public void setParserPath(ParserPath parserPath) {
        this.parserPath = parserPath;
    }

    public CollectHidAccessArgsInRegionVisitor(String elementName, IRegion region) {
        this.elementName = elementName;
        this.fStartOffset = region.getOffset();
        this.fEndOffset = this.fStartOffset + region.getLength();
    }

    public boolean visit(RfHid hid) {
        if (!hid.hasAccesses()) {
            return true;
        }
        if (this.elementName != null && !this.elementName.equals(hid.getName())) {
            return true;
        }
        for (HidAccess hidAccess : hid.getAccesses()) {
            List argumentValues;
            int hidAccesssOffset;
            if (!(hidAccess instanceof IHidAccessArgs) || (hidAccesssOffset = hidAccess.getOccurrence().getOffset()) < this.fStartOffset || hidAccesssOffset > this.fEndOffset || (argumentValues = ((IHidAccessArgs)hidAccess).getArgumentValues()) == null || argumentValues.isEmpty()) continue;
            for (IHidObject valueOperator : argumentValues) {
                IHidObject value = MethodCallUtils.getValue((IHidObject)valueOperator);
                if (value != null) {
                    this.fArgsInRegion.add(value);
                    continue;
                }
                this.fArgsInRegion.add(valueOperator);
            }
            return false;
        }
        return true;
    }

    public List<? extends IHidObject> getArgsInRegion() {
        return this.fArgsInRegion;
    }

    public IHidHolder getHolder() {
        return this.holder;
    }

    public ParserPath getParserPath() {
        return this.parserPath;
    }
}

