/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidAccessArgs;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

public class CollectMethodCallsInRegionVisitor
extends RfHidVisitor {
    private List<IHidAccessArgs> fMethodCallsAndArgsInRegion = new ArrayList<IHidAccessArgs>();
    private int fStartOffset;
    private int fEndOffset;

    @Override
    public void setHolder(IHidHolder holder) {
        this.holder = holder;
    }

    @Override
    public void setParserPath(ParserPath parserPath) {
        this.parserPath = parserPath;
    }

    public CollectMethodCallsInRegionVisitor(IRegion region) {
        this.fStartOffset = region.getOffset();
        this.fEndOffset = this.fStartOffset + region.getLength();
    }

    public boolean visit(RfHid hid) {
        if (!hid.hasAccesses()) {
            return true;
        }
        for (HidAccess hidAccess : hid.getAccesses()) {
            List argumentValues;
            int hidAccesssOffset;
            HidOccurrence occurrence;
            if (!(hidAccess instanceof IHidAccessArgs) || (occurrence = hidAccess.getOccurrence()) == null || (hidAccesssOffset = occurrence.getOffset()) < this.fStartOffset || hidAccesssOffset > this.fEndOffset || (argumentValues = ((IHidAccessArgs)hidAccess).getArgumentValues()) == null || argumentValues.isEmpty()) continue;
            this.fMethodCallsAndArgsInRegion.add((IHidAccessArgs)hidAccess);
        }
        return true;
    }

    public List<IHidAccessArgs> getArgsInRegion() {
        return this.fMethodCallsAndArgsInRegion;
    }

    public IHidHolder getHolder() {
        return this.holder;
    }

    public ParserPath getParserPath() {
        return this.parserPath;
    }
}

