/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickfix.quickfixes.DVTDummyCreateFileChange;
import ro.amiq.dvt.ui.editor.quickfix.quickfixes.ICreateFileQuickFixProposal;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.IVlogModule;
import ro.amiq.vlogdt.model.VlogModelManager;
import ro.amiq.vlogdt.model.VlogModule;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;

public class CreateIncludedFileQuickFix
extends BaseAbstractQuickFix
implements ICreateFileQuickFixProposal {
    private static final String FILE_TEXT = "";
    private File fileToCreate;
    private Path filePath;
    private Image image;
    private int priority;
    private int distanceToIncludedFile;
    private java.nio.file.Path printPath;

    public CreateIncludedFileQuickFix(IMarker marker, ITextViewer viewer, File fileToCreate, Image image, int priority, int distanceToIncludedFile, java.nio.file.Path printPath) {
        super(marker, viewer);
        this.fileToCreate = fileToCreate;
        this.filePath = new Path(fileToCreate.getAbsolutePath());
        this.image = image;
        this.priority = priority;
        this.distanceToIncludedFile = distanceToIncludedFile;
        this.printPath = printPath;
    }

    @Override
    public void preApplyQuickFix(IDocument document) throws Exception {
        super.preApplyQuickFix(document);
        this.triggerEditor = this.getOpenEditor(this.triggerResource);
    }

    public IFile[] getAffectedFiles() throws Exception {
        return new ArrayList().toArray(new IFile[0]);
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        IRfSingleLangProject rfProject = this.enclosingScope.getRfProject();
        if (rfProject == null) {
            return;
        }
        final IProject project = rfProject.getProject();
        if (project == null) {
            return;
        }
        IPath projectLocation = project.getLocation();
        if (projectLocation == null) {
            return;
        }
        this.createFile(this.fileToCreate, project);
        if (projectLocation.isPrefixOf((IPath)this.filePath)) {
            IFile file = project.getFile(this.filePath.makeRelativeTo(projectLocation));
            file.refreshLocal(1, null);
            PropertiesManager.addSessionProperty((IResource)file, (String)PropertyTypes.QN_IMPORTED_FILE, (String)IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_1800_2012.id);
            this.triggerReparseAndUpdateCaches();
            this.openFile(file);
        } else {
            ResourcesPlugin.getWorkspace().run(monitor -> {
                DVTAutoLinkManager.IAutoLinkOperation op = new DVTAutoLinkManager.IAutoLinkOperation(){

                    public void run(Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
                        Map autoLinkedRoots = BuildConfigManager.getAutoLinkedRoots((IProject)project);
                        IFile file = DVTAutoLinkManager.getInstance().createAutoLink(project, (IPath)CreateIncludedFileQuickFix.this.filePath, autoLinkedRoots, null, false);
                        if (file == null) {
                            return;
                        }
                        CreateIncludedFileQuickFix.this.triggerReparseAndUpdateCaches();
                        CreateIncludedFileQuickFix.this.openFile(file);
                    }
                };
                DVTAutoLinkManager.getInstance().modifyWorkspaceOperation(project, "QUICK_FIX", op, false);
            }, null);
        }
    }

    public void triggerReparseAndUpdateCaches() {
        IVlogModule vlogFile = VlogModelManager.getInstance().getVlogModel().getOrCreateVlogModule((IFile)this.triggerResource);
        if (vlogFile == null) {
            return;
        }
        IPath filePath = Path.fromOSString((String)this.fileToCreate.getPath());
        DVTAutoLinkManager.getInstance().removeFileInfo(filePath);
        ((VlogModule)vlogFile).blockingReparse();
    }

    public void createFile(File file, IProject project) {
        try {
            IPath projectPath = project.getRawLocation();
            if (projectPath != null && projectPath.isPrefixOf((IPath)new Path(file.getAbsolutePath()))) {
                IPath relativePath = new Path(file.getAbsolutePath()).makeRelativeTo(projectPath);
                IFile projectFile = project.getFile(relativePath);
                this.createFileAndParents((IResource)projectFile, FILE_TEXT);
            } else {
                if (file.getParentFile() == null) {
                    return;
                }
                Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
                DVTFileUtils.getInstance().writeStringToFile(file, FILE_TEXT, false);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return;
        }
    }

    private void createFileAndParents(IResource resource, String string) throws CoreException {
        if (resource == null || resource.exists()) {
            return;
        }
        if (!resource.getParent().exists()) {
            this.createFileAndParents((IResource)resource.getParent(), string);
        }
        switch (resource.getType()) {
            case 1: {
                ByteArrayInputStream stream = new ByteArrayInputStream(string.getBytes());
                ((IFile)resource).create((InputStream)stream, 0, null);
                break;
            }
            case 2: {
                ((IFolder)resource).create(0, true, null);
                break;
            }
        }
    }

    public void openFile(IFile file) {
        IEditorPart openEditor = VlogQuickFixUtil.getInstance().openEditor(file);
        if (!(openEditor instanceof DVTEditor)) {
            return;
        }
        this.targetEditor = (DVTEditor)openEditor;
        if (this.targetEditor == null) {
            return;
        }
        this.targetDocument = this.targetEditor.getDocument();
        this.targetEditor.doSave(null);
        this.targetEditor.setCursor(0);
        this.targetEditor.showContentAssistProposalsForCreatedFile();
    }

    public String getAdditionalProposalInfo() {
        return "Create file '" + this.filePath.lastSegment() + "' in '" + this.filePath.removeLastSegments(1) + "'";
    }

    public Image getImage() {
        if (this.image == null) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FILE);
        }
        return this.image;
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        IRfSingleLangProject rfProject = this.enclosingScope.getRfProject();
        if (rfProject == null) {
            return;
        }
        IProject project = rfProject.getProject();
        if (project == null) {
            return;
        }
        IPath projectLocation = project.getLocation();
        if (projectLocation == null) {
            return;
        }
        if (this.fileToCreate.exists()) {
            VlogQuickFixUtil.getInstance().doProposeRebuild(project, this.filePath).thenAccept(wasRebuildStarted -> {
                if (!wasRebuildStarted.booleanValue()) {
                    return;
                }
                IFile file = DVTFileUtils.getInstance().getProjectFile(project, this.filePath.toOSString());
                if (file == null) {
                    return;
                }
                this.openFile(file);
            });
            return;
        }
        this.textFileChange = new DVTDummyCreateFileChange(this.triggerResource.getName(), (IFile)this.triggerResource, this.filePath);
    }

    public String getFilePath() {
        if (this.filePath == null) {
            return FILE_TEXT;
        }
        return this.filePath.makeAbsolute().toOSString();
    }

    public int getPriority() {
        return this.priority;
    }

    public int getDistanceToIncludedFile() {
        return this.distanceToIncludedFile;
    }

    public String getDisplayString() {
        return "Create '" + this.filePath.lastSegment() + "' in '.../" + this.printPath.toString() + "' (" + this.filePath.removeLastSegments(1) + ")";
    }

    public String getNewFilePath() {
        return this.fileToCreate.getAbsolutePath();
    }
}

