/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.TextFileBufferInfo;
import ro.amiq.dvt.wizards.newfile.FormatNewFileContentPatternType;
import ro.amiq.dvt.wizards.newfile.QuickFixOrAssistType;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedTypeWrapper;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.ui.editor.quickassist.QuickAssistMoveSelectionToNewFileProposal;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.CreateNonExistingClassQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;

public abstract class CreateNonExistingElementQuickFixCommon
extends BaseAbstractQuickFix {
    protected final String NEW_LINE = System.lineSeparator();
    private final String PARAM_TYPE_NAME = "T";
    private final String OPENING_BR = " #(" + this.NEW_LINE;
    private final String CLOSING_BR = ")";
    private final String ARG_SEPARATOR = "," + this.NEW_LINE;
    private final String PAR_TYPE = "parameter type ";
    private final String PAR = "parameter ";
    private final String PACKAGE_AND_CLASS_SEPARATOR = "::";
    protected String ELEMENT_BODY = ";" + this.NEW_LINE + "{0}" + this.NEW_LINE + "endclass" + this.NEW_LINE + this.NEW_LINE;
    private String closingBr;
    private String typeParameterString;
    private String parameterString;
    protected String elementType;
    protected String startString;
    protected String endString;
    protected String tabOrSpace;
    protected String simpleElementName = "";
    protected QuickAssistMoveSelectionToNewFileProposal moveQuickAssistProposal;

    protected CreateNonExistingElementQuickFixCommon(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
        this.triggerEditor = this.getOpenEditor(marker.getResource());
        this.tabOrSpace = this.triggerEditor != null ? VlogQuickFixUtil.getInstance().getTabOrSpaces(this.triggerEditor, this.triggerEditor.getDocument()) : "    ";
        this.closingBr = String.valueOf(this.NEW_LINE) + this.tabOrSpace + ")";
        this.typeParameterString = String.valueOf(this.tabOrSpace) + "parameter type ";
        this.parameterString = String.valueOf(this.tabOrSpace) + "parameter ";
    }

    protected void computeElementInfo(IDocument document) throws Exception {
        if (this.enclosingScope == null) {
            return;
        }
        IncludeProperties includeProperties = this.computeIncludeProperties();
        if (includeProperties == null) {
            return;
        }
        String classDefinition = this.computeClassDefinition();
        if (classDefinition == null) {
            return;
        }
        this.moveQuickAssistProposal = new QuickAssistMoveSelectionToNewFileProposal(includeProperties.includeOffset, includeProperties.includeIndent, classDefinition, includeProperties.includeFile, null, FormatNewFileContentPatternType.FILE_NAME, this.getQuickFixType(), this.simpleElementName, null, null);
        this.moveQuickAssistProposal.preApplyQuickAssist(document);
    }

    private IncludeProperties computeIncludeProperties() throws CoreException, BadLocationException, BadPartitioningException {
        IncludeProperties includeProperties = new IncludeProperties();
        includeProperties.includeFile = (IFile)this.enclosingScope.getNamedElement().getFileAdapter();
        includeProperties.includeOffset = 0;
        includeProperties.includeIndent = "";
        RfNamedElement enclosingPackageScope = this.getEnclosingPackageScope();
        if (enclosingPackageScope == null) {
            return includeProperties;
        }
        ITextFileBufferManager targetBufferManager = FileBuffers.getTextFileBufferManager();
        IResource targetFile = enclosingPackageScope.getDeclaration().getDefFile().getFileAdapter();
        TextFileBufferInfo textFileBufferInfo = DVTFileUtils.getInstance().getTextFileBufferInfo((IFile)targetFile);
        IPath path = textFileBufferInfo.getPath();
        LocationKind locationKind = textFileBufferInfo.getLocationKind();
        ITextFileBuffer textFileBuffer = targetBufferManager.getTextFileBuffer(path, locationKind);
        boolean shouldDisconnectTarget = false;
        if (textFileBuffer == null) {
            shouldDisconnectTarget = true;
            targetBufferManager.connect(path, locationKind, null);
            textFileBuffer = targetBufferManager.getTextFileBuffer(path, locationKind);
        }
        IDocument targetDoc = null;
        if (textFileBuffer != null) {
            targetDoc = textFileBuffer.getDocument();
        }
        if (targetDoc == null) {
            return null;
        }
        includeProperties.includeOffset = DVTDocumentUtils.getCharOffset((char)';', (int)enclosingPackageScope.getOffset(), (boolean)true, (int)100, (IDocument)targetDoc, (String)"__vlog_partitioning") + 1;
        includeProperties.includeIndent = String.valueOf(this.tabOrSpace) + DVTDocumentUtils.getIndent((int)enclosingPackageScope.getDeclaration().getStartOffset(), (IDocument)targetDoc);
        if (!(targetFile instanceof IFile)) {
            return null;
        }
        includeProperties.includeFile = (IFile)targetFile;
        if (shouldDisconnectTarget) {
            targetBufferManager.disconnect(path, locationKind, null);
        }
        return includeProperties;
    }

    private RfNamedElement getEnclosingPackageScope() {
        String elementPathString = this.marker.getAttribute("QUICKFIX_SCOPE_ELEMENT_PATH", null);
        RfElementPath elementPath = RfElementPath.fromString((String)elementPathString, CreateNonExistingClassQuickFix.class);
        IRfNamedElement enclosingScopeFromPath = elementPath == null ? null : elementPath.toNamedElement(this.marker.getResource().getProject());
        RfNamedElement ancestorPackageScope = enclosingScopeFromPath == null || !(enclosingScopeFromPath instanceof RfNamedElement) ? null : VlogQuickFixUtil.getInstance().getEnclosingScopeForNamedElement((RfNamedElement)enclosingScopeFromPath, RfPackage.class);
        RfNamedElement enclosingParent = null;
        if (ancestorPackageScope == null || this.elementName.split("::").length == 1) {
            IRfNamedElement enclosingScopeNamedElement = this.enclosingScope.getNamedElement();
            if (enclosingScopeNamedElement instanceof RfNamedElement) {
                enclosingParent = VlogQuickFixUtil.getInstance().getEnclosingScopeForNamedElement((RfNamedElement)enclosingScopeNamedElement, RfPackage.class);
            }
        } else if (enclosingScopeFromPath != null) {
            enclosingParent = (RfNamedElement)enclosingScopeFromPath;
        }
        return enclosingParent;
    }

    private String computeClassDefinition() {
        IRfNamedElement elem = this.enclosingScope.getNamedElement();
        DataType parentType = this.computeParentType(elem);
        if (parentType == null) {
            return null;
        }
        StringBuilder definitionBuilder = new StringBuilder();
        if ("".equals(this.simpleElementName)) {
            this.simpleElementName = this.deconstructElementName();
        }
        definitionBuilder.append(String.valueOf(this.startString) + this.simpleElementName);
        String paramSig = this.computeParamSignature(elem, parentType);
        if (paramSig != null && !paramSig.isEmpty()) {
            definitionBuilder.append(paramSig);
        }
        definitionBuilder.append(this.endString);
        return definitionBuilder.toString();
    }

    private String computeParamSignature(IRfNamedElement enclosingScope, DataType parentType) {
        boolean hasParams;
        if (!(enclosingScope instanceof RfNamedElement)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        ArrayList<String> paramSignatures = new ArrayList<String>();
        List<DataType> orderedParam = parentType.getOrderedParamAssignments();
        Map<String, ArgInfo> namedParam = parentType.getNamedParamAssignments();
        boolean bl = hasParams = orderedParam != null || namedParam != null;
        if (hasParams) {
            result.append(this.OPENING_BR);
        }
        if (orderedParam != null) {
            int i = 0;
            while (i < orderedParam.size()) {
                DataType orderedParamType = orderedParam.get(i);
                boolean isTypeParameter = this.isTypeParameterInParent(orderedParamType.getType(), enclosingScope);
                if (!isTypeParameter) {
                    RfAssociatedTypeWrapper wrapper = new RfAssociatedTypeWrapper(orderedParamType, (RfNamedElement)enclosingScope);
                    IRfNamedElement assocType = wrapper.getAssociatedType(0);
                    isTypeParameter = assocType != null;
                }
                String paramString = isTypeParameter ? String.valueOf(this.typeParameterString) + "T" + i : String.valueOf(this.parameterString) + "T" + i;
                paramSignatures.add(paramString);
                ++i;
            }
        } else if (namedParam != null) {
            for (Map.Entry<String, ArgInfo> entry : namedParam.entrySet()) {
                String paramName;
                DataType paramDataType;
                ArgInfo paramInfo = entry.getValue();
                if (paramInfo == null || (paramDataType = paramInfo.getDataType()) == null || (paramName = entry.getKey()) == null) continue;
                boolean isTypeParameter = this.isTypeParameterInParent(paramName, enclosingScope);
                if (!isTypeParameter) {
                    RfAssociatedTypeWrapper wrapper = new RfAssociatedTypeWrapper(paramDataType, (RfNamedElement)enclosingScope);
                    IRfNamedElement assocType = wrapper.getAssociatedType();
                    isTypeParameter = assocType != null;
                }
                String paramString = isTypeParameter ? String.valueOf(this.typeParameterString) + paramName : String.valueOf(this.parameterString) + paramName;
                paramSignatures.add(paramString);
            }
        }
        if (!paramSignatures.isEmpty()) {
            result.append(DVTStringUtil.join(paramSignatures, (String)this.ARG_SEPARATOR));
        }
        if (hasParams) {
            result.append(this.closingBr);
        }
        return result.toString();
    }

    private boolean isTypeParameterInParent(String name, IRfNamedElement enclosingScope) {
        if (!(enclosingScope instanceof RfNamedElement)) {
            return false;
        }
        RfField parameter = ((RfNamedElement)enclosingScope).getParameterWithPrefix(name, 256, 1, 2);
        if (parameter != null && parameter.isTypeParameter()) {
            return true;
        }
        IRfScopeElement parentScope = enclosingScope.getEnclosingScope();
        while (parentScope instanceof RfNamedElement) {
            parameter = ((RfNamedElement)parentScope).getParameterWithPrefix(name, 256, 1, 2);
            if (parameter != null && parameter.isTypeParameter()) {
                return true;
            }
            parentScope = parentScope.getEnclosingScope();
        }
        return false;
    }

    public IFile[] getAffectedFiles() throws Exception {
        IResource elementResource = this.enclosingScope.getFileAdapter();
        if (elementResource == null || !(elementResource instanceof IFile)) {
            return null;
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)elementResource);
        return affectedFiles.toArray(new IFile[1]);
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        if (this.moveQuickAssistProposal == null) {
            return;
        }
        this.moveQuickAssistProposal.apply(document);
    }

    protected String getCategory() {
        return "QuickFixCategory_" + ((Object)((Object)this)).toString();
    }

    protected String deconstructElementName() {
        String[] parsedElementName = this.elementName.split("::", 100);
        if (parsedElementName.length > 0) {
            return parsedElementName[parsedElementName.length - 1];
        }
        return null;
    }

    public String getDisplayString() {
        if ("".equals(this.simpleElementName)) {
            this.simpleElementName = this.deconstructElementName();
        }
        return "Create " + this.elementType + " '" + this.simpleElementName + "' in new file";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ANY_DESIGN_INSTANCE);
    }

    protected abstract DataType computeParentType(IRfNamedElement var1);

    protected abstract QuickFixOrAssistType getQuickFixType();

    static class IncludeProperties {
        public int includeOffset;
        public String includeIndent;
        public IFile includeFile;

        IncludeProperties() {
        }
    }
}

