/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickfix.quickfixes.QuickFixException;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.AbstractVariableQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.TypeName;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;

public abstract class DeclareArgumentQuickFixCommon
extends AbstractVariableQuickFix {
    protected DVTLinkedPositionProvider fLinkedPositionMaker;
    protected LinkedModeModel fLinkedProposalModel = new LinkedModeModel();
    protected LinkedHashMap<IResource, VlogTextFileChange> fTextFileChanges;
    protected IResource fCurrentFile;
    protected IDocument fInitialDocument;
    protected DVTEditor fEditor;

    protected DeclareArgumentQuickFixCommon(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ARGUMENT);
    }

    public String getDisplayString() {
        return "Declare argument '" + this.elementName + "'";
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        if (!this.computeTextChanges(document, editorChanged)) {
            return;
        }
        this.createCompositeChange();
    }

    protected void addLinkedPositions(IDocument document) throws Exception {
        VlogTextFileChange funcDefinitionTextFileChange = this.fTextFileChanges.get(this.fCurrentFile);
        this.fLinkedPositionMaker = new DVTLinkedPositionProvider(this.fEditor, this.fLinkedProposalModel, this.getCategory(), true, (DVTTextFileChange)this.fTextFileChanges.get(this.fCurrentFile));
        this.fLinkedPositionMaker.addMultipleLinkedPosition(new ArrayList(funcDefinitionTextFileChange.getAbsoluteRegions()), this.fInitialDocument, -1);
        this.fLinkedPositionMaker.enterLinkedMode(document, null);
    }

    private void createCompositeChange() {
        this.compositeTextChange = new CompositeChange("Quick fix add argument changes");
        ArrayList<VlogTextFileChange> allFileChanges = new ArrayList<VlogTextFileChange>(this.fTextFileChanges.values());
        Comparator offsetComp = (c1, c2) -> c1.getEdit().getOffset() - c2.getEdit().getOffset();
        Collections.sort(allFileChanges, offsetComp);
        for (VlogTextFileChange change : allFileChanges) {
            this.compositeTextChange.add((Change)change);
        }
    }

    public IFile[] getAffectedFiles() throws Exception {
        Object[] affectedObjects = this.compositeTextChange.getAffectedObjects();
        IFile[] affectedFiles = new IFile[affectedObjects.length];
        int i = 0;
        while (i < affectedObjects.length) {
            Object affectedObject = affectedObjects[i];
            if (affectedObject instanceof IFile) {
                affectedFiles[i] = (IFile)affectedObject;
            }
            ++i;
        }
        return affectedFiles;
    }

    public final boolean computeTextChanges(IDocument currentDoc, boolean editorChanged) throws QuickFixException {
        RfFunction functionOnCursor = ((RfDefElement)this.enclosingScope).getEnclosingScope(RfFunction.class);
        if (functionOnCursor == null) {
            return false;
        }
        RfProject rfProject = functionOnCursor.getRfProject();
        if (rfProject == null) {
            return false;
        }
        IProject project = rfProject.getProject();
        this.fTextFileChanges = new LinkedHashMap();
        RfFunctionDef functionOnCursorImplementation = VlogQuickFixUtil.getInstance().getFunctionImplementation(functionOnCursor, this.offset, this.marker.getResource());
        if (functionOnCursorImplementation == null) {
            return false;
        }
        this.fCurrentFile = functionOnCursorImplementation.getFileAdapter();
        TypeName variableTypeName = VlogQuickFixUtil.getInstance().getVariableType(functionOnCursorImplementation.getNamedElement(), this.elementName, this.position.offset, true, true);
        String typeName = variableTypeName.getTypeName();
        String unpackedDimension = variableTypeName.getUnpackedDim() == null ? "" : variableTypeName.getUnpackedDim();
        this.fInitialDocument = currentDoc;
        List<Object> allChildFunctions = functionOnCursor.isVirtual() ? VlogRfReferencesUtils.getAllFunctionsFromInheritanceTree(functionOnCursor, true) : new ArrayList();
        allChildFunctions.add(functionOnCursor);
        DocumentManager documentManager = new DocumentManager();
        try {
            documentManager.activate();
            for (RfNamedElement rfNamedElement : allChildFunctions) {
                RfFunction currentFunction = (RfFunction)rfNamedElement;
                Collection currentFunctionDeclarations = currentFunction.getDeclarations();
                if (currentFunctionDeclarations == null || currentFunctionDeclarations.isEmpty()) continue;
                for (RfDefElement currentDeclaration : currentFunctionDeclarations) {
                    if (this.updateDeclaration(project, typeName, unpackedDimension, documentManager, currentDeclaration)) continue;
                    return false;
                }
            }
        }
        finally {
            documentManager.deactivate();
        }
        return true;
    }

    private boolean updateDeclaration(IProject project, String typeName, String unpackedDimension, DocumentManager documentManager, RfDefElement functionDeclaration) throws QuickFixException {
        IResource file = functionDeclaration.getFileAdapter();
        VlogTextFileChange currentChange = this.fTextFileChanges.get(file);
        if (currentChange == null) {
            currentChange = VlogQuickFixUtil.getInstance().getTextFileChange(functionDeclaration);
            this.fTextFileChanges.put(file, currentChange);
        }
        if (currentChange == null) {
            return false;
        }
        IDocument document = documentManager.getDocument(functionDeclaration.getParserPath(), project);
        this.updateElement(functionDeclaration, typeName, unpackedDimension, document, currentChange);
        return true;
    }

    private void updateElement(RfDefElement element, String typeName, String unpackedDimension, IDocument document, VlogTextFileChange textFileChange) throws QuickFixException {
        int insertOffset;
        RfDefElement declaration = null;
        List<RfField> arguments = element.getArgumentsWithPrefix("", 2);
        boolean hasArguments = false;
        int editRelativeOffset = 0;
        if (arguments != null && !arguments.isEmpty()) {
            for (RfField arg : arguments) {
                if (!VlogQuickFixUtil.getInstance().isBetweenOffsets(arg, element.getStartOffset(), element.getEndOffset(), element.getDefFile())) continue;
                hasArguments = true;
                break;
            }
        }
        String replacementString = hasArguments ? ", " + typeName + " " + this.elementName + unpackedDimension : "(" + typeName + " " + this.elementName + unpackedDimension + ")";
        declaration = element;
        int startOffset = declaration.getStartOffset();
        VlogQuickFixUtil quickFixUtilsInstance = VlogQuickFixUtil.getInstance();
        int rparenOffset = quickFixUtilsInstance.getBackwardOffsetFor(document, ")", startOffset, insertOffset = quickFixUtilsInstance.getForwardOffsetFor(document, ";", startOffset, declaration.getEndOffset() + 1000, false) - 1, false);
        if (rparenOffset > startOffset && rparenOffset < insertOffset) {
            insertOffset = rparenOffset;
            if (replacementString.charAt(0) == '(' && replacementString.charAt(replacementString.length() - 1) == ')') {
                replacementString = replacementString.substring(1, replacementString.length() - 1);
            }
        }
        if (insertOffset == -1) {
            throw new QuickFixException();
        }
        editRelativeOffset = replacementString.indexOf(typeName);
        if (editRelativeOffset == -1) {
            editRelativeOffset = 0;
        }
        InsertEdit insertParam = new InsertEdit(insertOffset, replacementString);
        textFileChange.addEdit((TextEdit)insertParam, (IRegion)new Region(editRelativeOffset, typeName.length()));
    }

    protected String getCategory() {
        return "QuickFixCategory_" + ((Object)((Object)this)).toString();
    }
}

