/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vlogdt.model.reflection.RfStructDef;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.BaseDeclareEnumAndFieldQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;

public class DeclareEnumQuickFix
extends BaseDeclareEnumAndFieldQuickFix {
    private static final String ENUM_VALUE = "enum_value";

    public DeclareEnumQuickFix(IMarker marker, ITextViewer viewer, RfStructDef declaration) {
        super(marker, viewer, declaration.getEnclosingScope());
        this.declaration = declaration;
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ENUM_ITEM);
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.insertOffset = this.declaration.getEndOffset();
        this.insertOffset = VlogQuickFixUtil.getInstance().getBackwardOffsetFor(document, "}", this.declaration.getStartOffset(), this.insertOffset, true, true);
        this.replacementString = ", " + this.elementName + " = " + ENUM_VALUE;
        this.textFileChange = new VlogTextFileChange(this.targetResource.getProjectRelativePath().toOSString(), (IFile)this.targetResource);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        InsertEdit insertEdit = new InsertEdit(this.insertOffset, this.replacementString);
        this.textFileChange.addEdit((TextEdit)insertEdit, (IRegion)new Region(this.replacementString.indexOf(ENUM_VALUE), ENUM_VALUE.length()));
    }

    public String getDisplayString() {
        return "Declare enum '" + this.elementName + "'";
    }

    @Override
    protected String getCategory() {
        return "QuickFixCategory_" + ((Object)((Object)this)).toString();
    }
}

