/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.DeclareFieldQuickFix;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;

public class DeclareEventQuickFix
extends DeclareFieldQuickFix {
    public DeclareEventQuickFix(IMarker marker, ITextViewer viewer, RfNamedElement enclosingElem) {
        super(marker, viewer, enclosingElem, false);
    }

    @Override
    public String getDisplayString() {
        return "Declare event '" + this.elementName + "'";
    }

    @Override
    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.insertOffset = this.declaration.getStartOffset();
        String indent = DVTDocumentUtils.getIndent((int)this.insertOffset, (IDocument)document);
        IRegion lineInformationOfOffset = document.getLineInformationOfOffset(this.insertOffset);
        String cursorUpdate = editorChanged ? "${}" : "";
        this.replacementString = null;
        if (!this.declareInside && !(this.declaration.getNamedElement() instanceof RfField)) {
            this.insertOffset = lineInformationOfOffset.getOffset();
            this.replacementString = String.valueOf(indent) + "event " + this.elementName + ";" + cursorUpdate + "\n";
        } else {
            this.insertOffset = lineInformationOfOffset.getOffset() + lineInformationOfOffset.getLength();
            this.replacementString = "\n" + indent + "event " + this.elementName + ";" + cursorUpdate;
        }
        this.textFileChange = new VlogTextFileChange(this.targetResource.getProjectRelativePath().toOSString(), (IFile)this.targetResource);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        InsertEdit insertEdit = new InsertEdit(this.insertOffset, this.replacementString);
        this.textFileChange.addEdit((TextEdit)insertEdit);
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_EVENT);
    }

    @Override
    protected String getCategory() {
        return "QuickFixCategory_" + ((Object)((Object)this)).toString();
    }
}

