/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.DeclareFieldQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.editor.utils.VlogFunctionSignatureUtils;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;

public abstract class DeclareExternFunctionPrototypeQuickFixCommon
extends DeclareFieldQuickFix {
    private boolean isTask;
    private RfFunction function;

    protected DeclareExternFunctionPrototypeQuickFixCommon(IMarker marker, ITextViewer viewer, RfNamedElement enclosingElement, boolean isTask, boolean isStaticAccess) {
        super(marker, viewer, enclosingElement, isStaticAccess);
        this.isTask = isTask;
    }

    @Override
    public void preApplyQuickFix(IDocument document) throws Exception {
        this.targetDocument = document;
        this.targetEditor = this.getOpenEditor(this.triggerResource);
        super.preApplyQuickFix(document);
    }

    @Override
    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.triggerEditor = this.getOpenEditor(this.triggerResource);
        if (this.triggerEditor == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        this.targetDocument = document;
        this.function = ((RfDefElement)this.enclosingScope).getEnclosingScope(RfFunction.class);
        if (this.function == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        RfNamedElement classEnclosingScope = VlogQuickFixUtil.getInstance().getEnclosingScope((RfDefElement)this.enclosingScope, RfClass.class);
        if (classEnclosingScope == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        RfClass enclosingClass = (RfClass)classEnclosingScope;
        if (enclosingClass.getDeclaration() == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        int endOffset = enclosingClass.getDeclaration().getEndOffset();
        if (endOffset == -1) {
            endOffset = this.function.getStartOffset();
        }
        IRegion endLineInfo = this.targetDocument.getLineInformationOfOffset(endOffset);
        this.insertOffset = endLineInfo.getOffset();
        this.replacementString = this.createIndentedPrototype(this.function, this.insertOffset);
        this.textFileChange = new VlogTextFileChange(this.targetResource.getProjectRelativePath().toOSString(), (IFile)this.targetResource);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        InsertEdit insertEdit = new InsertEdit(this.insertOffset, this.replacementString);
        this.textFileChange.addEdit((TextEdit)insertEdit);
    }

    @Override
    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)this.targetEditor, this.targetDocument, this.getDisplayString(), (Change)this.textFileChange);
    }

    private String createIndentedPrototype(RfFunction function, int insertOffset) {
        RfNamedElement classScope = function.getEnclosingScope();
        if (!(classScope instanceof RfClass)) {
            return "";
        }
        StringBuilder resultIndentedPrototype = new StringBuilder();
        String tabOrSpace = DVTDocumentUtils.getTabOrSpace((DVTEditor)this.triggerEditor, (IPreferenceStore)VlogPlugin.getDefault().getCombinedPreferenceStore());
        String indent = String.valueOf(DVTDocumentUtils.getIndent((int)insertOffset, (IDocument)this.targetDocument)) + tabOrSpace;
        String functionPrototype = VlogFunctionSignatureUtils.computeFunctionPrototype(this.targetEditor, function, insertOffset, false);
        resultIndentedPrototype.append(String.valueOf(indent) + functionPrototype);
        return resultIndentedPrototype.toString();
    }

    @Override
    public String getDisplayString() {
        if (this.isTask) {
            return "Declare extern task prototype '" + this.elementName + "'";
        }
        return "Declare extern function prototype '" + this.elementName + "'";
    }

    @Override
    public Image getImage() {
        if (this.isTask) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_TASK);
        }
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FUNCTION);
    }

    @Override
    public IFile[] getAffectedFiles() throws Exception {
        Object[] affectedObjects = this.textFileChange.getAffectedObjects();
        IFile[] affectedFiles = new IFile[affectedObjects.length];
        int i = 0;
        while (i < affectedObjects.length) {
            Object affectedObject = affectedObjects[i];
            if (affectedObject instanceof IFile) {
                affectedFiles[i] = (IFile)affectedObject;
            }
            ++i;
        }
        return affectedFiles;
    }

    @Override
    protected String getCategory() {
        return "QuickFixCategory_" + ((Object)((Object)this)).toString();
    }
}

