/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.ui.editor.quickassist.util.VlogQuickAssistUtil;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.BaseDeclareEnumAndFieldQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.TypeName;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;
import ro.amiq.vlogdt.utils.Utils;

public abstract class DeclareFieldQuickFixCommon
extends BaseDeclareEnumAndFieldQuickFix {
    protected boolean isStatic;

    protected DeclareFieldQuickFixCommon(IMarker marker, ITextViewer viewer, RfNamedElement enclosingElement, boolean isStaticAccess) {
        super(marker, viewer, enclosingElement);
        this.isStatic = isStaticAccess;
    }

    @Override
    public void preApplyQuickFix(IDocument document) throws Exception {
        this.declaration = this.enclosingElement.getDeclaration();
        this.declareInside = true;
        if (this.enclosingElement != null && !(this.enclosingElement instanceof RfStruct)) {
            int errorStartOffset = this.marker.getAttribute("charStart", -1);
            IRfDefElement declaration = VlogQuickFixUtil.getInstance().computeDeclarationAnchor(this.enclosingElement, this.marker.getResource(), errorStartOffset >= 0 ? errorStartOffset : this.offset);
            if (declaration != null) {
                this.declareInside = false;
                this.declaration = declaration;
            }
        }
        super.preApplyQuickFix(document);
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        TypeName variableTypeName = VlogQuickFixUtil.getInstance().getVariableType(((RfDefElement)this.enclosingScope).getNamedElement(), this.elementName, this.position.offset, true, true);
        String typeName = variableTypeName.getTypeName();
        String unpackedDimension = variableTypeName.getUnpackedDim();
        unpackedDimension = unpackedDimension == null ? "" : unpackedDimension.replace("$", "$$");
        String fullTypeName = String.valueOf(this.isStatic ? "static " : "") + typeName + " " + this.elementName + unpackedDimension + ";";
        Object[] insertOffsetAndReplacementString = VlogQuickAssistUtil.computeInsertOffsetAndReplacementStringAtRootContainer(this.declaration, fullTypeName, this.declareInside, this.targetEditor, this.targetDocument);
        if (insertOffsetAndReplacementString == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        int timeScaleEndOffset = Utils.getInstance().computeInsertOffsetConsideringTimescale(this.targetDocument, (Integer)insertOffsetAndReplacementString[0], this.enclosingElement.getDeclaration());
        this.insertOffset = timeScaleEndOffset > (Integer)insertOffsetAndReplacementString[0] ? timeScaleEndOffset : (Integer)insertOffsetAndReplacementString[0];
        this.replacementString = (String)insertOffsetAndReplacementString[1];
        this.updateReplacementStringAndInsertOffset(document, timeScaleEndOffset);
        this.textFileChange = new VlogTextFileChange(this.targetResource.getProjectRelativePath().toOSString(), (IFile)this.targetResource);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        InsertEdit insertEdit = new InsertEdit(this.insertOffset, this.replacementString);
        this.textFileChange.addEdit((TextEdit)insertEdit, (IRegion)new Region(this.replacementString.indexOf(typeName), typeName.length()));
    }

    public Image getImage() {
        if (this.enclosingElement instanceof IRfDesignElement) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_SIGNAL);
        }
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
    }

    public String getDisplayString() {
        return "Declare field '" + this.elementName + "'";
    }

    @Override
    protected String getCategory() {
        return "QuickFixCategory_" + ((Object)((Object)this)).toString();
    }

    protected abstract void updateReplacementStringAndInsertOffset(IDocument var1, int var2) throws BadLocationException;
}

