/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.MethodSignatureUseCase;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.ui.editor.quickassist.util.QuickAssistIfLoopCaseHidVisitor;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.CollectHidAccessArgsInRegionVisitor;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.DeclareFieldQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.TypeName;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;
import ro.amiq.vlogdt.ui.views.templates.VlogMethodTemplateConfig;
import ro.amiq.vlogdt.ui.views.templates.VlogMethodTemplateInserter;

public abstract class DeclareFunctionQuickFixCommon
extends DeclareFieldQuickFix {
    private static final String ARGUMENT = "arg_";
    private static final String NEWLINE = System.lineSeparator();
    private boolean fIsTask;
    private boolean fIsHierarchical;
    private int fArgumentsEndOffset;
    protected int fInsertOffset;
    private int fArgCounter;
    private List<IRegion> fSingleLinkedPositionRegions;
    private Map<String, List<IRegion>> fMultipleLinkedPositionRegions;
    private String fFunctionSignature;
    private Set<String> fAllBoxedArgType;
    private Set<String> fAllBoxedArgName;
    private String fReturnType = "";
    private IProgressMonitor fProgressMonitor;
    private RfFunction fChildPrototype;
    private int fMasterOffset = -1;
    private RfProject fRfProject;

    protected DeclareFunctionQuickFixCommon(IMarker marker, ITextViewer viewer, RfNamedElement enclosingElem, boolean isTask, boolean isHierarchical, boolean isStaticAccess, RfProject rfProject, IProgressMonitor progressMonitor) {
        super(marker, viewer, enclosingElem, isStaticAccess);
        this.fIsTask = isTask;
        this.fIsHierarchical = isHierarchical;
        this.fArgCounter = 0;
        this.fSingleLinkedPositionRegions = new ArrayList<IRegion>();
        this.fMultipleLinkedPositionRegions = new LinkedHashMap<String, List<IRegion>>();
        this.fAllBoxedArgName = new LinkedHashSet<String>();
        this.fAllBoxedArgType = new LinkedHashSet<String>();
        this.fProgressMonitor = progressMonitor;
        this.fRfProject = rfProject;
    }

    private String getDisplayName() {
        String fullName;
        String displayStringName = String.valueOf(this.elementName) + "()";
        if (this.enclosingElement != null && (fullName = this.enclosingElement.getFullName()) != null && !fullName.isEmpty()) {
            displayStringName = String.valueOf(fullName) + "." + displayStringName;
        }
        return displayStringName;
    }

    @Override
    public Image getImage() {
        if (this.fIsTask) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_TASK);
        }
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FUNCTION);
    }

    @Override
    public String getDisplayString() {
        if (this.fIsTask) {
            return "Declare task '" + this.getDisplayName() + "'";
        }
        return "Declare function '" + this.getDisplayName() + "'";
    }

    @Override
    public void preApplyQuickFix(IDocument document) throws Exception {
        this.triggerDocument = document;
        this.triggerEditor = this.getOpenEditor(this.triggerResource);
        super.preApplyQuickFix(document);
    }

    @Override
    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.targetEditor = this.getOpenEditor(this.targetResource);
        if (this.targetEditor == null) {
            return;
        }
        this.targetDocument = document;
        if (!this.computeChange()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    public void addLinkedPositions() throws Exception {
        this.computeAllLinkedRegions();
        this.linkedPositionProvider = new DVTLinkedPositionProvider(this.targetEditor, this.linkedProposalModel, this.getCategory(), true, this.textFileChange);
        boolean isLinkedPosition = false;
        if (!this.fSingleLinkedPositionRegions.isEmpty()) {
            isLinkedPosition = true;
            for (IRegion iRegion : this.fSingleLinkedPositionRegions) {
                this.linkedPositionProvider.addSingleLinkedPosition(iRegion.getOffset(), iRegion.getLength(), this.targetDocument);
            }
        }
        if (!this.fMultipleLinkedPositionRegions.isEmpty()) {
            isLinkedPosition = true;
            for (Map.Entry entry : this.fMultipleLinkedPositionRegions.entrySet()) {
                this.linkedPositionProvider.addMultipleLinkedPosition((Collection)entry.getValue(), this.targetDocument, this.fMasterOffset);
            }
        }
        if (isLinkedPosition) {
            this.linkedPositionProvider.enterLinkedMode(this.targetDocument, null);
        }
    }

    private boolean computeChange() throws Exception {
        RfFunction triggerFunction;
        boolean isDeclareInHierarchical = false;
        RfFunction rfFunction = triggerFunction = this.enclosingScope.getNamedElement() instanceof RfFunction ? (RfFunction)this.enclosingScope.getNamedElement() : (RfFunction)this.enclosingScope.getNamedElement().getEnclosingScope(RfFunction.class);
        if (triggerFunction == null || this.enclosingElement instanceof RfClass && !this.enclosingElement.equals(triggerFunction.getEnclosingScope(RfClass.class))) {
            RfDefElement declaration = this.enclosingElement.getDeclaration();
            if (declaration == null) {
                return false;
            }
            this.fInsertOffset = declaration.getEndOffset();
            isDeclareInHierarchical = true;
        } else {
            this.fInsertOffset = VlogQuickFixUtil.getInstance().computeNewMethodInsertOffset(triggerFunction, this.targetDocument);
        }
        if (this.fInsertOffset < 0) {
            return false;
        }
        String indent = this.getIndent(isDeclareInHierarchical);
        int positionOffset = this.position.getOffset();
        int bracketOffset = DVTDocumentUtils.getCharOffset((char)'(', (int)positionOffset, (boolean)true, (int)100, (IDocument)this.triggerDocument, (String)"__vlog_partitioning");
        ICharacterPairMatcher bracketMatcher = this.triggerEditor.getBracketMatcher();
        IRegion closedBracketRegion = bracketMatcher.match(this.triggerDocument, bracketOffset);
        if (closedBracketRegion != null) {
            this.fArgumentsEndOffset = closedBracketRegion.getOffset() + closedBracketRegion.getLength();
        }
        if (this.fIsHierarchical) {
            this.computeChildPrototype();
        }
        String functionName = this.elementName;
        IRfNamedElement triggerEnclosingScope = this.enclosingScope.getNamedElement();
        RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)triggerEnclosingScope, triggerEnclosingScope.getRfProject(), 14);
        String functionArgs = this.getFunctionArgs(resolver, triggerEnclosingScope, false);
        String argsName = this.getFunctionArgs(resolver, triggerEnclosingScope, true);
        if (!this.fIsTask) {
            this.fReturnType = this.getFunctionReturnType(triggerEnclosingScope);
        }
        VlogMethodTemplateConfig config = (VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)new VlogMethodTemplateConfig().setTemplate("method_implementation")).setEditor((IEditorPart)this.targetEditor)).setDocument(this.targetDocument)).setDocumentOffset(this.insertOffset)).setCursorScope((RfNamedElement)triggerEnclosingScope).setJavadocParamDescription("description")).setIndent(indent)).setSecondaryIndent(DVTDocumentUtils.getIndent((int)this.fInsertOffset, (IDocument)this.targetDocument))).setVirtualQualifier(this.fChildPrototype != null).setStaticQualifier(this.isStatic).setKind(this.fIsTask ? "task" : "function").setReturnType(this.fReturnType).setIdentifier(functionName).setUnqualifiedIdentifier(functionName).setArguments(functionArgs).setArgumentNames(argsName).setBody("// TODO Auto-generated " + (this.fIsTask ? "task" : "function") + " stub").setEndKeyword(this.fIsTask ? "endtask" : "endfunction").setLeadingNewlines(isDeclareInHierarchical ? 0 : 2)).setTrailingNewlines(isDeclareInHierarchical ? 0 : -1)).setIndentNewlines(false)).setIndentFirstLine(false)).setIndentStepOnFirstLine(true)).setSecondaryIndentOnLastLine(true);
        this.fFunctionSignature = new VlogMethodTemplateInserter(config).parse();
        RfFileDef targetFile = this.enclosingElement.getFile();
        this.textFileChange = new VlogTextFileChange(targetFile.getFileAdapter().getProjectRelativePath().toOSString(), (IFile)targetFile.getFileAdapter());
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        InsertEdit insertEdit = new InsertEdit(this.fInsertOffset, this.fFunctionSignature);
        this.textFileChange.addEdit((TextEdit)insertEdit);
        return true;
    }

    private void computeChildPrototype() {
        RfClass superClass = this.enclosingElement.getEnclosingScope(RfClass.class);
        if (superClass != null) {
            this.fChildPrototype = this.getFunctionPrototypeFromChildren(superClass, this.elementName, this.fIsTask);
        }
    }

    private String getFunctionReturnType(IRfNamedElement element) {
        DataType dataType;
        if (this.fChildPrototype != null && (dataType = this.fChildPrototype.getDataType()) != null) {
            return dataType.getTypeNameWithParamAssignments();
        }
        TypeName typeName = VlogQuickFixUtil.getInstance().getVariableType((RfNamedElement)this.enclosingScope.getNamedElement(), this.elementName, false);
        if (typeName == null || typeName.getTypeName() == null || typeName.getTypeName().isEmpty()) {
            QuickAssistIfLoopCaseHidVisitor isInIfLoopCaseVisitor = new QuickAssistIfLoopCaseHidVisitor(this.position.offset, this.position.offset + this.position.length);
            element.visitHidObject(null, (IHidVisitor)isInIfLoopCaseVisitor);
            if (isInIfLoopCaseVisitor.isInIfCaseLoop()) {
                return "integer";
            }
            return "void";
        }
        return typeName.getTypeName();
    }

    private String getFunctionArgs(RfTypesResolver resolver, IRfNamedElement element, boolean justArgsName) {
        if (this.fChildPrototype != null) {
            if (justArgsName) {
                return this.fChildPrototype.printArguments(resolver, false, null, false, false, MethodSignatureUseCase.METHOD_CALL, false);
            }
            return this.fChildPrototype.printArguments(resolver, true, null, false, true, MethodSignatureUseCase.METHOD_OVERRIDE_CODE_GENERATION, false);
        }
        CollectHidAccessArgsInRegionVisitor hidsInSelectionVisitor = new CollectHidAccessArgsInRegionVisitor(this.elementName, (IRegion)new Region(this.position.offset, this.fArgumentsEndOffset - this.position.offset));
        element.visitHidObject(null, (IHidVisitor)hidsInSelectionVisitor);
        List<? extends IHidObject> argumentsHid = hidsInSelectionVisitor.getArgsInRegion();
        ArrayList<String> functionArgsList = new ArrayList<String>();
        ArrayList<String> functionArgNamesList = new ArrayList<String>();
        for (IHidObject iHidObject : argumentsHid) {
            StringBuilder argument = new StringBuilder();
            String[] argumentTypeAndName = this.getArgumentsTypeAndNameFromHids(resolver, iHidObject, justArgsName, element, hidsInSelectionVisitor.getParserPath());
            if (argumentTypeAndName == null) continue;
            if (!justArgsName) {
                String typeAndName = String.valueOf(argumentTypeAndName[0]) + " " + argumentTypeAndName[1];
                argument.append(typeAndName);
                functionArgsList.add(argument.toString());
                continue;
            }
            functionArgNamesList.add(argumentTypeAndName[1]);
        }
        if (justArgsName) {
            return DVTStringUtil.join((Object[])functionArgNamesList.toArray(), (String)", ");
        }
        return DVTStringUtil.join((Object[])functionArgsList.toArray(), (String)", ");
    }

    private String[] getArgumentsTypeAndNameFromHids(RfTypesResolver resolver, IHidObject hidObject, boolean justArgsName, IRfNamedElement scope, ParserPath parserPath) {
        String[] typeAndName = new String[2];
        if (hidObject == null) {
            return null;
        }
        String argumentType = "";
        String argumentName = "";
        TypeName typeName = VlogQuickFixUtil.getInstance().computeTypeNameAndDimFromHidObject(resolver, hidObject, scope, parserPath, this.fRfProject);
        if (typeName == null) {
            typeAndName[0] = "integer";
            typeAndName[1] = ARGUMENT + this.fArgCounter++;
            return typeAndName;
        }
        argumentType = typeName.getTypeName();
        if (hidObject instanceof RfHidAccessArgs) {
            hidObject = ((RfHidAccessArgs)hidObject).getParentHid();
        }
        if (hidObject instanceof RfHid) {
            RfHid hid = (RfHid)hidObject;
            IRfNamedElement hidElement = hid.getElement();
            if (hidElement == null || hid.getName().isEmpty()) {
                argumentName = ARGUMENT + this.fArgCounter;
                ++this.fArgCounter;
            } else {
                argumentName = hidElement.getName();
                if (hidElement instanceof RfField && ((RfField)hidElement).isEnumElement()) {
                    argumentName = ARGUMENT + this.fArgCounter;
                    ++this.fArgCounter;
                }
            }
        } else {
            argumentName = ARGUMENT + this.fArgCounter;
            ++this.fArgCounter;
        }
        typeAndName[1] = argumentName;
        String packedDim = typeName.getPackedDim();
        if (packedDim != null && !packedDim.isEmpty() && !argumentType.contains(packedDim)) {
            argumentType = String.valueOf(argumentType) + packedDim;
        }
        this.fAllBoxedArgType.add(argumentType);
        typeAndName[0] = argumentType;
        String unpackedDim = typeName.getUnpackedDim();
        if (unpackedDim != null && !unpackedDim.isEmpty() && !argumentName.contains(unpackedDim)) {
            argumentName = String.valueOf(argumentName) + " " + typeName.getUnpackedDim();
        }
        this.fAllBoxedArgName.add(argumentName);
        if (!justArgsName) {
            typeAndName[1] = argumentName;
        }
        return typeAndName;
    }

    @Override
    protected String getCategory() {
        return "QuickFixCategory_" + ((Object)((Object)this)).toString();
    }

    private void computeAllLinkedRegions() throws CoreException {
        String[] functionSignatureArray = DVTStringUtil.split((String)NEWLINE, (String)this.fFunctionSignature);
        if (functionSignatureArray == null || functionSignatureArray.length == 0) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        StringBuilder signatureFirstLine = new StringBuilder("");
        String[] stringArray = functionSignatureArray;
        int n = functionSignatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!(line.trim().isEmpty() || line.trim().startsWith("/**") || line.trim().startsWith("*") || line.trim().startsWith("*/"))) {
                signatureFirstLine.append(line);
                break;
            }
            signatureFirstLine.append(String.valueOf(line) + NEWLINE);
            ++n2;
        }
        if (this.fReturnType != null && !this.fReturnType.isEmpty()) {
            this.addLinkedRegionForWord(signatureFirstLine.toString(), this.fReturnType);
        }
        for (String argsType : this.fAllBoxedArgType) {
            if (argsType.equals(this.fReturnType)) continue;
            this.addLinkedRegionForWord(signatureFirstLine.toString(), argsType);
        }
        for (String argsName : this.fAllBoxedArgName) {
            this.addMultipleLinkedRegionForWord(signatureFirstLine.toString(), argsName);
        }
        this.addLinkedRegionForWord(signatureFirstLine.toString(), "description");
    }

    private void addLinkedRegionForWord(String text, String word) {
        Matcher matcher = Pattern.compile("\\b" + word + "\\b").matcher("");
        int regionOffset = 0;
        int regionLength = word.length();
        matcher.reset(text);
        while (matcher.find()) {
            regionOffset = matcher.start();
            int correctRegionOffset = this.fInsertOffset + regionOffset;
            if (this.fMasterOffset < 0) {
                this.fMasterOffset = correctRegionOffset;
            }
            Region wordRegion = new Region(correctRegionOffset, regionLength);
            this.fSingleLinkedPositionRegions.add((IRegion)wordRegion);
        }
    }

    private void addMultipleLinkedRegionForWord(String text, String word) {
        Matcher matcher = Pattern.compile("\\b" + word + "\\b").matcher("");
        int regionOffset = 0;
        int regionLength = word.length();
        if (!this.fMultipleLinkedPositionRegions.containsKey(word)) {
            this.fMultipleLinkedPositionRegions.put(word, new ArrayList());
        }
        matcher.reset(text);
        while (matcher.find()) {
            regionOffset = matcher.start();
            int correctRegionOffset = this.fInsertOffset + regionOffset;
            if (this.fMasterOffset < 0) {
                this.fMasterOffset = correctRegionOffset;
            }
            Region wordRegion = new Region(correctRegionOffset, regionLength);
            this.fMultipleLinkedPositionRegions.get(word).add((IRegion)wordRegion);
        }
    }

    @Override
    public IFile[] getAffectedFiles() throws Exception {
        Object[] affectedObjects = this.textFileChange.getAffectedObjects();
        IFile[] affectedFiles = new IFile[affectedObjects.length];
        int i = 0;
        while (i < affectedObjects.length) {
            Object affectedObject = affectedObjects[i];
            if (affectedObject instanceof IFile) {
                affectedFiles[i] = (IFile)affectedObject;
            }
            ++i;
        }
        return affectedFiles;
    }

    private RfFunction getFunctionPrototypeFromChildren(RfClass root, String functionName, boolean isTask) {
        Set<RfClass> children = root.getChildren();
        if (children == null || children.isEmpty()) {
            return null;
        }
        for (RfClass childClass : children) {
            RfFunction function;
            if (this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
                return null;
            }
            RfFunction rfFunction = function = isTask ? childClass.getLocalTask(functionName) : childClass.getLocalFunction(functionName);
            if (function == null) {
                function = this.getFunctionPrototypeFromChildren(childClass, functionName, isTask);
            }
            if (function == null || function.isPrivate()) continue;
            return function;
        }
        return null;
    }

    protected abstract String getIndent(boolean var1);
}

