/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.quickfix.quickfixes.QuickFixException;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.AbstractVariableQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.TypeName;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;

public abstract class DeclareVariableQuickFixCommon
extends AbstractVariableQuickFix {
    private String fReplacementString;
    protected int fInsertOffset;
    protected static final String NEWLINE = System.lineSeparator();
    private String typeName;

    protected DeclareVariableQuickFixCommon(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
        this.linkedProposalModel = new LinkedModeModel();
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_VARIABLE);
    }

    public String getDisplayString() {
        return "Declare variable '" + this.elementName + "'";
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.fInsertOffset = this.offset;
        AbstractVariableQuickFix.DeclareVariableOffsetInfo declareVarInfo = this.guessOffsetToDeclareVariable((RfDefElement)this.enclosingScope, this.elementName);
        int[] offsetPair = declareVarInfo.getOffsetPair();
        boolean isInsideLoop = declareVarInfo.isInsideLoop();
        ArrayDeque<RfDefElement> scopeStack = new ArrayDeque<RfDefElement>();
        ((RfFileDef)this.enclosingScope.getDefFile()).getScope(this.fInsertOffset, true, scopeStack);
        RfDefElement currScopeDef = null;
        RfDefElement prevScopeDef = null;
        if (!scopeStack.isEmpty()) {
            boolean containsMaxOffset;
            boolean containsMinOffset;
            boolean forceToContinue = false;
            do {
                prevScopeDef = currScopeDef;
                currScopeDef = (RfDefElement)scopeStack.pop();
                containsMinOffset = currScopeDef.containsOffset(offsetPair[0]);
                containsMaxOffset = currScopeDef.containsOffset(offsetPair[1]);
            } while ((forceToContinue = (!containsMinOffset || !containsMaxOffset) && !scopeStack.isEmpty()) || !scopeStack.isEmpty() && currScopeDef instanceof RfActionBlockDef && !((RfActionBlock)currScopeDef.getNamedElement()).hasBeginOrFork() && !((RfActionBlock)currScopeDef.getNamedElement()).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS));
        }
        if (prevScopeDef != null && currScopeDef instanceof RfActionBlockDef && ((RfActionBlock)currScopeDef.getNamedElement()).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS) && !isInsideLoop) {
            currScopeDef = prevScopeDef;
        }
        if (currScopeDef == null) {
            throw new QuickFixException();
        }
        this.fReplacementString = "";
        this.computeOffsetAndReplacementString(currScopeDef.getNamedElement(), document, currScopeDef, editorChanged, isInsideLoop);
        this.textFileChange = new VlogTextFileChange(this.targetResource.getProjectRelativePath().toOSString(), (IFile)this.targetResource);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        InsertEdit insertEdit = new InsertEdit(this.fInsertOffset, this.fReplacementString);
        this.textFileChange.addEdit((TextEdit)insertEdit, (IRegion)new Region(this.fReplacementString.indexOf(this.typeName), this.typeName.length()));
    }

    protected void addLinkedPosition() throws Exception {
        Collection absoluteRegions = this.textFileChange.getAbsoluteRegions();
        if (absoluteRegions == null || absoluteRegions.isEmpty()) {
            return;
        }
        this.linkedPositionProvider = new DVTLinkedPositionProvider(this.targetEditor, this.linkedProposalModel, this.getCategory(), true, this.textFileChange);
        this.linkedPositionProvider.addMultipleLinkedPosition(absoluteRegions, this.targetDocument, this.triggerEditor.getCursor());
        this.linkedPositionProvider.enterLinkedMode(this.targetDocument, null);
    }

    protected String getCategory() {
        return "QuickFixCategory_" + ((Object)((Object)this)).toString();
    }

    public IFile[] getAffectedFiles() throws Exception {
        IResource elementResource = this.enclosingScope.getFileAdapter();
        if (elementResource == null || !(elementResource instanceof IFile)) {
            return null;
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)elementResource);
        return affectedFiles.toArray(new IFile[1]);
    }

    private void computeOffsetAndReplacementString(RfNamedElement enclosingElement, IDocument document, RfDefElement currScopeDef, boolean editorChanged, boolean isInsideLoop) throws Exception {
        TypeName variableTypeName = VlogQuickFixUtil.getInstance().getVariableType(currScopeDef.getNamedElement(), this.elementName, this.position.offset, true, true);
        this.typeName = variableTypeName.getTypeName();
        String unpackedDimension = variableTypeName.getUnpackedDim() == null ? "" : variableTypeName.getUnpackedDim();
        String prefix = "";
        String sufix = "";
        if (currScopeDef instanceof RfActionBlockDef && !((RfActionBlock)currScopeDef.getNamedElement()).hasBeginOrFork() && !isInsideLoop) {
            IRegion lineInfo = document.getLineInformationOfOffset(currScopeDef.getStartOffset());
            this.fInsertOffset = lineInfo.getOffset();
            String indent = document.get(lineInfo.getOffset(), lineInfo.getLength());
            int index = indent.indexOf(indent.trim());
            indent = indent.substring(0, index);
            this.fReplacementString = String.valueOf(this.fReplacementString) + indent + this.typeName + " " + this.elementName + unpackedDimension + ";" + NEWLINE;
            return;
        }
        String indent = DVTDocumentUtils.getIndent((int)currScopeDef.getStartOffset(), (IDocument)document);
        indent = String.valueOf(indent) + VlogQuickFixUtil.getInstance().getTabOrSpaces(this.triggerEditor, document);
        VlogQuickFixUtil quickFixUtilsInstance = VlogQuickFixUtil.getInstance();
        if (currScopeDef instanceof RfFunctionDef) {
            this.fInsertOffset = quickFixUtilsInstance.getForwardOffsetFor(document, ";", currScopeDef.getStartOffset(), currScopeDef.getEndOffset(), true);
            sufix = NEWLINE;
        } else {
            RfActionBlock actionBlock;
            RfActionBlock rfActionBlock = actionBlock = currScopeDef instanceof RfActionBlockDef ? (RfActionBlock)currScopeDef.getNamedElement() : null;
            if (actionBlock == null) {
                throw new QuickFixException();
            }
            if (actionBlock.isSimpleBeginEnd() || actionBlock.isSimpleForkJoin()) {
                if (actionBlock.isNamedBlock()) {
                    this.fInsertOffset = this.getOffsetForNamedBlock(document, currScopeDef, actionBlock, false);
                    sufix = NEWLINE;
                } else {
                    this.fInsertOffset = this.computeInsertOffset(document, currScopeDef.getStartOffset());
                }
                prefix = this.getPrefix();
                sufix = String.valueOf(sufix) + this.getSufix();
            } else if (actionBlock.hasBeginEnd() || actionBlock.hasForkJoin()) {
                sufix = NEWLINE;
                if (actionBlock.isNamedBlock()) {
                    this.fInsertOffset = this.getOffsetForNamedBlock(document, currScopeDef, actionBlock, false);
                    prefix = this.getPrefix();
                    sufix = String.valueOf(sufix) + this.getSufix();
                } else {
                    this.fInsertOffset = quickFixUtilsInstance.getForwardOffsetFor(document, actionBlock.hasBeginEnd() ? "begin" : "fork", currScopeDef.getStartOffset(), currScopeDef.getEndOffset(), true);
                }
            }
        }
        int errorStartOffset = this.marker != null ? this.marker.getAttribute("charStart", -1) : this.position.getOffset();
        IRfDefElement declarationAnchor = VlogQuickFixUtil.getInstance().computeDeclarationAnchor(enclosingElement, this.marker != null ? this.marker.getResource() : null, errorStartOffset >= 0 ? errorStartOffset : this.offset);
        if (declarationAnchor instanceof RfFieldDef) {
            this.fInsertOffset = this.computeInsertOffset(document, declarationAnchor.getEndOffset());
            prefix = this.getPrefix();
            sufix = this.getSufix();
        }
        prefix = String.valueOf(prefix) + indent;
        this.fReplacementString = String.valueOf(this.fReplacementString) + prefix + this.typeName + " " + this.elementName + unpackedDimension + ";" + sufix;
    }

    private int getOffsetForNamedBlock(IDocument document, RfDefElement currScopeDef, RfActionBlock actionBlock, boolean grabNewline) throws BadLocationException {
        int insertOffset = VlogQuickFixUtil.getInstance().getForwardOffsetFor(document, actionBlock.getName(), currScopeDef.getStartOffset(), currScopeDef.getEndOffset(), grabNewline);
        if (insertOffset == currScopeDef.getEndOffset()) {
            insertOffset = VlogQuickFixUtil.getInstance().getBackwardOffsetFor(document, actionBlock.getName(), Math.max(0, currScopeDef.getStartOffset() - 1000), currScopeDef.getStartOffset(), grabNewline);
        }
        return this.computeInsertOffset(document, insertOffset);
    }

    protected abstract int computeInsertOffset(IDocument var1, int var2) throws BadLocationException;

    protected abstract String getSufix();

    protected abstract String getPrefix();
}

